/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.fx.core.AppMemento;
import org.eclipse.fx.core.ObjectSerializer;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={IContextFunction.class}, property={"service.context.key=org.eclipse.fx.core.AppMemento"})
public class AppMementoCF
extends ContextFunction {
    List<ObjectSerializer> serializers = new ArrayList<ObjectSerializer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MULTIPLE)
    public void registerObjectSerializer(ObjectSerializer serializer) {
        List<ObjectSerializer> list = this.serializers;
        synchronized (list) {
            this.serializers.add(serializer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObjectSerializer(ObjectSerializer serializer) {
        List<ObjectSerializer> list = this.serializers;
        synchronized (list) {
            this.serializers.remove(serializer);
        }
    }

    public Object compute(IEclipseContext context) {
        MApplication mApplication = (MApplication)context.get(MApplication.class);
        if (mApplication == null) {
            return null;
        }
        return new AppMementoImpl(mApplication.getPersistedState());
    }

    class AppMementoImpl
    implements AppMemento {
        private final Map<String, String> map;
        private static final String TYPE_PREFIX = "__type_";

        public AppMementoImpl(Map<String, String> map) {
            this.map = map;
        }

        private void _put(String key, Object value, String type) {
            this.map.put(key, value == null ? null : value.toString());
            this.map.put(TYPE_PREFIX + key, type);
        }

        public String _get(String key, String defaultValue, String type) {
            String rv = defaultValue;
            rv = this.map.get(key);
            if (rv == null) {
                rv = defaultValue;
            }
            return rv;
        }

        public void put(String key, String value) {
            this._put(key, value, String.class.getName());
        }

        public void put(String key, boolean value) {
            this._put(key, value, Boolean.TYPE.getName());
        }

        public void put(String key, int value) {
            this._put(key, value, Integer.TYPE.getName());
        }

        public void put(String key, double value) {
            this._put(key, value, Double.TYPE.getName());
        }

        public void remove(String key) {
            this.map.remove(key);
            this.map.remove(TYPE_PREFIX + key);
        }

        public boolean exists(String key) {
            return this.map.containsKey(key);
        }

        public String get(String key, String defaultValue) {
            return this._get(key, defaultValue, String.class.getName());
        }

        public boolean get(String key, boolean defaultValue) {
            String rv = this._get(key, Boolean.valueOf(defaultValue).toString(), Boolean.TYPE.getName());
            return Boolean.parseBoolean(rv);
        }

        public int get(String key, int defaultValue) {
            String rv = this._get(key, Integer.valueOf(defaultValue).toString(), Integer.TYPE.getName());
            return Integer.parseInt(rv);
        }

        public double get(String key, double defaultValue) {
            String rv = this._get(key, Double.valueOf(defaultValue).toString(), Double.TYPE.getName());
            return Double.parseDouble(rv);
        }

        public <O> O get(String key, Class<O> clazz, O defaultValue) {
            List<ObjectSerializer> list = AppMementoCF.this.serializers;
            synchronized (list) {
                String serializer = this.map.get(TYPE_PREFIX + key);
                if (serializer == null) {
                    return defaultValue;
                }
                String value = this.map.get(key);
                if (value == null) {
                    return defaultValue;
                }
                serializer = serializer.substring("serialized:".length());
                for (ObjectSerializer s : AppMementoCF.this.serializers) {
                    if (!s.getId().equals(serializer)) continue;
                    return (O)s.deserialize(clazz, value);
                }
                throw new IllegalArgumentException("The serializer '" + serializer + "' is not known");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(@NonNull String key, Object value, String serializer) {
            if (value == null) {
                this._put(key, null, "serialized:" + serializer);
            }
            List<ObjectSerializer> list = AppMementoCF.this.serializers;
            synchronized (list) {
                for (ObjectSerializer s : AppMementoCF.this.serializers) {
                    if (!s.getId().equals(serializer)) continue;
                    this._put(key, s.serialize(value), "serialized:" + serializer);
                    return;
                }
            }
            throw new IllegalArgumentException("The serializer '" + serializer + "' is not known");
        }
    }
}

