/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.databinding.internal;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;

public class FXBeanPropertyHelper {
    public static void writeProperty(Object source, PropertyDescriptor propertyDescriptor, Object value) {
        try {
            Method writeMethod = propertyDescriptor.getWriteMethod();
            if (writeMethod == null) {
                throw new IllegalArgumentException("Missing public setter method for " + propertyDescriptor.getName() + " property");
            }
            if (!writeMethod.isAccessible()) {
                writeMethod.setAccessible(true);
            }
            writeMethod.invoke(source, value);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception exception) {}
    }

    public static Object readProperty(Object source, PropertyDescriptor propertyDescriptor) {
        try {
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod == null) {
                throw new IllegalArgumentException(String.valueOf(propertyDescriptor.getName()) + " property does not have a read method.");
            }
            if (!readMethod.isAccessible()) {
                readMethod.setAccessible(true);
            }
            return readMethod.invoke(source, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Class<?> getCollectionPropertyElementType(PropertyDescriptor descriptor) {
        Class<?> propertyType = descriptor.getPropertyType();
        return propertyType.isArray() ? propertyType.getComponentType() : Object.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PropertyDescriptor getPropertyDescriptor(Class<?> beanClass, String propertyName) {
        if (!beanClass.isInterface()) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(beanClass);
            }
            catch (IntrospectionException introspectionException) {
                return null;
            }
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            int i = 0;
            while (i < propertyDescriptors.length) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                if (descriptor.getName().equals(propertyName)) {
                    return descriptor;
                }
                ++i;
            }
            throw new IllegalArgumentException("Could not find property with name " + propertyName + " in class " + beanClass);
        }
        try {
            ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
            FXBeanPropertyHelper.getInterfacePropertyDescriptors(pds, beanClass);
            if (pds.size() <= 0) throw new IllegalArgumentException("Could not find property with name " + propertyName + " in class " + beanClass);
            PropertyDescriptor[] propertyDescriptors = pds.toArray(new PropertyDescriptor[pds.size()]);
            int i = 0;
            while (i < propertyDescriptors.length) {
                PropertyDescriptor descriptor = propertyDescriptors[i];
                if (descriptor.getName().equals(propertyName)) {
                    return descriptor;
                }
                ++i;
            }
            throw new IllegalArgumentException("Could not find property with name " + propertyName + " in class " + beanClass);
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    private static void getInterfacePropertyDescriptors(List<PropertyDescriptor> propertyDescriptors, Class<?> iface) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(iface);
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < pds.length) {
            PropertyDescriptor pd = pds[i];
            propertyDescriptors.add(pd);
            ++i;
        }
        Class<?>[] subIntfs = iface.getInterfaces();
        int j = 0;
        while (j < subIntfs.length) {
            FXBeanPropertyHelper.getInterfacePropertyDescriptors(propertyDescriptors, subIntfs[j]);
            ++j;
        }
    }

    public static PropertyDescriptor getValueTypePropertyDescriptor(IObservableValue observable, String propertyName) {
        if (observable.getValueType() != null) {
            return FXBeanPropertyHelper.getPropertyDescriptor((Class)observable.getValueType(), propertyName);
        }
        return null;
    }

    public static String propertyName(PropertyDescriptor propertyDescriptor) {
        Class<?> beanClass = propertyDescriptor.getReadMethod().getDeclaringClass();
        return String.valueOf(FXBeanPropertyHelper.shortClassName(beanClass)) + "." + propertyDescriptor.getName();
    }

    public static String shortClassName(Class<?> beanClass) {
        if (beanClass == null) {
            return "?";
        }
        String className = beanClass.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            className = className.substring(lastDot + 1);
        }
        return className;
    }
}

