/**
 * Copyright (c) 2004-2011 QOS.ch
 * All rights reserved.
 *
 * Permission is hereby granted, free  of charge, to any person obtaining
 * a  copy  of this  software  and  associated  documentation files  (the
 * "Software"), to  deal in  the Software without  restriction, including
 * without limitation  the rights to  use, copy, modify,  merge, publish,
 * distribute,  sublicense, and/or sell  copies of  the Software,  and to
 * permit persons to whom the Software  is furnished to do so, subject to
 * the following conditions:
 *
 * The  above  copyright  notice  and  this permission  notice  shall  be
 * included in all copies or substantial portions of the Software.
 *
 * THE  SOFTWARE IS  PROVIDED  "AS  IS", WITHOUT  WARRANTY  OF ANY  KIND,
 * EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF
 * MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */
package org.slf4j.profiler;

public class SpacePadder {
  public static final String LINE_SEP = System.getProperty("line.separator");
  
  final static String[] SPACES = { " ", "  ", "    ", "        ", // 1,2,4,8
      // spaces
      "                ", // 16 spaces
      "                                " }; // 32 spaces

  final static public void leftPad(StringBuffer buf, String s, int desiredLength) {
    int actualLen = 0;
    if (s != null) {
      actualLen = s.length();
    }
    if (actualLen < desiredLength) {
      spacePad(buf, desiredLength - actualLen);
    }
    if (s != null) {
      buf.append(s);
    }
  }

  final static public void rightPad(StringBuffer buf, String s, int desiredLength) {
    int actualLen = 0;
    if (s != null) {
      actualLen = s.length();
    }
    if (s != null) {
      buf.append(s);
    }
    if (actualLen < desiredLength) {
      spacePad(buf, desiredLength - actualLen);
    }
  }
  
  /**
   * Fast space padding method.
   * 
   * @param sbuf the buffer to pad
   * @param length the target size of the buffer after padding
   */
  final static public void spacePad(StringBuffer sbuf, int length) {
    while (length >= 32) {
      sbuf.append(SPACES[5]);
      length -= 32;
    }

    for (int i = 4; i >= 0; i--) {
      if ((length & (1 << i)) != 0) {
        sbuf.append(SPACES[i]);
      }
    }
  }
}
