/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.bindings;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.binding.ListBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.fx.core.DisposeableCollector;
import org.eclipse.fx.core.Status;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.Tuple;
import org.eclipse.fx.core.bindings.BindingStream;
import org.eclipse.fx.core.bindings.FXCollector;
import org.eclipse.fx.core.bindings.internal.BaseBidiPropertyBinding;
import org.eclipse.fx.core.bindings.internal.BindingStreamImpl;
import org.eclipse.fx.core.bindings.internal.ConcatListBinding;
import org.eclipse.fx.core.bindings.internal.ConcatStringBinding;
import org.eclipse.fx.core.bindings.internal.FixListBinding;
import org.eclipse.fx.core.bindings.internal.FlatMapListBinding;
import org.eclipse.fx.core.bindings.internal.FlatMapValueListBinding;
import org.eclipse.fx.core.bindings.internal.MapListBinding;
import org.eclipse.fx.core.bindings.internal.MapObjectBinding;
import org.eclipse.fx.core.bindings.internal.MapSimpleObjectBinding;
import org.eclipse.fx.core.bindings.internal.SyncListBinding;
import org.eclipse.fx.core.bindings.internal.SyncObjectBinding;
import org.eclipse.fx.core.bindings.internal.TenaryBinding;

public class FXBindings {
    @SafeVarargs
    public static <T> ObservableList<T> concatenatedList(ObservableList<? extends T> ... lists) {
        return new ConcatListHelper<T>(lists).roConcatedList;
    }

    public static <T> BindingStream<T> bindStream(ObservableValue<T> source) {
        return new BindingStreamImpl(source);
    }

    public static <T> Binding<T> tenaryBinding(ObservableBooleanValue condition, ObservableValue<T> then, ObservableValue<T> _else) {
        return new TenaryBinding<ObservableValue<T>>(condition, then, _else);
    }

    public static <T> Binding<T> tenaryBinding(ObservableBooleanValue condition, T then, T _else) {
        return new TenaryBinding<T>(condition, then, _else);
    }

    @SafeVarargs
    public static <A> ListBinding<A> concat(ObservableList<? extends A> ... sources) {
        return new FixListBinding<A>(new ConcatListBinding<A>(sources));
    }

    @SafeVarargs
    public static <T> StringBinding concat(String delimiter, ObservableValue<T> ... sources) {
        return new ConcatStringBinding<T>(delimiter, sources);
    }

    public static <A, B> ObjectBinding<B> flatMap(ObservableValue<A> source, Function<A, ObservableValue<B>> map) {
        return new MapObjectBinding<A, B>(source, map);
    }

    public static <A, B> ObjectBinding<B> map(ObservableValue<A> source, Function<A, B> map) {
        return new MapSimpleObjectBinding<A, B>(source, map);
    }

    public static <A, B> ListBinding<B> mapList(ObservableList<A> source, Function<A, B> map) {
        return new FixListBinding(new MapListBinding<A, B>(source, map));
    }

    public static <A, B> ListBinding<B> flatMapList(ObservableList<A> source, Function<A, ObservableList<B>> map) {
        return new FixListBinding(new FlatMapListBinding<A, B>(source, map));
    }

    public static <A, B> ListBinding<B> flatMapListValue(ObservableList<A> source, Function<A, ObservableValue<B>> map) {
        return new FixListBinding(new FlatMapValueListBinding<A, B>(source, map));
    }

    public static <A> ListBinding<A> syncList(ObservableList<A> source, ThreadSynchronize thread) {
        return new SyncListBinding<A>(source, thread);
    }

    public static <A> ObjectBinding<A> sync(ObservableValue<A> source, ThreadSynchronize thread) {
        return new SyncObjectBinding<A>(source, thread);
    }

    public static <T, E> Subscription bindContent(List<T> target, ObservableList<E> sourceList, Function<E, T> converterFunction) {
        return FXBindings.bindContent(null, target, sourceList, converterFunction);
    }

    public static <T, E> Subscription bindContent(final ThreadSynchronize threadSync, List<T> target, final ObservableList<E> sourceList, Function<E, T> converterFunction) {
        ListChangeListener fl;
        List list = sourceList.stream().map(converterFunction).collect(Collectors.toList());
        if (threadSync == null) {
            if (target instanceof ObservableList) {
                ((ObservableList)target).setAll(list);
            } else {
                target.clear();
                target.addAll(list);
            }
        } else {
            threadSync.asyncExec(() -> {
                if (target instanceof ObservableList) {
                    ((ObservableList)target).setAll((Collection)list);
                } else {
                    target.clear();
                    target.addAll(list);
                }
            });
        }
        ListChangeListener l = change -> {
            while (change.next()) {
                if (change.wasPermutated()) {
                    target.subList(change.getFrom(), change.getTo()).clear();
                    target.addAll(change.getFrom(), FXBindings.transformList(change.getList().subList(change.getFrom(), change.getTo()), converterFunction));
                    continue;
                }
                if (change.wasRemoved()) {
                    target.subList(change.getFrom(), change.getFrom() + change.getRemovedSize()).clear();
                }
                if (!change.wasAdded()) continue;
                target.addAll(change.getFrom(), FXBindings.transformList(change.getAddedSubList(), converterFunction));
            }
        };
        if (threadSync == null) {
            fl = l;
            sourceList.addListener(l);
        } else {
            fl = change -> threadSync.asyncExec(() -> l.onChanged(change));
            sourceList.addListener(fl);
        }
        return new Subscription(){

            @Override
            public void dispose() {
                if (threadSync == null) {
                    sourceList.removeListener(fl);
                } else {
                    threadSync.asyncExec(fl, arg_0 -> ((ObservableList)sourceList).removeListener(arg_0));
                }
            }
        };
    }

    public static <T, E> Subscription bindContent(int padding, List<T> target, ObservableList<E> sourceList, Function<E, T> converterFunction, IntFunction<T> paddingEntryFactory) {
        return FXBindings.bindContent(null, padding, target, sourceList, converterFunction, paddingEntryFactory);
    }

    public static <T, E> Subscription bindContent(ThreadSynchronize threadSync, int padding, List<T> target, ObservableList<E> sourceList, Function<E, T> converterFunction, IntFunction<T> paddingEntryFactory) {
        return new PaddedListBinding<T, E>(threadSync, padding, target, sourceList, converterFunction, paddingEntryFactory);
    }

    static <T, E> List<T> transformList(List<? extends E> list, Function<E, T> converterFunction) {
        return list.stream().map(converterFunction).collect(Collectors.toList());
    }

    public static <S, T> StatusBinding bindBidirectional(Property<T> target, Property<S> source, Class<T> targetType, Class<S> sourceType) {
        Function<T, S> targetToSource = ConverterRegistry.getConverter(targetType, sourceType);
        Function<S, T> sourceToTarget = ConverterRegistry.getConverter(sourceType, targetType);
        if (sourceToTarget == null) {
            throw new RuntimeException("Cannot find converter from " + sourceType + " to " + targetType);
        }
        if (targetToSource == null) {
            throw new RuntimeException("Cannot find converter from " + targetType + " to " + sourceType);
        }
        return FXBindings.bindBidirectional(target, source, targetToSource, sourceToTarget);
    }

    public static <S, T> StatusBinding bindBidirectional(Property<T> target, Property<S> source, Function<T, S> targetToSource, Function<S, T> sourceToTarget) {
        return new BaseBidiPropertyBinding((Observable)target, (Observable)source, (Property)target, sourceToTarget, (Property)source, targetToSource){
            private final /* synthetic */ Property val$target;
            private final /* synthetic */ Function val$sourceToTarget;
            private final /* synthetic */ Property val$source;
            private final /* synthetic */ Function val$targetToSource;
            {
                this.val$target = property;
                this.val$sourceToTarget = function;
                this.val$source = property2;
                this.val$targetToSource = function2;
                super($anonymous0, $anonymous1);
            }

            @Override
            protected void syncTarget() {
                this.val$target.setValue(this.val$sourceToTarget.apply(this.val$source.getValue()));
            }

            @Override
            protected void syncSource() {
                this.val$source.setValue(this.val$targetToSource.apply(this.val$target.getValue()));
            }
        };
    }

    private static class ConcatListHelper<T> {
        private final ObservableList<T> concatedList = FXCollections.observableArrayList();
        final ObservableList<T> roConcatedList = FXCollections.unmodifiableObservableList(this.concatedList);

        @SafeVarargs
        ConcatListHelper(ObservableList<? extends T> ... list) {
            int[] index = new int[list.length];
            int i = 0;
            while (i < list.length) {
                int j = i;
                index[i] = this.concatedList.size();
                this.concatedList.addAll(list[i]);
                list[i].addListener(c -> {
                    while (c.next()) {
                        int k;
                        if (c.wasRemoved()) {
                            this.concatedList.remove(index[j] + c.getFrom(), index[j] + c.getFrom() + c.getRemovedSize());
                            k = j + 1;
                            while (k < index.length) {
                                int n2 = k++;
                                nArray[n2] = index[n2] - c.getRemoved().size();
                            }
                        }
                        if (!c.wasAdded()) continue;
                        this.concatedList.addAll(index[j] + c.getFrom(), (Collection)c.getAddedSubList());
                        k = j + 1;
                        while (k < index.length) {
                            int n3 = k++;
                            nArray[n3] = index[n3] + c.getAddedSubList().size();
                        }
                    }
                });
                ++i;
            }
        }
    }

    public static class ConverterRegistry {
        private static Map<Tuple<Class<?>, Class<?>>, Function<?, ?>> map = new HashMap();

        static {
            ConverterRegistry.registerConverter(Integer.class, String.class, i -> i.toString());
            ConverterRegistry.registerConverter(String.class, Integer.class, s -> Integer.parseInt(s));
        }

        public static <S, T> void registerConverter(Class<S> sourceType, Class<T> targetType, Function<S, T> converter) {
            map.put(new Tuple<Class<S>, Class<T>>(sourceType, targetType), converter);
        }

        public static <S, T> Function<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
            return map.get(new Tuple<Class<S>, Class<T>>(sourceType, targetType));
        }
    }

    public static class Instance
    extends DisposeableCollector<Subscription> {
        public Instance() {
            super(Subscription::dispose);
        }

        private Subscription wrap(Subscription subscription) {
            this.register(subscription);
            return () -> {
                this.unregister(subscription);
                subscription.dispose();
            };
        }

        private <B extends Binding<T>, T> B wrap(B binding) {
            if (binding != null) {
                this.register(() -> binding.dispose());
            }
            return binding;
        }

        public <T, E> Subscription onBindContent(int padding, List<T> target, ObservableList<E> sourceList, Function<E, T> converterFunction, IntFunction<T> paddingEntryFactory) {
            Subscription subscription = FXBindings.bindContent(padding, target, sourceList, converterFunction, paddingEntryFactory);
            return this.wrap(subscription);
        }

        public <T, E> Subscription onBindContent(List<T> target, ObservableList<E> sourceList, Function<E, T> converterFunction) {
            Subscription subscription = FXBindings.bindContent(target, sourceList, converterFunction);
            return this.wrap(subscription);
        }

        public <T, E> Subscription onBindContent(ThreadSynchronize threadSync, int padding, List<T> target, ObservableList<E> sourceList, Function<E, T> converterFunction, IntFunction<T> paddingEntryFactory) {
            Subscription subscription = FXBindings.bindContent(threadSync, padding, target, sourceList, converterFunction, paddingEntryFactory);
            return this.wrap(subscription);
        }

        public <T, E> Subscription onBindContent(ThreadSynchronize threadSync, List<T> target, ObservableList<E> sourceList, Function<E, T> converterFunction) {
            Subscription subscription = FXBindings.bindContent(threadSync, target, sourceList, converterFunction);
            return this.wrap(subscription);
        }

        public <A> ListBinding<A> onConcat(ObservableList<? extends A> ... sources) {
            ListBinding<? extends A> binding = FXBindings.concat(sources);
            return this.wrap((Binding)binding);
        }

        public <T> StringBinding onConcat(String delimiter, ObservableValue<T> ... sources) {
            StringBinding binding = FXBindings.concat(delimiter, sources);
            return this.wrap(binding);
        }

        public <A, B> ObjectBinding<B> onFlatMap(ObservableValue<A> source, Function<A, ObservableValue<B>> map) {
            ObjectBinding<B> binding = FXBindings.flatMap(source, map);
            return this.wrap((B)binding);
        }

        public <A, B> ListBinding<B> onFlatMapList(ObservableList<A> source, Function<A, ObservableList<B>> map) {
            ListBinding<B> binding = FXBindings.flatMapList(source, map);
            return this.wrap((B)binding);
        }

        public <A, B> ListBinding<B> onFlatMapListValue(ObservableList<A> source, Function<A, ObservableValue<B>> map) {
            ListBinding<B> binding = FXBindings.flatMapListValue(source, map);
            return this.wrap((B)binding);
        }

        public <A> ListBinding<A> onSyncList(ObservableList<A> source, ThreadSynchronize thread) {
            ListBinding<A> binding = FXBindings.syncList(source, thread);
            return this.wrap((Binding)binding);
        }

        public <A> ObjectBinding<A> onSync(ObservableValue<A> source, ThreadSynchronize thread) {
            ObjectBinding<A> binding = FXBindings.sync(source, thread);
            return this.wrap((Binding)binding);
        }

        public <T> Binding<T> onTenaryBinding(ObservableBooleanValue condition, ObservableValue<T> then, ObservableValue<T> _else) {
            Binding<ObservableValue<T>> binding = FXBindings.tenaryBinding(condition, then, _else);
            return this.wrap(binding);
        }

        public <T> Binding<T> onTenaryBinding(ObservableBooleanValue condition, T then, T _else) {
            Binding<T> binding = FXBindings.tenaryBinding(condition, then, _else);
            return this.wrap(binding);
        }

        public <A, B> ObjectBinding<B> onMap(ObservableValue<A> source, Function<A, B> map) {
            ObjectBinding<B> binding = FXBindings.map(source, map);
            return this.wrap((B)binding);
        }

        public <A, B> ListBinding<B> onMapList(ObservableList<A> source, Function<A, B> map) {
            ListBinding<B> binding = FXBindings.mapList(source, map);
            return this.wrap((B)binding);
        }

        public <R extends Binding<?>, T> R onCollect(BindingStream<T> stream, FXCollector<T, R> collector) {
            Binding binding = (Binding)stream.collect(collector);
            if (binding != null) {
                this.register(() -> binding.dispose());
            }
            return (R)binding;
        }
    }

    static class PaddedListBinding<T, E>
    implements Subscription {
        final ObservableList<E> sourceList;
        final IntegerProperty padding;
        final ListChangeListener<E> l;
        final IntFunction<T> paddingEntryFactory;
        final List<T> target;
        final ThreadSynchronize threadSync;

        PaddedListBinding(ThreadSynchronize threadSync, int padding, List<T> target, ObservableList<E> sourceList, Function<E, T> converterFunction, IntFunction<T> paddingEntryFactory) {
            ListChangeListener ll;
            this.threadSync = threadSync;
            this.padding = new SimpleIntegerProperty((Object)this, "padding", padding);
            this.target = target;
            this.sourceList = sourceList;
            ListChangeListener l = change -> {
                while (change.next()) {
                    if (change.wasPermutated()) {
                        target.subList(change.getFrom() + this.getPadding(), change.getTo() + this.getPadding()).clear();
                        target.addAll(change.getFrom() + this.getPadding(), FXBindings.transformList(change.getList().subList(change.getFrom(), change.getTo()), converterFunction));
                        continue;
                    }
                    if (change.wasRemoved()) {
                        target.subList(change.getFrom() + this.getPadding(), change.getFrom() + this.getPadding() + change.getRemovedSize()).clear();
                    }
                    if (!change.wasAdded()) continue;
                    target.addAll(change.getFrom() + this.getPadding(), FXBindings.transformList(change.getAddedSubList(), converterFunction));
                }
            };
            this.l = threadSync == null ? l : (ll = change -> threadSync.asyncExec(() -> l.onChanged(change)));
            this.sourceList.addListener(this.l);
            this.paddingEntryFactory = paddingEntryFactory;
            this.padding.addListener((o, ol, ne) -> {
                int iNe;
                int iOl = ol == null ? 0 : ol.intValue();
                int n = iNe = ne == null ? 0 : ne.intValue();
                if (iOl > iNe) {
                    target.subList(iNe, iOl).clear();
                } else if (iOl < iNe) {
                    List paddedObjects = IntStream.range(iOl, iNe).mapToObj(paddingEntryFactory).collect(Collectors.toList());
                    target.addAll(iOl, paddedObjects);
                }
            });
            List list = sourceList.stream().map(converterFunction).collect(Collectors.toList());
            if (threadSync == null) {
                if (padding == 0) {
                    if (target instanceof ObservableList) {
                        ((ObservableList)target).setAll(list);
                    } else {
                        target.clear();
                        target.addAll(list);
                    }
                } else if (!target.isEmpty()) {
                    target.subList(padding, target.size()).clear();
                    target.addAll(padding, list);
                } else {
                    List t = IntStream.range(0, padding).mapToObj(paddingEntryFactory).collect(Collectors.toList());
                    t.addAll(list);
                    target.addAll(t);
                }
            } else {
                threadSync.asyncExec(() -> {
                    if (padding == 0) {
                        if (target instanceof ObservableList) {
                            ((ObservableList)target).setAll((Collection)list);
                        } else {
                            target.clear();
                            target.addAll(list);
                        }
                    } else if (!target.isEmpty()) {
                        target.subList(padding, target.size()).clear();
                        target.addAll(padding, list);
                    } else {
                        List t = IntStream.range(0, padding).mapToObj(paddingEntryFactory).collect(Collectors.toList());
                        t.addAll(list);
                        target.addAll(t);
                    }
                });
            }
        }

        public final IntegerProperty paddingProperty() {
            return this.padding;
        }

        public final int getPadding() {
            return this.paddingProperty().get();
        }

        public final void setPadding(int padding) {
            this.paddingProperty().set(padding);
        }

        @Override
        public void dispose() {
            if (this.threadSync == null) {
                this.sourceList.remove(this.l);
            } else {
                this.threadSync.asyncExec(this.l, arg_0 -> this.sourceList.remove(arg_0));
            }
        }
    }

    public static class PrimitivesBindings {
        public static StatusBinding bindBidirectional(final StringProperty target, final StringProperty source, final Function<String, String> targetToSource, final Function<String, String> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set((Object)((String)sourceToTarget.apply((String)source.get())));
                }

                @Override
                protected void syncSource() {
                    source.set((Object)((String)targetToSource.apply((String)target.get())));
                }
            };
        }

        public static <T> StatusBinding bindBidirectional(Property<T> target, StringProperty source, Function<T, String> targetToSource, Function<String, T> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source, (Property)target, sourceToTarget, source, targetToSource){
                private final /* synthetic */ Property val$target;
                private final /* synthetic */ Function val$sourceToTarget;
                private final /* synthetic */ StringProperty val$source;
                private final /* synthetic */ Function val$targetToSource;
                {
                    this.val$target = property;
                    this.val$sourceToTarget = function;
                    this.val$source = stringProperty;
                    this.val$targetToSource = function2;
                    super($anonymous0, $anonymous1);
                }

                @Override
                protected void syncTarget() {
                    this.val$target.setValue(this.val$sourceToTarget.apply((String)this.val$source.get()));
                }

                @Override
                protected void syncSource() {
                    this.val$source.set((Object)((String)this.val$targetToSource.apply(this.val$target.getValue())));
                }
            };
        }

        public static StatusBinding bindBidirectional(final IntegerProperty target, final StringProperty source, final IntFunction<String> targetToSource, final ToIntFunction<String> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsInt((String)source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set((Object)((String)targetToSource.apply(target.get())));
                }
            };
        }

        public static StatusBinding bindBidirectional(final DoubleProperty target, final StringProperty source, final DoubleFunction<String> targetToSource, final ToDoubleFunction<String> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsDouble((String)source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set((Object)((String)targetToSource.apply(target.get())));
                }
            };
        }

        public static StatusBinding bindBidirectional(final FloatProperty target, final StringProperty source, final DoubleFunction<String> targetToSource, final ToDoubleFunction<String> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set((float)sourceToTarget.applyAsDouble((String)source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set((Object)((String)targetToSource.apply(target.get())));
                }
            };
        }

        public static StatusBinding bindBidirectional(final LongProperty target, final StringProperty source, final LongFunction<String> targetToSource, final ToLongFunction<String> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsLong((String)source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set((Object)((String)targetToSource.apply(target.get())));
                }
            };
        }

        public static StatusBinding bindBidirectional(final BooleanProperty target, final StringProperty source, final Function<Boolean, String> targetToSource, final Predicate<String> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.test((String)source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set((Object)((String)targetToSource.apply(target.get())));
                }
            };
        }

        public static <T> StatusBinding bindBidirectional(final StringProperty target, Property<T> source, Function<String, T> targetToSource, final Function<T, String> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source, (Property)source, targetToSource){
                private final /* synthetic */ Property val$source;
                private final /* synthetic */ Function val$targetToSource;
                {
                    this.val$source = property;
                    this.val$targetToSource = function2;
                    super($anonymous0, $anonymous1);
                }

                @Override
                protected void syncTarget() {
                    target.setValue((String)sourceToTarget.apply(this.val$source.getValue()));
                }

                @Override
                protected void syncSource() {
                    this.val$source.setValue(this.val$targetToSource.apply((String)target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final StringProperty target, final IntegerProperty source, final ToIntFunction<String> targetToSource, final IntFunction<String> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.setValue((String)sourceToTarget.apply(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsInt((String)target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final StringProperty target, final DoubleProperty source, final ToDoubleFunction<String> targetToSource, final DoubleFunction<String> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.setValue((String)sourceToTarget.apply(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsDouble((String)target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final StringProperty target, final FloatProperty source, final ToDoubleFunction<String> targetToSource, final DoubleFunction<String> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.setValue((String)sourceToTarget.apply(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set((float)targetToSource.applyAsDouble((String)target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final StringProperty target, final LongProperty source, final ToLongFunction<String> targetToSource, final LongFunction<String> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.setValue((String)sourceToTarget.apply(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsLong((String)target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final StringProperty target, final BooleanProperty source, final Predicate<String> targetToSource, final Function<Boolean, String> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.setValue((String)sourceToTarget.apply(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.test((String)target.get()));
                }
            };
        }

        public static <T> StatusBinding bindBidirectional(Property<T> target, BooleanProperty source, Predicate<T> targetToSource, Function<Boolean, T> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source, (Property)target, sourceToTarget, source, targetToSource){
                private final /* synthetic */ Property val$target;
                private final /* synthetic */ Function val$sourceToTarget;
                private final /* synthetic */ BooleanProperty val$source;
                private final /* synthetic */ Predicate val$targetToSource;
                {
                    this.val$target = property;
                    this.val$sourceToTarget = function;
                    this.val$source = booleanProperty;
                    this.val$targetToSource = predicate;
                    super($anonymous0, $anonymous1);
                }

                @Override
                protected void syncTarget() {
                    this.val$target.setValue(this.val$sourceToTarget.apply(this.val$source.get()));
                }

                @Override
                protected void syncSource() {
                    this.val$source.set(this.val$targetToSource.test(this.val$target.getValue()));
                }
            };
        }

        public static <T> StatusBinding bindBidirectional(final BooleanProperty target, Property<T> source, Function<Boolean, T> targetToSource, final Predicate<T> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source, (Property)source, targetToSource){
                private final /* synthetic */ Property val$source;
                private final /* synthetic */ Function val$targetToSource;
                {
                    this.val$source = property;
                    this.val$targetToSource = function;
                    super($anonymous0, $anonymous1);
                }

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.test(this.val$source.getValue()));
                }

                @Override
                protected void syncSource() {
                    this.val$source.setValue(this.val$targetToSource.apply(target.getValue()));
                }
            };
        }

        public static <T> StatusBinding bindBidirectional(Property<T> target, IntegerProperty source, ToIntFunction<T> targetToSource, IntFunction<T> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source, (Property)target, sourceToTarget, source, targetToSource){
                private final /* synthetic */ Property val$target;
                private final /* synthetic */ IntFunction val$sourceToTarget;
                private final /* synthetic */ IntegerProperty val$source;
                private final /* synthetic */ ToIntFunction val$targetToSource;
                {
                    this.val$target = property;
                    this.val$sourceToTarget = intFunction;
                    this.val$source = integerProperty;
                    this.val$targetToSource = toIntFunction;
                    super($anonymous0, $anonymous1);
                }

                @Override
                protected void syncTarget() {
                    this.val$target.setValue(this.val$sourceToTarget.apply(this.val$source.get()));
                }

                @Override
                protected void syncSource() {
                    this.val$source.set(this.val$targetToSource.applyAsInt(this.val$target.getValue()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final DoubleProperty target, final IntegerProperty source, final DoubleToIntFunction targetToSource, final IntToDoubleFunction sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsDouble(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsInt(target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final FloatProperty target, final IntegerProperty source, final DoubleToIntFunction targetToSource, final IntToDoubleFunction sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set((float)sourceToTarget.applyAsDouble(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsInt(target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final LongProperty target, final IntegerProperty source, final LongToIntFunction targetToSource, final IntToLongFunction sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsLong(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsInt(target.get()));
                }
            };
        }

        public static <T> StatusBinding bindBidirectional(final IntegerProperty target, Property<T> source, IntFunction<T> targetToSource, final ToIntFunction<T> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source, (Property)source, targetToSource){
                private final /* synthetic */ Property val$source;
                private final /* synthetic */ IntFunction val$targetToSource;
                {
                    this.val$source = property;
                    this.val$targetToSource = intFunction;
                    super($anonymous0, $anonymous1);
                }

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsInt(this.val$source.getValue()));
                }

                @Override
                protected void syncSource() {
                    this.val$source.setValue(this.val$targetToSource.apply(target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final IntegerProperty target, final DoubleProperty source, final IntToDoubleFunction targetToSource, final DoubleToIntFunction sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsInt(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsDouble(target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final IntegerProperty target, final FloatProperty source, final IntToDoubleFunction targetToSource, final DoubleToIntFunction sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsInt(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set((float)targetToSource.applyAsDouble(target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final IntegerProperty target, final LongProperty source, final IntToLongFunction targetToSource, final LongToIntFunction sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsInt(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsLong(target.get()));
                }
            };
        }

        public static <S> StatusBinding bindBidirectional(final IntegerProperty target, final IntegerProperty source, final IntUnaryOperator targetToSource, final IntUnaryOperator sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsInt(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsInt(target.get()));
                }
            };
        }

        public static <T> StatusBinding bindBidirectional(Property<T> target, DoubleProperty source, ToDoubleFunction<T> targetToSource, DoubleFunction<T> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source, (Property)target, sourceToTarget, source, targetToSource){
                private final /* synthetic */ Property val$target;
                private final /* synthetic */ DoubleFunction val$sourceToTarget;
                private final /* synthetic */ DoubleProperty val$source;
                private final /* synthetic */ ToDoubleFunction val$targetToSource;
                {
                    this.val$target = property;
                    this.val$sourceToTarget = doubleFunction;
                    this.val$source = doubleProperty;
                    this.val$targetToSource = toDoubleFunction;
                    super($anonymous0, $anonymous1);
                }

                @Override
                protected void syncTarget() {
                    this.val$target.setValue(this.val$sourceToTarget.apply(this.val$source.get()));
                }

                @Override
                protected void syncSource() {
                    this.val$source.set(this.val$targetToSource.applyAsDouble(this.val$target.getValue()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final FloatProperty target, final DoubleProperty source, final DoubleUnaryOperator targetToSource, final DoubleUnaryOperator sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set((float)sourceToTarget.applyAsDouble(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsDouble(target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final LongProperty target, final DoubleProperty source, final LongToDoubleFunction targetToSource, final DoubleToLongFunction sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsLong(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsDouble(target.get()));
                }
            };
        }

        public static <T> StatusBinding bindBidirectional(final DoubleProperty target, Property<T> source, DoubleFunction<T> targetToSource, final ToDoubleFunction<T> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source, (Property)source, targetToSource){
                private final /* synthetic */ Property val$source;
                private final /* synthetic */ DoubleFunction val$targetToSource;
                {
                    this.val$source = property;
                    this.val$targetToSource = doubleFunction;
                    super($anonymous0, $anonymous1);
                }

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsDouble(this.val$source.getValue()));
                }

                @Override
                protected void syncSource() {
                    this.val$source.setValue(this.val$targetToSource.apply(target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final DoubleProperty target, final FloatProperty source, final DoubleUnaryOperator targetToSource, final DoubleUnaryOperator sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsDouble(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set((float)targetToSource.applyAsDouble(target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final DoubleProperty target, final LongProperty source, final DoubleToLongFunction targetToSource, final LongToDoubleFunction sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsDouble(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsLong(target.get()));
                }
            };
        }

        public static <S> StatusBinding bindBidirectional(final DoubleProperty target, final DoubleProperty source, final DoubleUnaryOperator targetToSource, final DoubleUnaryOperator sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsDouble(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsDouble(target.get()));
                }
            };
        }

        public static <T> StatusBinding bindBidirectional(Property<T> target, FloatProperty source, ToDoubleFunction<T> targetToSource, DoubleFunction<T> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source, (Property)target, sourceToTarget, source, targetToSource){
                private final /* synthetic */ Property val$target;
                private final /* synthetic */ DoubleFunction val$sourceToTarget;
                private final /* synthetic */ FloatProperty val$source;
                private final /* synthetic */ ToDoubleFunction val$targetToSource;
                {
                    this.val$target = property;
                    this.val$sourceToTarget = doubleFunction;
                    this.val$source = floatProperty;
                    this.val$targetToSource = toDoubleFunction;
                    super($anonymous0, $anonymous1);
                }

                @Override
                protected void syncTarget() {
                    this.val$target.setValue(this.val$sourceToTarget.apply(this.val$source.get()));
                }

                @Override
                protected void syncSource() {
                    this.val$source.set((float)this.val$targetToSource.applyAsDouble(this.val$target.getValue()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final LongProperty target, final FloatProperty source, final LongToDoubleFunction targetToSource, final DoubleToLongFunction sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsLong(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set((float)targetToSource.applyAsDouble(target.get()));
                }
            };
        }

        public static <T> StatusBinding bindBidirectional(final FloatProperty target, Property<T> source, DoubleFunction<T> targetToSource, final ToDoubleFunction<T> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source, (Property)source, targetToSource){
                private final /* synthetic */ Property val$source;
                private final /* synthetic */ DoubleFunction val$targetToSource;
                {
                    this.val$source = property;
                    this.val$targetToSource = doubleFunction;
                    super($anonymous0, $anonymous1);
                }

                @Override
                protected void syncTarget() {
                    target.set((float)sourceToTarget.applyAsDouble(this.val$source.getValue()));
                }

                @Override
                protected void syncSource() {
                    this.val$source.setValue(this.val$targetToSource.apply(target.get()));
                }
            };
        }

        public static StatusBinding bindBidirectional(final FloatProperty target, final LongProperty source, final DoubleToLongFunction targetToSource, final LongToDoubleFunction sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set((float)sourceToTarget.applyAsDouble(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsLong(target.get()));
                }
            };
        }

        public static <S> StatusBinding bindBidirectional(final FloatProperty target, final FloatProperty source, final DoubleUnaryOperator targetToSource, final DoubleUnaryOperator sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set((float)sourceToTarget.applyAsDouble(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set((float)targetToSource.applyAsDouble(target.get()));
                }
            };
        }

        public static <T> StatusBinding bindBidirectional(Property<T> target, LongProperty source, ToLongFunction<T> targetToSource, LongFunction<T> sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source, (Property)target, sourceToTarget, source, targetToSource){
                private final /* synthetic */ Property val$target;
                private final /* synthetic */ LongFunction val$sourceToTarget;
                private final /* synthetic */ LongProperty val$source;
                private final /* synthetic */ ToLongFunction val$targetToSource;
                {
                    this.val$target = property;
                    this.val$sourceToTarget = longFunction;
                    this.val$source = longProperty;
                    this.val$targetToSource = toLongFunction;
                    super($anonymous0, $anonymous1);
                }

                @Override
                protected void syncTarget() {
                    this.val$target.setValue(this.val$sourceToTarget.apply(this.val$source.get()));
                }

                @Override
                protected void syncSource() {
                    this.val$source.set(this.val$targetToSource.applyAsLong(this.val$target.getValue()));
                }
            };
        }

        public static <S> StatusBinding bindBidirectional(final LongProperty target, final LongProperty source, final LongUnaryOperator targetToSource, final LongUnaryOperator sourceToTarget) {
            return new BaseBidiPropertyBinding((Observable)target, (Observable)source){

                @Override
                protected void syncTarget() {
                    target.set(sourceToTarget.applyAsLong(source.get()));
                }

                @Override
                protected void syncSource() {
                    source.set(targetToSource.applyAsLong(target.get()));
                }
            };
        }
    }

    public static interface StatusBinding
    extends Binding<Status> {
    }
}

