/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.ui.workbench.base.rendering.ElementRenderer;
import org.eclipse.fx.ui.workbench.base.rendering.RendererFactory;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.Util;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WStack;
import org.eclipse.fx.ui.workbench.services.ELifecycleService;
import org.eclipse.fx.ui.workbench.services.lifecycle.annotation.PreClose;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class BaseStackRenderer<N, I, IC>
extends BaseRenderer<MPartStack, WStack<N, I, IC>> {
    private static final String MAP_ITEM_KEY = "fx.rendering.stackitem";
    public static final String MAP_MOVE = "fx.rendering.stackitem.move";
    public static final String TAG_TAB_CONTEXT_MENU = "tabmenu";
    @Inject
    RendererFactory factory;
    @Inject
    MApplication application;
    @Inject
    ELifecycleService lifecycleService;
    boolean inLazyInit;

    private @NonNull RendererFactory getFactory() {
        RendererFactory factory = this.factory;
        if (factory == null) {
            throw new IllegalStateException("Renderfactory must not be null");
        }
        return factory;
    }

    @PostConstruct
    void init(IEventBroker eventBroker) {
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", new EventHandler(){

            public void handleEvent(Event event) {
                MPartStack parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MPartStack && BaseStackRenderer.this == (parent = (MPartStack)changedObj).getRenderer()) {
                    if (UIEvents.isADD((Event)event)) {
                        BaseStackRenderer.this.handleChildrenAddition(parent, Util.asCollection(event, "NewValue"));
                    } else if (UIEvents.isREMOVE((Event)event)) {
                        BaseStackRenderer.this.handleChildrenRemove(parent, Util.asCollection(event, "OldValue"));
                    }
                }
            }
        });
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", new EventHandler(){

            public void handleEvent(Event event) {
                String eventType;
                MPartStack parent;
                Object changedObj = event.getProperty("ChangedElement");
                if (changedObj instanceof MPartStack && BaseStackRenderer.this == (parent = (MPartStack)changedObj).getRenderer() && "SET".equals(eventType = (String)event.getProperty("EventType"))) {
                    MUIElement newValue = (MUIElement)event.getProperty("NewValue");
                    MUIElement oldValue = (MUIElement)event.getProperty("OldValue");
                    BaseStackRenderer.this.handleSelectedElement(parent, (MStackElement)oldValue, (MStackElement)newValue);
                }
            }
        });
        EventProcessor.attachVisibleProcessor(eventBroker, this);
    }

    @Nullable MPart getPart(@NonNull MUIElement tmp) {
        MUIElement element = tmp;
        if (element instanceof MPart) {
            return (MPart)element;
        }
        if (element instanceof MPlaceholder) {
            return (MPart)((MPlaceholder)element).getRef();
        }
        if (element instanceof MElementContainer) {
            MElementContainer container = (MElementContainer)element;
            if ((element = container.getSelectedElement()) == null && !container.getChildren().isEmpty()) {
                element = (MUIElement)container.getChildren().get(0);
            }
            if (element != null) {
                return this.getPart(element);
            }
            return null;
        }
        return (MPart)element;
    }

    @Override
    protected void initWidget(final MPartStack element, WStack<N, I, IC> widget) {
        super.initWidget(element, widget);
        widget.setMouseSelectedItemCallback(new WCallback<WStack.WStackItem<I, IC>, Void>(){

            @Override
            public Void call(WStack.WStackItem<I, IC> param) {
                MStackElement domElement = param.getDomElement();
                if (domElement != null) {
                    MPart part = BaseStackRenderer.this.getPart((MUIElement)domElement);
                    if (part != null) {
                        BaseStackRenderer.this.activatationJob(element, part, true);
                    } else {
                        BaseStackRenderer.this.getLogger().error("Unable to find part to activate for '" + domElement + "'");
                    }
                }
                return null;
            }
        });
        widget.setKeySelectedItemCallback(new WCallback<WStack.WStackItem<I, IC>, Void>(){

            @Override
            public Void call(WStack.WStackItem<I, IC> param) {
                MStackElement domElement = param.getDomElement();
                if (domElement != null) {
                    MPart part = BaseStackRenderer.this.getPart((MUIElement)domElement);
                    if (part != null) {
                        BaseStackRenderer.this.activatationJob(element, part, false);
                    } else {
                        BaseStackRenderer.this.getLogger().error("Unable to find part to activate for '" + domElement + "'");
                    }
                }
                return null;
            }
        });
        widget.registerActivationCallback(new WCallback<Boolean, Void>(){

            @Override
            public Void call(Boolean param) {
                MStackElement selectedElement = (MStackElement)element.getSelectedElement();
                if (param.booleanValue() && selectedElement != null) {
                    MPart part = BaseStackRenderer.this.getPart((MUIElement)selectedElement);
                    if (part != null) {
                        BaseStackRenderer.this.activatationJob(element, part, true);
                    } else {
                        BaseStackRenderer.this.getLogger().error("Unable to find part to activate for '" + selectedElement + "'");
                    }
                }
                return null;
            }
        });
    }

    void activatationJob(@NonNull MPartStack stackToActivate, @NonNull MPart p, boolean focus) {
        if (this.shouldActivate(stackToActivate)) {
            this.activate(p, focus);
        }
    }

    private boolean shouldActivate(@NonNull MPartStack stackToActivate) {
        IEclipseContext applicationContext;
        IEclipseContext activeChild;
        if (this.inContentProcessing((MUIElement)stackToActivate)) {
            return false;
        }
        return this.application == null || (activeChild = (applicationContext = this.application.getContext()).getActiveChild()) != null && activeChild.get(MWindow.class) == this.application.getSelectedElement() && this.application.getSelectedElement() == this.modelService.getTopLevelWindowFor((MUIElement)stackToActivate);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void doProcessContent(MPartStack element) {
        WStack stack = (WStack)this.getWidget((MUIElement)element);
        if (stack == null) {
            this.getLogger().error("Could not find widget for '" + element + "'");
            return;
        }
        ArrayList<@NonNull WStack.WStackItem<I, IC>> items = new ArrayList();
        WStack.WStackItem<I, IC> initalItem = null;
        for (MStackElement e : element.getChildren()) {
            @NonNull ElementRenderer renderer = this.getFactory().getRenderer((MUIElement)e);
            if (renderer == null || !this.isChildRenderedAndVisible((MUIElement)e)) continue;
            WStack.WStackItem<I, IC> item = this.createStackItem(stack, e, renderer);
            items.add(item);
            if (e != element.getSelectedElement()) continue;
            initalItem = item;
        }
        if (!items.isEmpty()) {
            if (initalItem == null || items.size() == 1 || items.get(0) == initalItem) {
                stack.addItems(items);
            } else {
                stack.addItem(initalItem);
                if (items.get(items.size() - 1) == initalItem) {
                    stack.addItems(0, items.subList(0, items.size() - 1));
                } else {
                    int idx = items.indexOf(initalItem);
                    stack.addItems(0, items.subList(0, idx));
                    stack.addItems(items.subList(idx + 1, items.size()));
                }
            }
        }
        stack.selectItem(stack.getItems().indexOf(initalItem));
        if (element.getSelectedElement() == null && !stack.getItems().isEmpty()) {
            element.setSelectedElement((MUIElement)stack.getItems().get(0).getDomElement());
        }
    }

    private @NonNull WStack.WStackItem<I, IC> createStackItem(@NonNull WStack<N, I, IC> stack, final @NonNull MStackElement e, @NonNull ElementRenderer<MStackElement, ?> renderer) {
        IEclipseContext context = renderer.setupRenderingContext((MUIElement)e);
        WStack.WStackItem item = (WStack.WStackItem)ContextInjectionFactory.make(stack.getStackItemClass(), (IEclipseContext)context);
        e.getTransientData().put(MAP_ITEM_KEY, item);
        if (item == null) {
            throw new IllegalStateException("The item must not be null");
        }
        item.setDomElement(e);
        item.setInitCallback(new WCallback<WStack.WStackItem<I, IC>, IC>(){

            @Override
            public IC call(WStack.WStackItem<I, IC> param) {
                BaseStackRenderer.this.inLazyInit = true;
                try {
                    WLayoutedWidget widget = (WLayoutedWidget)BaseStackRenderer.this.engineCreateWidget(e);
                    if (widget != null) {
                        Object object = widget.getStaticLayoutNode();
                        return object;
                    }
                    return null;
                }
                finally {
                    BaseStackRenderer.this.inLazyInit = false;
                }
            }
        });
        item.setOnCloseCallback(new WCallback<WStack.WStackItem<I, IC>, Boolean>(){

            @Override
            public Boolean call(WStack.WStackItem<I, IC> param) {
                return !BaseStackRenderer.this.handleStackItemClose(e, param);
            }
        });
        return item;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    void handleChildrenAddition(MPartStack parent, Collection<MStackElement> elements) {
        WStack widget = (WStack)this.getWidget((MUIElement)parent);
        if (widget == null) {
            this.getLogger().error("Could not find widget for '" + parent + "'");
            return;
        }
        for (MStackElement element : elements) {
            if (!this.isChildRenderedAndVisible((MUIElement)element)) continue;
            int idx = this.getRenderedIndex((MUIElement)parent, (MUIElement)element);
            @NonNull ElementRenderer renderer = this.getFactory().getRenderer((MUIElement)element);
            if (renderer != null) {
                WStack stack = widget;
                WStack.WStackItem<I, IC> item = (WStack.WStackItem<I, IC>)element.getTransientData().get(MAP_ITEM_KEY);
                if (item == null || !widget.getStackItemClass().isAssignableFrom(item.getClass())) {
                    item = this.createStackItem(widget, element, renderer);
                }
                stack.addItems(idx, Collections.singletonList(item));
                continue;
            }
            this.getLogger().error("Could not find renderer for '" + element + "'");
        }
        this.fixContextHierarchy(elements);
        if (parent.getSelectedElement() == null && !widget.getItems().isEmpty()) {
            parent.setSelectedElement((MUIElement)widget.getItems().get(0).getDomElement());
        }
    }

    void handleChildrenRemove(@NonNull MPartStack parent, Collection<MStackElement> elements) {
        WStack parentWidget = (WStack)this.getWidget((MUIElement)parent);
        if (parentWidget == null) {
            this.getLogger().error("Could not find widget for '" + parent + "'");
            return;
        }
        ArrayList<MStackElement> list = new ArrayList<MStackElement>(elements);
        MStackElement selectedElement = (MStackElement)parent.getSelectedElement();
        if (selectedElement != null && list.contains(selectedElement)) {
            list.remove(selectedElement);
            list.add(selectedElement);
        }
        List<@NonNull WStack.WStackItem<I, IC>> items = this.transmuteList(parentWidget, list);
        parentWidget.removeItems(items);
        Boolean b = (Boolean)this.application.getContext().get("__efx_engine_shutdown");
        if (b == null || !b.booleanValue()) {
            for (MStackElement element : list) {
                if (element.getTransientData().containsKey(MAP_MOVE)) continue;
                element.getTransientData().remove(MAP_ITEM_KEY);
            }
        }
        this.checkSelectedElement((MUIElement)parent);
    }

    private @NonNull List<@NonNull WStack.WStackItem<I, IC>> transmuteList(WStack<N, I, IC> parentWidget, ArrayList<MStackElement> list) {
        ArrayList<@NonNull WStack.WStackItem<I, IC>> resultList = new ArrayList<WStack.WStackItem<I, IC>>();
        for (WStack.WStackItem<I, IC> item : parentWidget.getItems()) {
            MStackElement domElement = item.getDomElement();
            if (domElement == null || !list.contains(domElement) || !domElement.isToBeRendered() || !this.isChildRenderedAndVisible((MUIElement)domElement)) continue;
            resultList.add(item);
        }
        return resultList;
    }

    void handleSelectedElement(@NonNull MPartStack parent, @Nullable MStackElement oldElement, @Nullable MStackElement _newElement) {
        MStackElement newElement = _newElement;
        if (newElement == null) {
            return;
        }
        WStack stack = (WStack)this.getWidget((MUIElement)parent);
        if (stack == null) {
            this.getLogger().error("Could not find widget for '" + parent + "'");
            return;
        }
        int idx = 0;
        for (WStack.WStackItem i : stack.getItems()) {
            if (i.getDomElement() == newElement) {
                stack.selectItem(idx);
                this.fixContextHierarchy((MUIElement)newElement);
                return;
            }
            ++idx;
        }
        this.childRendered(parent, (MUIElement)newElement);
        stack.selectItem(parent.getChildren().indexOf(newElement));
        this.fixContextHierarchy((MUIElement)newElement);
        this.activateLeafPart((MUIElement)newElement);
    }

    boolean handleStackItemClose(@NonNull MStackElement e, @NonNull WStack.WStackItem<I, IC> item) {
        MPart part;
        MPart mPart = part = e instanceof MCompositePart ? (MPart)e : this.getPart((MUIElement)e);
        if (part == null) {
            this.getLogger().error("Unable to extract part from '" + e + "'");
            return true;
        }
        if (!part.isCloseable()) {
            return false;
        }
        IEclipseContext partContext = part.getContext();
        IEclipseContext parentContext = this.getContextForParent((MUIElement)part);
        if (parentContext == null) {
            this.getLogger().error("The parent context is unknown. This is impossible.");
            return false;
        }
        IEclipseContext context = (partContext == null ? parentContext : partContext).createChild();
        if (partContext == null) {
            context.set(MPart.class, (Object)part);
        }
        EPartService partService = (EPartService)context.get(EPartService.class.getName());
        try {
            if (partService.savePart(part, true) && this.lifecycleService.validateAnnotation(PreClose.class, (MUIElement)part, context)) {
                partService.hidePart(part);
                return true;
            }
            return false;
        }
        finally {
            context.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void childRendered(MPartStack parentElement, MUIElement element) {
        if (element == null || this.inLazyInit || this.inContentProcessing((MUIElement)parentElement) || !this.isChildRenderedAndVisible(element)) {
            return;
        }
        WStack stack = (WStack)this.getWidget((MUIElement)parentElement);
        if (stack == null) {
            this.getLogger().error("Could not find widget for '" + parentElement + "'");
            return;
        }
        for (WStack.WStackItem i : stack.getItems()) {
            if (i.getDomElement() != element) continue;
            return;
        }
        @NonNull ElementRenderer renderer = this.getFactory().getRenderer(element);
        if (renderer != null) {
            int idx = this.getRenderedIndex((MUIElement)parentElement, element);
            stack.addItems(idx, Collections.singletonList(this.createStackItem(stack, (MStackElement)element, renderer)));
        } else {
            this.getLogger().error("Could not find renderer for '" + element + "'");
        }
    }

    public void hideChild(MPartStack container, MUIElement changedObj) {
        Boolean b;
        WStack stack = (WStack)this.getWidget((MUIElement)container);
        if (stack == null) {
            return;
        }
        WStack.WStackItem item = null;
        for (WStack.WStackItem i : stack.getItems()) {
            if (i.getDomElement() != changedObj) continue;
            item = i;
            break;
        }
        if (item != null) {
            List<Object> l = Collections.singletonList(item);
            stack.removeItems(l);
        }
        if (!((b = (Boolean)this.application.getContext().get("__efx_engine_shutdown")) != null && b.booleanValue() || !changedObj.getTags().contains("removeOnHide") || changedObj.isToBeRendered())) {
            container.getChildren().remove(changedObj);
        }
    }
}

