/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base.internal;

import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.ui.workbench.renderers.base.services.MaximizationService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMaximizationHost;
import org.eclipse.jdt.annotation.NonNull;

public class WindowMaximizationServiceImpl
implements MaximizationService {
    @Inject
    protected MWindow window;
    @Inject
    protected EModelService modelService;
    @Inject
    protected EPartService partService;
    protected MUIElement maximizedElement;

    @Override
    public void maximize(@NonNull MUIElement element) {
        MUIElement maxElement = element;
        MPlaceholder placeHolder = maxElement.getCurSharedRef();
        if (placeHolder != null) {
            maxElement = placeHolder;
        }
        if (this.maximizedElement != null) {
            if (this.maximizedElement == maxElement) {
                return;
            }
            this.restore();
        }
        WMaximizationHost widget = (WMaximizationHost)this.window.getWidget();
        WLayoutedWidget childWidget = (WLayoutedWidget)maxElement.getWidget();
        if (widget != null && childWidget != null) {
            widget.setMaximizedContent(childWidget);
            this.window.getPersistedState().put("MAXIMIZED", maxElement.getElementId());
            this.maximizedElement = maxElement;
        }
    }

    @Override
    public void restore() {
        WMaximizationHost widget = (WMaximizationHost)this.window.getWidget();
        WLayoutedWidget childWidget = null;
        childWidget = this.maximizedElement instanceof MPlaceholder ? (WLayoutedWidget)((MPlaceholder)this.maximizedElement).getRef().getWidget() : (WLayoutedWidget)this.maximizedElement.getWidget();
        if (widget != null && childWidget != null) {
            widget.removeMaximizedContent();
            this.window.getPersistedState().remove("MAXIMIZED");
            this.maximizedElement = null;
        }
    }

    @Override
    public boolean isMaximized(@NonNull MUIElement element) {
        MPlaceholder ref = element.getCurSharedRef();
        return this.maximizedElement == (ref != null ? ref : element);
    }
}

