/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.image;

import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import org.eclipse.fx.ui.controls.image.ImageCache;

public class ImageClipNode
extends StackPane {
    private static StyleablePropertyFactory<ImageClipNode> FACTORY = new StyleablePropertyFactory(StackPane.getClassCssMetaData());
    private final StyleableProperty<String> clipIconUrl = FACTORY.createStyleableUrlProperty((Styleable)this, "clipIconUrl", "-clip-icon-url", s -> s.clipIconUrl);

    public ImageClipNode() {
        this.getStyleClass().add((Object)"image-clip-node");
        ImageView view = new ImageView();
        this.clipIconUrlProperty().addListener((o, ol, ne) -> {
            ImageCache.CachedImage cachedImage = null;
            Image img = view.getImage();
            if (img instanceof ImageCache.CachedImage) {
                cachedImage = (ImageCache.CachedImage)img;
            }
            if (ne != null) {
                ImageCache.CachedImage image = ImageCache.getInstance().getImage((String)ne);
                view.setImage((Image)image);
                this.setPrefSize(image.getWidth(), image.getHeight());
                this.setMinSize(image.getWidth(), image.getHeight());
                this.setMaxSize(image.getWidth(), image.getHeight());
            }
            if (cachedImage != null) {
                cachedImage.releaseLazy();
            }
        });
        this.setClip((Node)view);
    }

    public ObservableValue<String> clipIconUrlProperty() {
        return (ObservableValue)this.clipIconUrl;
    }

    public final String getClipIconUrl() {
        return (String)this.clipIconUrl.getValue();
    }

    public final void setClipIconUrl(String clipIconUrl) {
        this.clipIconUrl.setValue((Object)clipIconUrl);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }
}

