/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.internal.databinding.BindingMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public final class AggregateValidationStatus
extends ComputedValue<IStatus> {
    public static final int MERGED = 1;
    public static final int MAX_SEVERITY = 2;
    private int strategy;
    private IObservableCollection validationStatusProviders;

    public AggregateValidationStatus(DataBindingContext dbc, int strategy) {
        this(dbc.getValidationRealm(), (IObservableCollection)dbc.getValidationStatusProviders(), strategy);
    }

    public AggregateValidationStatus(IObservableCollection validationStatusProviders, int strategy) {
        this(Realm.getDefault(), validationStatusProviders, strategy);
    }

    public AggregateValidationStatus(Realm realm, IObservableCollection validationStatusProviders, int strategy) {
        super(realm, IStatus.class);
        this.validationStatusProviders = validationStatusProviders;
        this.strategy = strategy;
    }

    protected IStatus calculate() {
        IStatus result = this.strategy == 1 ? AggregateValidationStatus.getStatusMerged((Collection)this.validationStatusProviders) : AggregateValidationStatus.getStatusMaxSeverity((Collection)this.validationStatusProviders);
        return result;
    }

    public static IStatus getStatusMerged(Collection validationStatusProviders) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        for (ValidationStatusProvider validationStatusProvider : validationStatusProviders) {
            IStatus status = (IStatus)validationStatusProvider.getValidationStatus().getValue();
            if (status.isOK()) continue;
            statuses.add(status);
        }
        if (statuses.size() == 1) {
            return (IStatus)statuses.get(0);
        }
        if (!statuses.isEmpty()) {
            MultiStatus result = new MultiStatus("org.eclipse.core.databinding", 0, BindingMessages.getString("MultipleProblems"), null);
            for (IStatus status : statuses) {
                result.merge(status);
            }
            return result;
        }
        return Status.OK_STATUS;
    }

    public static IStatus getStatusMaxSeverity(Collection validationStatusProviders) {
        int maxSeverity = 0;
        IStatus maxStatus = Status.OK_STATUS;
        for (ValidationStatusProvider validationStatusProvider : validationStatusProviders) {
            IStatus status = (IStatus)validationStatusProvider.getValidationStatus().getValue();
            if (status.getSeverity() <= maxSeverity) continue;
            maxSeverity = status.getSeverity();
            maxStatus = status;
        }
        return maxStatus;
    }
}

