/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.ui.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.ide.fxgraph.fXGraph.ComponentDefinition;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxgraph.generator.FXGraphGenerator;
import org.eclipse.fx.ide.ui.editor.IFXMLProviderAdapter;
import org.eclipse.fx.ide.ui.util.RelativeFileLocator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class FXMLProviderAdapter
implements IFXMLProviderAdapter {
    private XtextEditor editor;

    public FXMLProviderAdapter(XtextEditor editor) {
        this.editor = editor;
    }

    public IEditorPart getEditorPart() {
        return this.editor;
    }

    public String getPreviewFXML() {
        return (String)this.editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

            public String exec(XtextResource resource) throws Exception {
                FXGraphGenerator generator = new FXGraphGenerator();
                return generator.doGeneratePreview((Resource)resource, false, false);
            }
        });
    }

    public String getPreviewSceneFXML() {
        return (String)this.editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

            public String exec(XtextResource resource) throws Exception {
                ComponentDefinition def;
                if (!resource.getContents().isEmpty() && ((Model)resource.getContents().get(0)).getComponentDef() != null && (def = ((Model)resource.getContents().get(0)).getComponentDef()).getSceneDefinition() != null) {
                    FXGraphGenerator generator = new FXGraphGenerator();
                    return generator.doGeneratePreview(def.getSceneDefinition().eResource(), false, false);
                }
                return null;
            }
        });
    }

    public List<String> getPreviewCSSFiles() {
        return (List)this.editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<List<String>, XtextResource>(){

            public List<String> exec(XtextResource resource) throws Exception {
                ArrayList<String> cssFiles = new ArrayList<String>();
                EList contents = resource.getContents();
                if (!contents.isEmpty()) {
                    URI uri = resource.getURI();
                    EObject rootObject = (EObject)contents.get(0);
                    if (rootObject instanceof Model) {
                        ComponentDefinition def = ((Model)rootObject).getComponentDef();
                        cssFiles = new ArrayList(def.getPreviewCssFiles().size());
                        for (String cssFile : def.getPreviewCssFiles()) {
                            File absFile = RelativeFileLocator.locateFile((URI)uri, (String)cssFile);
                            if (absFile == null) continue;
                            try {
                                cssFiles.add(absFile.toURI().toURL().toExternalForm());
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                return cssFiles;
            }
        });
    }

    public String getPreviewResourceBundle() {
        return (String)this.editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

            public String exec(XtextResource resource) throws Exception {
                EList contents = resource.getContents();
                if (!contents.isEmpty()) {
                    File f;
                    ComponentDefinition def;
                    URI uri = resource.getURI();
                    EObject rootObject = (EObject)contents.get(0);
                    if (rootObject instanceof Model && (def = ((Model)rootObject).getComponentDef()) != null && def.getPreviewResourceBundle() != null && (f = RelativeFileLocator.locateFile((URI)uri, (String)def.getPreviewResourceBundle())) != null && f.exists()) {
                        return f.getAbsolutePath();
                    }
                }
                return null;
            }
        });
    }

    public List<URL> getPreviewClasspath() {
        return (List)this.editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<List<URL>, XtextResource>(){

            public List<URL> exec(XtextResource resource) throws Exception {
                ArrayList<URL> extraPaths = new ArrayList<URL>();
                EList contents = resource.getContents();
                if (!contents.isEmpty()) {
                    URI uri = resource.getURI();
                    IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(uri.segment(1));
                    IJavaProject jp = JavaCore.create((IProject)p);
                    EObject rootObject = (EObject)contents.get(0);
                    if (rootObject instanceof Model) {
                        ComponentDefinition def = ((Model)rootObject).getComponentDef();
                        for (String path : def.getPreviewClasspathEntries()) {
                            try {
                                File ioFile;
                                URI cpUri = URI.createURI((String)path);
                                if (cpUri.isPlatformResource()) {
                                    IWorkspaceRoot root;
                                    Path cpPath;
                                    if (cpUri.lastSegment().equals("*")) {
                                        cpUri = cpUri.trimSegments(1);
                                        cpPath = new Path(cpUri.toPlatformString(true));
                                        root = jp.getProject().getWorkspace().getRoot();
                                        IFolder f = root.getFolder((IPath)cpPath);
                                        if (!f.exists()) continue;
                                        IResource[] iResourceArray = f.members();
                                        int n = iResourceArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IResource r = iResourceArray[n2];
                                            IFile jarFile = (IFile)r;
                                            if (r instanceof IFile && "jar".equals(jarFile.getFileExtension())) {
                                                extraPaths.add(jarFile.getLocation().toFile().toURI().toURL());
                                            }
                                            ++n2;
                                        }
                                        continue;
                                    }
                                    cpPath = new Path(cpUri.toPlatformString(true));
                                    root = jp.getProject().getWorkspace().getRoot();
                                    IFile jarFile = root.getFile((IPath)cpPath);
                                    if (!jarFile.exists()) continue;
                                    try {
                                        extraPaths.add(jarFile.getLocation().toFile().toURI().toURL());
                                    }
                                    catch (MalformedURLException e) {
                                        e.printStackTrace();
                                    }
                                    continue;
                                }
                                if (!cpUri.isFile()) continue;
                                if (cpUri.toFileString().endsWith("*")) {
                                    ioFile = new File(cpUri.toFileString()).getParentFile();
                                    if (!ioFile.exists()) continue;
                                    try {
                                        File[] fileArray = ioFile.listFiles();
                                        int n = fileArray.length;
                                        int n3 = 0;
                                        while (n3 < n) {
                                            File jarFile = fileArray[n3];
                                            if (jarFile.getName().endsWith(".jar")) {
                                                extraPaths.add(jarFile.toURI().toURL());
                                            }
                                            ++n3;
                                        }
                                    }
                                    catch (MalformedURLException e) {
                                        e.printStackTrace();
                                    }
                                    continue;
                                }
                                ioFile = new File(cpUri.toFileString());
                                if (!ioFile.exists()) continue;
                                try {
                                    extraPaths.add(ioFile.toURI().toURL());
                                }
                                catch (MalformedURLException e) {
                                    e.printStackTrace();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                return extraPaths;
            }
        });
    }

    public IFile getFile() {
        return (IFile)this.editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<IFile, XtextResource>(){

            public IFile exec(XtextResource resource) throws Exception {
                URI uri = resource.getURI();
                Path structureFilePath = new Path(uri.toPlatformString(true));
                IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)structureFilePath);
                if (f.exists()) {
                    return f;
                }
                return null;
            }
        });
    }
}

