/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.production;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.MathHelper;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.common.progress.ProductionProgressMonitor;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.fc.generator.java.model.EcoreGenModelGenerator;
import org.eclipse.egf.model.Context;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.FactoryComponentInvocation;
import org.eclipse.egf.model.ModelFactory;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.pattern.PatternActivator;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.ecore.PatternSeeker;
import org.eclipse.egf.pattern.production.GeneratedContentProducer;
import org.eclipse.egf.pattern.production.Messages;
import org.eclipse.egf.pattern.production.PatternTemplateProducer;
import org.eclipse.egf.pattern.production.template.TemplateHelper;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternProducer {
    private static final Logger __logger = Logger.getLogger((String)PatternProducer.class.getPackage().getName());
    protected static final String JAVA_BUILDER_FACTORY_COMPONENT_ID = "java.builder.asset";
    protected static final String JAVA_BUILDER_FACTORY_COMPONENT_CONTRACT_FACTORY_COMPONENT_PROJECT_NAME = "java.builder.asset.contract.assetProjectName";
    protected static final String JAVA_CODE_GENERATOR_FACTORY_COMPONENT_CONTRACT_ELEMENT_JDK_COMPLIANCE_LEVEL = "javaCodeGeneratorAsset.contract.jdkComplianceLevel";
    protected static final String JAVA_CODE_GENERATOR_FACTORY_COMPONENT_CONTRACT_ELEMENT_GEN_MODEL_GENERATOR = "javaCodeGeneratorAsset.contract.genModelGenerator";
    protected static final String JAVA_CODE_GENERATOR_FACTORY_COMPONENT_CONTRACT_ELEMENT_BASE_PACKAGE = "javaCodeGeneratorAsset.contract.basePackage";
    protected static final String JAVA_CODE_GENERATOR_FACTORY_COMPONENT_CONTRACT_ELEMENT_FACTORY_COMPONENT_PROJECT_NAME = "javaCodeGeneratorAsset.contract.assetProjectName";
    protected static final String JAVA_CODE_GENERATOR_FACTORY_COMPONENT_CONTRACT_ELEMENT_INPUT_PATH = "javaCodeGeneratorAsset.contract.inputPath";
    protected static final String JAVA_CODE_GENERATOR_FACTORY_COMPONENT_CONTRACT_ELEMENT_MODEL_DIRECTORY = "javaCodeGeneratorAsset.contract.modelDirectory";
    protected static final String JAVA_CODE_GENERATOR_FACTORY_COMPONENT_ID = "javaCodeGeneratorAsset";
    private static PatternSeeker _seeker;

    protected static PatternSeeker getPatternSeeker() {
        if (_seeker == null) {
            _seeker = new PatternSeeker(true);
        }
        return _seeker;
    }

    protected boolean buildPatternProject(PatternHandler.PatternData patternData_p) {
        String referencedFcId = JAVA_BUILDER_FACTORY_COMPONENT_ID;
        Couple<FactoryComponent, Context> buildProjectFc = PatternProducer.createFactoryComponentSkeleton("patternProducer.factoryComponent.buildProject", referencedFcId);
        ModelHelper.addReferencingContractContextElement((Context)((Context)buildProjectFc.getValue()), (String)referencedFcId, (String)JAVA_BUILDER_FACTORY_COMPONENT_CONTRACT_FACTORY_COMPONENT_PROJECT_NAME, (String)patternData_p.getPluginId(), (String)PatternActivator.getDefault().getPluginID());
        return PatternProducer.generateFactoryComponent((FactoryComponent)buildProjectFc.getKey());
    }

    protected static Couple<FactoryComponent, Context> createFactoryComponentSkeleton(String fcName_p, String referencedFcId_p) {
        FactoryComponent fc = ModelHelper.createEmptyMinimalFC((String)fcName_p);
        FactoryComponentInvocation fcInvocation = ModelHelper.addFactoryComponentInvocation((FactoryComponent)fc, (String)referencedFcId_p);
        Context context = ModelFactory.eINSTANCE.createContext();
        fcInvocation.setContext(context);
        return new Couple((Object)fc, (Object)context);
    }

    protected static boolean generateFactoryComponent(FactoryComponent fc_p) {
        return CoreActivator.getDefault().generateFactoryComponentSynchronously(fc_p);
    }

    protected static boolean generatePatternClasses(PatternHandler.PatternData patternData_p) {
        IJavaProject javaProject = patternData_p.getJavaProject();
        if (javaProject == null) {
            return false;
        }
        try {
            GeneratedContentProducer conditionProducer = new GeneratedContentProducer();
            conditionProducer.produceConditionStructures(patternData_p);
            conditionProducer.getProductionContributor().fillGenerateHeader(patternData_p, null);
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("PatternProducer.generatePatternClasses(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        PatternProducer.ensurePatternsJavaFiles(patternData_p.getPatternDependenciesIds());
        String referencedFcId = JAVA_CODE_GENERATOR_FACTORY_COMPONENT_ID;
        Couple<FactoryComponent, Context> producePatternCouple = PatternProducer.createFactoryComponentSkeleton("patternProducer.factoryComponent.ecoreToJava", referencedFcId);
        Context context = (Context)producePatternCouple.getValue();
        context.getContextElements().clear();
        String contributorId = PatternActivator.getDefault().getPluginID();
        ModelHelper.addReferencingContractContextElement((Context)context, (String)referencedFcId, (String)JAVA_CODE_GENERATOR_FACTORY_COMPONENT_CONTRACT_ELEMENT_MODEL_DIRECTORY, (String)new Path("/generated").segment(0), (String)contributorId);
        ModelHelper.addReferencingContractContextElement((Context)context, (String)referencedFcId, (String)JAVA_CODE_GENERATOR_FACTORY_COMPONENT_CONTRACT_ELEMENT_INPUT_PATH, (String)patternData_p.getRealRelativePath(), (String)contributorId);
        ModelHelper.addReferencingContractContextElement((Context)context, (String)referencedFcId, (String)JAVA_CODE_GENERATOR_FACTORY_COMPONENT_CONTRACT_ELEMENT_FACTORY_COMPONENT_PROJECT_NAME, (String)patternData_p.getPluginId(), (String)contributorId);
        ModelHelper.addReferencingContractContextElement((Context)context, (String)referencedFcId, (String)JAVA_CODE_GENERATOR_FACTORY_COMPONENT_CONTRACT_ELEMENT_BASE_PACKAGE, (String)"org.eclipse.egf.pattern", (String)contributorId);
        ModelHelper.addReferencingContractContextElement((Context)context, (String)referencedFcId, (String)JAVA_CODE_GENERATOR_FACTORY_COMPONENT_CONTRACT_ELEMENT_GEN_MODEL_GENERATOR, (String)EcoreGenModelGenerator.class.getName(), (String)contributorId);
        ModelHelper.addReferencingContractContextElement((Context)context, (String)referencedFcId, (String)JAVA_CODE_GENERATOR_FACTORY_COMPONENT_CONTRACT_ELEMENT_JDK_COMPLIANCE_LEVEL, (String)GenJDKLevel.JDK50_LITERAL.getLiteral(), (String)contributorId);
        return PatternProducer.generateFactoryComponent((FactoryComponent)producePatternCouple.getKey());
    }

    protected static void ensurePatternsJavaFiles(Set<String> fullIds_p) {
        if (fullIds_p == null) {
            return;
        }
        ArrayList<PatternHandler.PatternData> patternsData = new ArrayList<PatternHandler.PatternData>(0);
        for (String patternId : fullIds_p) {
            patternsData.addAll(PatternProducer.getPatternSeeker().getPatternsData(patternId));
        }
        for (PatternHandler.PatternData patternData : patternsData) {
            PatternProducer.generatePatternClasses(patternData);
        }
    }

    protected static boolean handlePatternsProduction(List<PatternHandler.PatternData> data_p, SubMonitor monitor_p, int ticksCount_p) {
        boolean result = true;
        int stepCount = ticksCount_p / data_p.size();
        for (PatternHandler.PatternData patternData : data_p) {
            boolean proceed;
            ProductionProgressMonitor monitor = new ProductionProgressMonitor(monitor_p, patternData.getPatternLogicalName(), stepCount);
            boolean bl = proceed = patternData.getJavaProject() != null;
            if (proceed) {
                proceed = PatternProducer.generatePatternClasses(patternData);
            }
            result &= proceed;
            monitor.end();
        }
        return result;
    }

    public static boolean producePatterns(String fullId_p, IProgressMonitor progressMonitor_p) {
        boolean result;
        boolean bl = result = fullId_p != null;
        if (!result) {
            progressMonitor_p.done();
            return result;
        }
        try {
            String productionMessage = String.valueOf(Messages.PatternProducer_ProgressReporting_Title) + fullId_p;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor_p, (String)productionMessage, (int)1000);
            int ticksCount = MathHelper.multiply((int)1000, (float)0.1f);
            List<PatternHandler.PatternData> patternsData = PatternProducer.getPatternSeeker().getPatternsData(fullId_p);
            int patternsCount = patternsData.size();
            subMonitor.worked(ticksCount);
            ticksCount = 1000 - ticksCount;
            subMonitor.setWorkRemaining(ticksCount);
            boolean bl2 = result = patternsCount > 0;
            if (result) {
                PatternProducer.handlePatternsProduction(patternsData, subMonitor, ticksCount);
                subMonitor.setWorkRemaining(0);
            }
        }
        catch (Throwable throwable) {
            progressMonitor_p.done();
            result &= !progressMonitor_p.isCanceled();
            throw throwable;
        }
        progressMonitor_p.done();
        return result &= !progressMonitor_p.isCanceled();
    }

    public String generatePatterns(String fullId_p, Object classLoader_p) {
        String result = "";
        if (fullId_p == null || !(classLoader_p instanceof ClassLoader)) {
            return result;
        }
        ClassLoader usableClassLoader = (ClassLoader)classLoader_p;
        List<PatternHandler.PatternData> patternsData = PatternProducer.getPatternSeeker().getPatternsData(fullId_p);
        if (patternsData.size() < 0) {
            return result;
        }
        StringBuilder resultingBuilder = new StringBuilder();
        for (PatternHandler.PatternData patternData : patternsData) {
            PatternProducer.generatePatternClasses(patternData);
            String patternTemplate = PatternTemplateProducer.getPatternTemplateAsString(patternData, usableClassLoader);
            if (patternTemplate == null) continue;
            resultingBuilder.append(patternTemplate);
        }
        return resultingBuilder.toString();
    }

    public static void cleanGeneratedStructures(IJavaProject javaProject_p, IDescriptor descriptor_p) {
        if (javaProject_p == null || descriptor_p == null) {
            return;
        }
        IPluginModelBase model = PluginRegistry.findModel((IProject)javaProject_p.getProject());
        if (model == null) {
            return;
        }
        String patternShortId = (String)descriptor_p.getValue("id");
        String cfr_ignored_0 = (String)descriptor_p.getValue("path");
        String cfr_ignored_1 = (String)descriptor_p.getValue("class");
        FileHelper.deleteResource((IFolder)TemplateHelper.getTemplateRootIFolder(javaProject_p), (IResource)TemplateHelper.getGeneratedPatternTemplateIFolder(javaProject_p, patternShortId), (boolean)true);
    }
}

