/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.viewers;

import org.eclipse.egf.common.constant.ICommonConstants;
import org.eclipse.egf.common.ui.resource.BasicImageRegistry;
import org.eclipse.egf.core.data.helper.DataHelper;
import org.eclipse.egf.core.ui.data.ElementAdapterFactory;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class AdaptedModelElementLabelProvider
implements ILabelProvider,
IDescriptionProvider {
    private AdapterFactoryLabelProvider _adapterFactoryLabelProvider;

    public AdaptedModelElementLabelProvider(AdapterFactory adapterFactory_p) {
        this._adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(adapterFactory_p);
    }

    public Image getImage(Object element_p) {
        Image result = null;
        if (element_p instanceof NamedModelElementWithId) {
            result = this._adapterFactoryLabelProvider.getImage(element_p);
        } else {
            ImageDescriptor descriptor;
            IWorkbenchAdapter adapter = ElementAdapterFactory.getWorkbenchAdapter(element_p);
            if (adapter != null && (descriptor = adapter.getImageDescriptor(element_p)) != null) {
                result = BasicImageRegistry.getInstance().getImage(descriptor);
            }
        }
        return result;
    }

    public String getText(Object element_p) {
        String text = "";
        if (element_p instanceof NamedModelElementWithId) {
            text = this._adapterFactoryLabelProvider.getText(element_p);
        } else {
            IWorkbenchAdapter adapter = ElementAdapterFactory.getWorkbenchAdapter(element_p);
            if (adapter != null) {
                text = adapter.getLabel(element_p);
            }
        }
        return text;
    }

    public String getDescription(Object element_p) {
        String description = null;
        if (element_p instanceof NamedModelElementWithId && (description = DataHelper.getDescription((NamedModelElementWithId)((NamedModelElementWithId)element_p))) != null) {
            description = description.replace(ICommonConstants.LINE_SEPARATOR, String.valueOf(' '));
            description = description.replace('\n', ' ');
        }
        return description;
    }

    public void addListener(ILabelProviderListener listener_p) {
        this._adapterFactoryLabelProvider.addListener(listener_p);
    }

    public void dispose() {
        this._adapterFactoryLabelProvider.dispose();
    }

    public boolean isLabelProperty(Object element_p, String property_p) {
        return this._adapterFactoryLabelProvider.isLabelProperty(element_p, property_p);
    }

    public void removeListener(ILabelProviderListener listener_p) {
        this._adapterFactoryLabelProvider.removeListener(listener_p);
    }
}

