/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.ui.helper.FieldEditorHelper;
import org.eclipse.egf.common.ui.toolkit.fields.IFieldEditor;
import org.eclipse.egf.core.ui.internal.help.IHelpContextIds;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.AbstractModelElementWizardPage;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractDomainWizardPage
extends AbstractModelElementWizardPage {
    private static final String DOMAIN_FILE_EXTENSION = "*.ecore";
    protected static final String DEFAULT_DOMAIN_FILE_NAME = "domain/domain.ecore";
    protected static final String DOMAIN_RELATIVE_FOLDER_PATH = "model";
    private IFieldEditor _domainFileNameFieldEditor;

    public AbstractDomainWizardPage(String pageName_p) {
        super(pageName_p);
    }

    public AbstractDomainWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
    }

    protected String getDefaultDomainFilePath() {
        IFolder domainFolder = this.getDomainFolder();
        IFile domainFile = domainFolder.getFile(DEFAULT_DOMAIN_FILE_NAME);
        IPath relativeDomainFilePath = domainFile.getFullPath().removeFirstSegments(1);
        return relativeDomainFilePath.toString();
    }

    protected void createDomainFileFieldEditor(Composite parent_p) {
        IFolder domainFolder = this.getDomainFolder();
        String pattern = this.getDomainFileExtension();
        this._domainFileNameFieldEditor = FieldEditorHelper.createDomainFieldEditor((Composite)parent_p, (String)Messages.NewDomainWizardPage_Domain_Title, (String)Messages.EditDomainWizardPage_OpenResourceDialog_Title, (IContainer)domainFolder, (String)pattern, (boolean)this.isReadOnly());
        Text domainPath = (Text)this._domainFileNameFieldEditor.getValueControl();
        this.bindTextToAttribute(domainPath, ModelPackage.Literals.DOMAIN__PATH, this.getModelElement(), null);
    }

    protected boolean isDomainSelectedExist() {
        boolean result = false;
        String relativeDomainPath = ((Text)this.getDomainFileNameFieldEditor().getValueControl()).getText();
        IJavaProject hostingProject = this.getHostingProject();
        if (hostingProject != null) {
            IProject containerProject = hostingProject.getProject();
            IFile domainFile = containerProject.getFile(relativeDomainPath);
            result = domainFile.exists();
        }
        return result;
    }

    private IFolder getDomainFolder() {
        IFolder result = null;
        IJavaProject hostingProject = this.getHostingProject();
        if (hostingProject != null) {
            IProject project = hostingProject.getProject();
            result = project.getFolder(DOMAIN_RELATIVE_FOLDER_PATH);
            FileHelper.ensurePathAvailability((String)result.toString());
        }
        return result;
    }

    private String getDomainFileExtension() {
        return DOMAIN_FILE_EXTENSION;
    }

    protected String getHelpContextId() {
        return IHelpContextIds.NEW_DOMAIN_WIZARD_PAGE;
    }

    protected IFieldEditor getDomainFileNameFieldEditor() {
        return this._domainFileNameFieldEditor;
    }
}

