/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.action.explorer;

import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.ui.workbench.Messages;
import org.eclipse.egf.core.ui.workbench.action.navigator.AbstractModelElementAction;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.PatternModel;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractCleanPatternElementAction
extends AbstractModelElementAction {
    private static final Logger __logger = Logger.getLogger((String)AbstractCleanPatternElementAction.class.getPackage().getName());

    public AbstractCleanPatternElementAction(Shell shell_p, ISelectionProvider selectionProvider_p, boolean readOnlyMode_p) {
        super(shell_p, selectionProvider_p, readOnlyMode_p);
        this.setId("org.eclipse.egf.core.ui.workbench.action.explorer.clean");
        this.setText(Messages.CleanPatternAction_Title);
        this.setToolTipText(Messages.CleanPatternAction_Tooltip);
    }

    public void run() {
        boolean cleanConfirmed = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.CleanPatternActionConfirmDialog_Title, (String)this.getConfirmationMessage());
        if (cleanConfirmed) {
            this.doCleanPatternElement();
        }
    }

    protected abstract String getConfirmationMessage();

    protected abstract void doCleanPatternElement();

    protected Wizard getWizardFor(NamedModelElementWithId selectedModelElement_p) {
        return null;
    }

    protected void clean(PatternModel pattern_p, IProgressMonitor monitor_p) {
        if (pattern_p == null) {
            return;
        }
        PatternHandler patternHandler = this.getPatternHandler(pattern_p);
        patternHandler.cleanGeneratedStructures();
        monitor_p.worked(1);
    }

    protected PatternHandler getPatternHandler(PatternModel pattern_p) {
        PatternHandler patternHandler = new PatternHandler();
        try {
            patternHandler.load(pattern_p.getPath());
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("AbstractCleanPatternElementAction.getPatternHandler(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return patternHandler;
    }
}

