/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.generator;

import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.eclipse.egf.common.generator.EmfProjectType;
import org.eclipse.egf.common.internal.generator.emf.CustomizedGenerator;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.jdt.core.JavaCore;

public class EmfProjectGenerator {
    private static final Logger __logger = Logger.getLogger((String)EmfProjectGenerator.class.getPackage().getName());
    private Generator _generator;
    private GeneratorAdapterFactory _generatorAdapterFactory;
    private EmfProjectType _projectType;

    public EmfProjectGenerator(GeneratorAdapterFactory generatorAdapterFactory_p, EmfProjectType projectType_p) {
        this._generatorAdapterFactory = generatorAdapterFactory_p;
        this._projectType = projectType_p;
    }

    protected boolean initialize(GenModel genModel_p) {
        genModel_p.reconcile();
        genModel_p.setCanGenerate(true);
        boolean result = this.validate(genModel_p);
        if (!result) {
            return result;
        }
        this._generator = new CustomizedGenerator(this._generatorAdapterFactory);
        this._generator.setInput((Object)genModel_p);
        JControlModel jControlModel = this._generator.getJControlModel();
        if (genModel_p.isCodeFormatting()) {
            jControlModel.setLeadingTabReplacement(null);
            jControlModel.setConvertToStandardBraceStyle(false);
        } else {
            Hashtable options = JavaCore.getOptions();
            String tabSize = (String)options.get("org.eclipse.jdt.core.formatter.tabulation.size");
            String braceStyle = (String)options.get("org.eclipse.jdt.core.formatter.brace_position_for_type_declaration");
            String tabCharacter = (String)options.get("org.eclipse.jdt.core.formatter.tabulation.char");
            if ("tab".equals(tabCharacter)) {
                jControlModel.setLeadingTabReplacement(String.valueOf('\t'));
            } else {
                StringBuffer spaces = new StringBuffer("");
                int i = Integer.parseInt(tabSize);
                while (i > 0) {
                    spaces.append("");
                    --i;
                }
                jControlModel.setLeadingTabReplacement(spaces.toString());
            }
            jControlModel.setConvertToStandardBraceStyle("end_of_line".equals(braceStyle));
        }
        return result;
    }

    public boolean generate(Monitor monitor_p, GenModel genModel_p) {
        boolean isCorrect;
        String projectTypeValue = this._projectType.getValue();
        boolean bl = isCorrect = this.initialize(genModel_p) && this._generator.canGenerate((Object)genModel_p, (Object)projectTypeValue);
        if (isCorrect) {
            Diagnostic diagnostic = this._generator.generate((Object)genModel_p, (Object)projectTypeValue, null, monitor_p);
            isCorrect = this.handleDiagnostic(diagnostic, "Java Code generation failed for: " + genModel_p.toString());
        }
        return isCorrect;
    }

    protected boolean validate(GenModel genModel_p) {
        boolean result = true;
        return result;
    }

    protected boolean handleDiagnostic(Diagnostic diagnostic_p, String message_p) {
        boolean result = true;
        if (diagnostic_p.getSeverity() != 0) {
            StringBuffer loggerMessage = new StringBuffer("AbstractGenerator.handleDiagnostic(..) _ ");
            loggerMessage.append(message_p);
            loggerMessage.append(' ');
            loggerMessage.append(diagnostic_p.getMessage());
            for (Diagnostic diagnostic : diagnostic_p.getChildren()) {
                this.handleDiagnostic(diagnostic, message_p);
            }
            Throwable exception = diagnostic_p.getException();
            if (exception != null) {
                loggerMessage.append(exception.getMessage());
                __logger.fatal((Object)loggerMessage.toString(), exception);
            } else {
                __logger.fatal((Object)loggerMessage.toString());
            }
            result = false;
        }
        return result;
    }
}

