/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.field;

import org.eclipse.egf.common.ui.field.ValidatingStringButtonFieldEditor;
import org.eclipse.egf.common.ui.helper.MessageFormatHelper;
import org.eclipse.egf.common.ui.internal.validators.JavaClassValidator;
import org.eclipse.egf.common.ui.toolkit.validators.IValidator;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassFieldEditor
extends ValidatingStringButtonFieldEditor {
    private String _openTypeDialogTitle;
    private Class<?> _classTypeFilter;

    public JavaClassFieldEditor(String title_p, String openTypeDialogTitle_p, Composite parent_p, Class<?> classTypeFilter_p) {
        super(parent_p, title_p, null);
        this._openTypeDialogTitle = openTypeDialogTitle_p;
        this._classTypeFilter = classTypeFilter_p;
        this.addListeners();
    }

    @Override
    protected String handleSelection(Object selectedObject_p) {
        IType type = (IType)selectedObject_p;
        return type.getFullyQualifiedName();
    }

    @Override
    protected SelectionDialog createDialog() {
        OpenTypeSelectionDialog dialog = new OpenTypeSelectionDialog(this.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), null, 10, null);
        String dialogTitle = this._openTypeDialogTitle;
        if (this._classTypeFilter != null) {
            String fullyQualifiedFilteredClassName = this._classTypeFilter.getName();
            dialogTitle = this.getFormattedOpenTypeDialogTitle(fullyQualifiedFilteredClassName);
        }
        dialog.setTitle(dialogTitle);
        dialog.setMessage(JavaUIMessages.OpenTypeAction_dialogMessage);
        return dialog;
    }

    public void setClassTypeFilter(Class<?> classTypeFilter_p) {
        this._classTypeFilter = classTypeFilter_p;
        IValidator validator = this.getValidator();
        if (validator != null && validator instanceof JavaClassValidator) {
            JavaClassValidator javaClassValidator = (JavaClassValidator)validator;
            javaClassValidator.setExpectedClassType(this._classTypeFilter);
        }
    }

    private String getFormattedOpenTypeDialogTitle(String fullyQualifiedFilteredClassName_p) {
        int lastDotIndex = fullyQualifiedFilteredClassName_p.lastIndexOf(46);
        return MessageFormatHelper.formatMessage(this._openTypeDialogTitle, new String[]{fullyQualifiedFilteredClassName_p.substring(lastDotIndex + 1)});
    }

    protected void addListeners() {
        this.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e_p) {
                JavaClassFieldEditor.this.refreshValidState();
            }
        });
    }
}

