/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.viewers;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractTooltipLabelProvider
extends CellLabelProvider
implements ILabelProvider {
    protected static final int TOOLTIP_TIME_DISPLAYED = 7000;
    protected static final int DISPLAY_DELAY_TIME = 2000;
    private int _tooltipTimeDisplayed;
    private int _tooltipDisplayDelayTime;
    private ILabelProvider _labelProvider;

    protected AbstractTooltipLabelProvider(ILabelProvider labelProvider_p, int tooltipTimeDisplayed_p, int tooltipDisplayDelayTime_p) {
        this._labelProvider = labelProvider_p;
        this._tooltipTimeDisplayed = tooltipTimeDisplayed_p;
        this._tooltipDisplayDelayTime = tooltipDisplayDelayTime_p;
    }

    protected AbstractTooltipLabelProvider(ILabelProvider labelProvider_p) {
        this(labelProvider_p, 7000, 2000);
    }

    public abstract String getToolTipText(Object var1);

    public Point getToolTipShift(Object object_p) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object_p) {
        return this._tooltipDisplayDelayTime;
    }

    public int getToolTipTimeDisplayed(Object object_p) {
        return this._tooltipTimeDisplayed;
    }

    public void update(ViewerCell viewer_p) {
        Object element = viewer_p.getElement();
        viewer_p.setText(this.getText(element));
        viewer_p.setImage(this.getImage(element));
    }

    public Image getImage(Object element_p) {
        return this._labelProvider.getImage(element_p);
    }

    public String getText(Object element_p) {
        return this._labelProvider.getText(element_p);
    }

    public void addListener(ILabelProviderListener listener_p) {
        super.addListener(listener_p);
        this._labelProvider.addListener(listener_p);
    }

    public void dispose() {
        super.dispose();
        this._labelProvider.dispose();
    }

    public boolean isLabelProperty(Object element_p, String property_p) {
        return super.isLabelProperty(element_p, property_p) && this._labelProvider.isLabelProperty(element_p, property_p);
    }

    public void removeListener(ILabelProviderListener listener_p) {
        super.removeListener(listener_p);
        this._labelProvider.removeListener(listener_p);
    }
}

