/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.data.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.model.Context;
import org.eclipse.egf.model.ContextElement;
import org.eclipse.egf.model.Contract;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.ContractElementReference;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.FactoryComponentInvocation;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.ProductionPlan;
import org.eclipse.egf.model.Type;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataHelper
extends ModelHelper {
    private static final Logger __logger = Logger.getLogger((String)DataHelper.class.getPackage().getName());

    public static Collection<ContractElement> getPossibleReferencedContractElement(FactoryComponent factoryComponent_p) {
        HashSet<ContractElement> possibleContractElements = new HashSet<ContractElement>(0);
        if (factoryComponent_p == null) {
            return possibleContractElements;
        }
        Contract referencedFcContract = ModelHelper.getContract((FactoryComponent)factoryComponent_p);
        if (referencedFcContract != null) {
            possibleContractElements.addAll((Collection<ContractElement>)referencedFcContract.getContractElements());
        }
        return possibleContractElements;
    }

    public static Collection<FactoryComponent> getReferencedFactoryComponentsBy(FactoryComponent factoryComponent_p) {
        HashSet<FactoryComponent> referencedFcs = new HashSet<FactoryComponent>(0);
        if (factoryComponent_p == null) {
            return referencedFcs;
        }
        ProductionPlan productionPlan = DataHelper.getProductionPlan((FactoryComponent)factoryComponent_p);
        if (productionPlan != null) {
            EList fcConfigurations = productionPlan.getFactoryComponentInvocations();
            for (FactoryComponentInvocation fcConfiguration : fcConfigurations) {
                String pointedFcId = fcConfiguration.getFactoryComponentId();
                FactoryComponent pointedFc = CoreActivator.getDefault().getFactoryComponent(pointedFcId);
                referencedFcs.add(pointedFc);
            }
        }
        return referencedFcs;
    }

    public static Collection<ContractElement> getReferencedContractElementsFor(ContractElement contractElement_p) {
        if (contractElement_p == null) {
            return Collections.emptyList();
        }
        EList contractElementReferences = contractElement_p.getContractElementReferences();
        int contractElementReferenceCount = contractElementReferences.size();
        HashSet<ContractElement> referencedContractElements = new HashSet<ContractElement>(contractElementReferenceCount);
        for (ContractElementReference contractElementReference : contractElementReferences) {
            DataHelper.resolveContractElement(contractElementReference);
            referencedContractElements.add(contractElementReference.getReferencedContractElement());
        }
        return referencedContractElements;
    }

    public static Collection<ContractElement> getReferencedContractElementsFor(Contract contract_p) {
        if (contract_p == null) {
            return Collections.emptyList();
        }
        HashSet<ContractElement> referencedContractElements = new HashSet<ContractElement>(0);
        EList contractElements = contract_p.getContractElements();
        for (ContractElement currentContractElement : contractElements) {
            referencedContractElements.addAll(DataHelper.getReferencedContractElementsFor(currentContractElement));
        }
        return referencedContractElements;
    }

    public static ContractElement getReferencedContractElementFor(ContextElement contextElement_p) {
        ContractElement result = null;
        if (contextElement_p == null) {
            return result;
        }
        ContractElementReference contractElementReference = contextElement_p.getContractElementReference();
        if (contractElementReference != null) {
            DataHelper.resolveContractElement(contractElementReference);
            result = contractElementReference.getReferencedContractElement();
        }
        return result;
    }

    public static Collection<ContractElement> getReferencedContractElementsFor(Context context_p) {
        if (context_p == null) {
            return Collections.emptyList();
        }
        HashSet<ContractElement> referencedContractElements = new HashSet<ContractElement>(0);
        EList contextElements = context_p.getContextElements();
        for (ContextElement currentContextElement : contextElements) {
            ContractElement contractElement = DataHelper.getReferencedContractElementFor(currentContextElement);
            if (contractElement == null) continue;
            referencedContractElements.add(contractElement);
        }
        return referencedContractElements;
    }

    public static void resolveContractElement(ContractElementReference contractElementReference_p) {
        if (contractElementReference_p == null) {
            return;
        }
        ContractElement contractElement = contractElementReference_p.getReferencedContractElement();
        if (contractElement != null) {
            return;
        }
        EAttribute contractElementMatchingFeature = ModelPackage.Literals.NAMED_MODEL_ELEMENT_WITH_ID__ID;
        String contractElementMatchingValue = contractElementReference_p.getReferencedContractElementId();
        boolean updateContractElementIdIsNeeded = false;
        if (contractElementMatchingValue == null) {
            contractElementMatchingValue = contractElementReference_p.getReferencedContractElementName();
            contractElementMatchingFeature = ModelPackage.Literals.NAMED_MODEL_ELEMENT_WITH_ID__NAME;
            updateContractElementIdIsNeeded = true;
        }
        if ((contractElement = DataHelper.getReferencedContractElement(contractElementReference_p.getReferencedFactoryComponentId(), (EStructuralFeature)contractElementMatchingFeature, contractElementMatchingValue)) != null) {
            contractElementReference_p.setReferencedContractElement(contractElement);
            if (updateContractElementIdIsNeeded) {
                contractElementReference_p.setReferencedContractElementId(contractElement.getId());
            }
            for (ContractElementReference reference : contractElement.getContractElementReferences()) {
                DataHelper.resolveContractElement(reference);
            }
        }
    }

    public static String getLabel(ContextElement contextElement_p) {
        ContractElementReference contractElementReference;
        String label = contextElement_p.getKey();
        if (label == null && (contractElementReference = contextElement_p.getContractElementReference()) != null) {
            DataHelper.resolveContractElement(contractElementReference);
            ContractElement referencedContractElement = contractElementReference.getReferencedContractElement();
            if (referencedContractElement != null) {
                label = referencedContractElement.getName();
            }
        }
        label = label == null ? "" : label;
        return label;
    }

    public static String getDescription(NamedModelElementWithId element_p) {
        Collection<ContractElement> referencedContractElements;
        String description = null;
        if (element_p == null) {
            return description;
        }
        description = element_p.getDescription();
        if (element_p instanceof ContractElement && (description == null || "".equals(description)) && (referencedContractElements = DataHelper.getReferencedContractElementsFor((ContractElement)element_p)).size() == 1) {
            ContractElement referencedContractElement = referencedContractElements.iterator().next();
            description = DataHelper.getDescription((NamedModelElementWithId)referencedContractElement);
        }
        return description;
    }

    public static String getContextType(ContextElement contextElement_p) {
        String result = "";
        Type contextType = contextElement_p.getContextType();
        if (contextType != null) {
            result = contextType.getTypeHolderClassName();
        } else {
            ContractElementReference contractElementReference = contextElement_p.getContractElementReference();
            if (contractElementReference != null) {
                DataHelper.resolveContractElement(contractElementReference);
                ContractElement referencedContractElement = contractElementReference.getReferencedContractElement();
                if (referencedContractElement != null) {
                    result = referencedContractElement.getContractType().getTypeHolderClassName();
                }
            }
        }
        if (result == null) {
            StringBuilder loggerMessage = new StringBuilder("DataHelper.getContextType(..) _ ");
            loggerMessage.append("Context element:");
            loggerMessage.append(contextElement_p.getId()).append(" does not have a Type!!!");
            __logger.warn((Object)loggerMessage.toString());
        }
        return result;
    }

    public static List<ContractElement> getMandatoryContractElementWithNoDefaultValue(FactoryComponent factoryComponent_p) {
        List<Object> result = new ArrayList<ContractElement>(0);
        if (factoryComponent_p == null) {
            return result;
        }
        ProductionPlan productionPlan = DataHelper.getProductionPlan((FactoryComponent)factoryComponent_p);
        if (productionPlan == null) {
            return result;
        }
        Context productionPlanContext = productionPlan.getContext();
        if (productionPlanContext == null) {
            return result;
        }
        Collection<ContractElement> referencedContractElementsByProductionPlanContext = DataHelper.getReferencedContractElementsFor(productionPlanContext);
        result = DataHelper.getMandatoryContractElement((FactoryComponent)factoryComponent_p);
        result.removeAll(referencedContractElementsByProductionPlanContext);
        return result;
    }

    public static boolean isBootstrapFactoryComponent(String factoryComponentId_p) {
        return "rootAsset".equals(factoryComponentId_p);
    }

    private static ContractElement getReferencedContractElement(String factoryComponentId_p, EStructuralFeature contractElementMatchingFeature_p, String contractElementMatchingValue_p) {
        ContractElement result = null;
        FactoryComponent fc = CoreActivator.getDefault().getFactoryComponent(factoryComponentId_p);
        if (fc != null) {
            Contract contract = ModelHelper.getContract((FactoryComponent)fc);
            Iterator contractElements = contract.getContractElements().iterator();
            while (contractElements.hasNext() && result == null) {
                ContractElement contractElement = (ContractElement)contractElements.next();
                if (!contractElementMatchingValue_p.equals(contractElement.eGet(contractElementMatchingFeature_p))) continue;
                result = contractElement;
            }
        } else {
            StringBuffer loggerMessage = new StringBuffer("DataHelper.getReferencedContractElement(..) _ ");
            loggerMessage.append("could not find factory component ");
            loggerMessage.append(factoryComponentId_p);
            loggerMessage.append(" , while searching for contract element ");
            loggerMessage.append(contractElementMatchingValue_p);
            loggerMessage.append(" !");
            __logger.error((Object)loggerMessage.toString());
        }
        return result;
    }
}

