/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.internal.reader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.helper.ExtensionPointHelper;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.core.internal.reader.DefaultFactoryComponentReader;
import org.eclipse.egf.core.reader.descriptor.ContextDescriptor;
import org.eclipse.egf.core.reader.descriptor.ContractDescriptor;
import org.eclipse.egf.core.reader.descriptor.ContractElementReferenceDescriptor;
import org.eclipse.egf.core.reader.descriptor.FactoryComponentInvocationDescriptor;
import org.eclipse.egf.core.reader.descriptor.ProductionPlanDescriptor;
import org.eclipse.egf.core.reader.descriptor.TaskFactoryDescriptor;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentReader;
import org.eclipse.egf.model.data.reader.descriptor.IProductionPlanDescriptor;
import org.eclipse.egf.model.data.reader.descriptor.ITypedDescriptor;
import org.eclipse.egf.model.internal.data.ModelElement;

public class FactoryComponentReaderChain
implements IFactoryComponentReader {
    private static final String FACTORY_COMPONENT_READER_EXTENSION_POINT_ID = "factoryComponentReader";
    private static FactoryComponentReaderChain __instance;
    private List<IFactoryComponentReader> _factoryComponentReaders = new ArrayList<IFactoryComponentReader>(1);

    private FactoryComponentReaderChain() {
        IConfigurationElement[] configurationElementReaders;
        this._factoryComponentReaders.add(new DefaultFactoryComponentReader());
        IConfigurationElement[] iConfigurationElementArray = configurationElementReaders = ExtensionPointHelper.getConfigurationElements((String)CoreActivator.getDefault().getPluginID(), (String)FACTORY_COMPONENT_READER_EXTENSION_POINT_ID);
        int n = configurationElementReaders.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            IFactoryComponentReader reader = (IFactoryComponentReader)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
            this._factoryComponentReaders.add(reader);
            ++n2;
        }
    }

    public static IFactoryComponentReader getInstance() {
        if (__instance == null) {
            __instance = new FactoryComponentReaderChain();
        }
        return __instance;
    }

    private IFactoryComponentReader getFactoryComponentReader(String factoryComponentId_p) {
        IFactoryComponentReader retrievedReader = null;
        FactoryComponent fc = CoreActivator.getDefault().getFactoryComponent(factoryComponentId_p);
        if (fc != null) {
            retrievedReader = ((ModelElement)fc).getFactoryComponentReader();
        }
        return retrievedReader;
    }

    public IFactoryComponentDescriptor readFactoryComponent(String fcId_p) {
        IFactoryComponentDescriptor descriptor = null;
        Iterator<IFactoryComponentReader> readers = this._factoryComponentReaders.iterator();
        while (readers.hasNext() && descriptor == null) {
            IFactoryComponentReader reader = readers.next();
            descriptor = reader.readFactoryComponent(fcId_p);
        }
        return descriptor;
    }

    public IProductionPlanDescriptor readProductionPlan(final String productionPlanId_p, final String fcId_p) {
        ProductionPlanDescriptor descriptor = null;
        AbstractReadingCommand command = new AbstractReadingCommand(){

            public ITypedDescriptor execute(IFactoryComponentReader reader_p) {
                return reader_p.readProductionPlan(productionPlanId_p, fcId_p);
            }
        };
        descriptor = (ProductionPlanDescriptor)this.doRead(fcId_p, command, true);
        return descriptor;
    }

    public FactoryComponentInvocationDescriptor readFactoryComponentInvocation(final String factoryComponentInvocationId_p, final String fcId_p) {
        FactoryComponentInvocationDescriptor descriptor = null;
        AbstractReadingCommand command = new AbstractReadingCommand(){

            public ITypedDescriptor execute(IFactoryComponentReader reader_p) {
                return reader_p.readFactoryComponentInvocation(factoryComponentInvocationId_p, fcId_p);
            }
        };
        descriptor = (FactoryComponentInvocationDescriptor)this.doRead(fcId_p, command, true);
        return descriptor;
    }

    public ContractDescriptor readContract(final String contractId_p, final String fcId_p) {
        ContractDescriptor descriptor = null;
        AbstractReadingCommand command = new AbstractReadingCommand(){

            public ITypedDescriptor execute(IFactoryComponentReader reader_p) {
                return reader_p.readContract(contractId_p, fcId_p);
            }
        };
        descriptor = (ContractDescriptor)this.doRead(fcId_p, command, true);
        return descriptor;
    }

    public ContextDescriptor readContext(final String contextId_p, final String fcId_p) {
        ContextDescriptor descriptor = null;
        AbstractReadingCommand command = new AbstractReadingCommand(){

            public ITypedDescriptor execute(IFactoryComponentReader reader_p) {
                return reader_p.readContext(contextId_p, fcId_p);
            }
        };
        descriptor = (ContextDescriptor)this.doRead(fcId_p, command, true);
        return descriptor;
    }

    public TaskFactoryDescriptor readTaskFactory(final String taskFactoryId_p, final String fcId_p) {
        TaskFactoryDescriptor descriptor = null;
        AbstractReadingCommand command = new AbstractReadingCommand(){

            public ITypedDescriptor execute(IFactoryComponentReader reader_p) {
                return reader_p.readTaskFactory(taskFactoryId_p, fcId_p);
            }
        };
        descriptor = (TaskFactoryDescriptor)this.doRead(fcId_p, command, true);
        return descriptor;
    }

    public ContractElementReferenceDescriptor readContractElementReference(final String contractReferenceId_p, final String fcId_p) {
        ContractElementReferenceDescriptor descriptor = null;
        AbstractReadingCommand command = new AbstractReadingCommand(){

            public ITypedDescriptor execute(IFactoryComponentReader reader_p) {
                return reader_p.readContractElementReference(contractReferenceId_p, fcId_p);
            }
        };
        descriptor = (ContractElementReferenceDescriptor)this.doRead(fcId_p, command, true);
        return descriptor;
    }

    public IDescriptor readPatternLibraries(final String fcId_p) {
        IDescriptor descriptor = null;
        AbstractReadingCommand command = new AbstractReadingCommand(){

            public IDescriptor execute(IFactoryComponentReader reader_p) {
                return reader_p.readPatternLibraries(fcId_p);
            }
        };
        descriptor = this.doRead(fcId_p, command, false);
        return descriptor;
    }

    public IDescriptor readMappings(final String fcId_p) {
        IDescriptor descriptor = null;
        AbstractReadingCommand command = new AbstractReadingCommand(){

            public IDescriptor execute(IFactoryComponentReader reader_p) {
                return reader_p.readMappings(fcId_p);
            }
        };
        descriptor = this.doRead(fcId_p, command, true);
        return descriptor;
    }

    private IDescriptor doRead(String fcId_p, AbstractReadingCommand command_p, boolean usefactoryComponentReader_p) {
        IFactoryComponentReader retrievedfactoryComponentReader;
        IDescriptor descriptor = null;
        IFactoryComponentReader iFactoryComponentReader = retrievedfactoryComponentReader = usefactoryComponentReader_p ? this.getFactoryComponentReader(fcId_p) : null;
        if (retrievedfactoryComponentReader != null) {
            descriptor = command_p.execute(retrievedfactoryComponentReader);
        } else {
            Iterator<IFactoryComponentReader> readers = this._factoryComponentReaders.iterator();
            while (readers.hasNext() && descriptor == null) {
                IFactoryComponentReader reader = readers.next();
                descriptor = command_p.execute(reader);
            }
        }
        return descriptor;
    }

    abstract class AbstractReadingCommand {
        AbstractReadingCommand() {
        }

        public abstract IDescriptor execute(IFactoryComponentReader var1);
    }
}

