/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class FileHelper {
    private FileHelper() {
    }

    public static URL getFileFullUrl(String fileRelativePath_p) {
        return FileHelper.getFileFullUrl(FileHelper.getFileFullUri(fileRelativePath_p));
    }

    public static URL getFileFullUrl(URI fileFullUri_p) {
        URL result = null;
        try {
            result = FileLocator.resolve((URL)new URL(fileFullUri_p.toString()));
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("FileHelper.getFileFullPath(..) _ ");
            msg.append("Unable to resolve the url for ").append(fileFullUri_p.toString());
            EGFCommonPlugin.getDefault().logError(msg.toString(), e);
        }
        return result;
    }

    public static URI getFileFullUri(String fileRelativePath_p) {
        URI fileUri = null;
        if (fileRelativePath_p == null) {
            return fileUri;
        }
        Path path = new Path(fileRelativePath_p);
        IPluginModelBase modelBase = PluginRegistry.findModel((String)path.segment(0));
        IResource resource = modelBase != null ? modelBase.getUnderlyingResource() : null;
        fileUri = resource != null ? URI.createPlatformResourceURI((String)fileRelativePath_p, (boolean)true) : URI.createPlatformPluginURI((String)fileRelativePath_p, (boolean)true);
        return fileUri;
    }

    public static String convertPackageNameToFolderPath(String packageName_p) {
        return packageName_p != null ? packageName_p.replace('.', '/') : null;
    }

    public static byte[] readFile(InputStream inputStream_p) {
        byte[] data;
        block14: {
            data = null;
            try {
                try {
                    data = new byte[inputStream_p.available()];
                    inputStream_p.read(data);
                }
                catch (Exception e) {
                    StringBuilder msg = new StringBuilder("FileHelper.readFile(..) _ ");
                    msg.append("Failed to read the input stream ! ");
                    EGFCommonPlugin.getDefault().logError(msg.toString(), e);
                    if (inputStream_p != null) {
                        try {
                            inputStream_p.close();
                        }
                        catch (IOException ioe) {
                            StringBuilder msg2 = new StringBuilder("FileHelper.readFile(..) _ ");
                            msg2.append("Failed to close input stream ! ");
                            EGFCommonPlugin.getDefault().logError(msg2.toString(), ioe);
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (inputStream_p != null) {
                    try {
                        inputStream_p.close();
                    }
                    catch (IOException ioe) {
                        StringBuilder msg = new StringBuilder("FileHelper.readFile(..) _ ");
                        msg.append("Failed to close input stream ! ");
                        EGFCommonPlugin.getDefault().logError(msg.toString(), ioe);
                    }
                }
                throw throwable;
            }
            if (inputStream_p != null) {
                try {
                    inputStream_p.close();
                }
                catch (IOException ioe) {
                    StringBuilder msg = new StringBuilder("FileHelper.readFile(..) _ ");
                    msg.append("Failed to close input stream ! ");
                    EGFCommonPlugin.getDefault().logError(msg.toString(), ioe);
                }
            }
        }
        return data == null ? new byte[]{} : data;
    }

    public static String readFile(String filePath_p) {
        byte[] rawContent = FileHelper.readRawFile(filePath_p);
        return rawContent.length == 0 ? "" : new String(rawContent);
    }

    public static InputStream readFileAsStream(String filePath_p) {
        InputStream result = null;
        URL fileURL = FileHelper.getFileFullUrl(filePath_p);
        try {
            result = fileURL.openStream();
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("FileHelper.readFileAsStream(..) _ ");
            msg.append("Failed to load ").append(filePath_p);
            EGFCommonPlugin.getDefault().logError(msg.toString(), e);
        }
        return result;
    }

    public static byte[] readRawFile(String filePath_p) {
        byte[] result = null;
        InputStream inputStream = FileHelper.readFileAsStream(filePath_p);
        if (inputStream != null) {
            result = FileHelper.readFile(inputStream);
        }
        return result == null ? new byte[]{} : result;
    }

    public static void copyFile(String sourceFileRelativePath_p, String targetFileRelativePath_p) {
        FileHelper.writeFile(targetFileRelativePath_p, true, FileHelper.readRawFile(sourceFileRelativePath_p));
    }

    public static boolean writeFile(String filePath_p, boolean ensureFolders_p, String contents_p) {
        return FileHelper.writeFile(filePath_p, ensureFolders_p, contents_p.getBytes());
    }

    public static boolean writeFile(String filePath_p, boolean ensureFolders_p, byte[] contents_p) {
        AbstractInterruptibleChannel channel = null;
        try {
            try {
                String fileFullPath = FileHelper.getFileFullUrl(filePath_p).getFile();
                if (ensureFolders_p) {
                    FileHelper.ensurePathAvailability(fileFullPath);
                }
                channel = new FileOutputStream(fileFullPath).getChannel();
                ((FileChannel)channel).write(ByteBuffer.wrap(contents_p));
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder("FileHelper.writeFile(..) _ ");
                msg.append("Failed to open channel in write mode for ");
                msg.append(filePath_p).append(" !");
                EGFCommonPlugin.getDefault().logError(msg.toString(), e);
                if (channel != null && channel.isOpen()) {
                    try {
                        channel.close();
                    }
                    catch (IOException e2) {
                        StringBuilder msg2 = new StringBuilder("FileHelper.writeFile(..) _ ");
                        msg2.append("Failed to close opened channel in write mode ! ");
                        msg2.append(filePath_p).append(" may no longer be usable.");
                        EGFCommonPlugin.getDefault().logError(msg2.toString(), e2);
                    }
                }
                return false;
            }
        }
        finally {
            if (channel != null && channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    StringBuilder msg = new StringBuilder("FileHelper.writeFile(..) _ ");
                    msg.append("Failed to close opened channel in write mode ! ");
                    msg.append(filePath_p).append(" may no longer be usable.");
                    EGFCommonPlugin.getDefault().logError(msg.toString(), e);
                }
            }
        }
        return true;
    }

    public static boolean renameFile(String sourceFileRelativePath_p, String destinationFileRelativePath_p) {
        if (sourceFileRelativePath_p == null || destinationFileRelativePath_p == null) {
            return false;
        }
        IFile sourceFile = FileHelper.getPlatformFile(sourceFileRelativePath_p);
        IPath destinationPath = FileHelper.getPlatformFile(destinationFileRelativePath_p).getFullPath();
        return FileHelper.moveResource((IResource)sourceFile, destinationPath);
    }

    public static boolean renameFolder(String sourceFolderRelativePath_p, String destinationFolderRelativePath_p) {
        if (sourceFolderRelativePath_p == null || destinationFolderRelativePath_p == null) {
            return false;
        }
        IFolder sourceFolder = FileHelper.getPlatformFolder(sourceFolderRelativePath_p);
        IPath destinationPath = FileHelper.getPlatformFolder(destinationFolderRelativePath_p).getFullPath();
        return FileHelper.moveResource((IResource)sourceFolder, destinationPath);
    }

    public static boolean moveResource(IResource resource_p, IPath destinationPath_p) {
        boolean result = false;
        try {
            resource_p.move(destinationPath_p, true, (IProgressMonitor)new NullProgressMonitor());
            result = true;
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("FileHelper.moveResource(..) _ ");
            msg.append("Could not move ").append(resource_p.getFullPath());
            msg.append(" to ").append(destinationPath_p);
            EGFCommonPlugin.getDefault().logError(msg.toString(), e);
        }
        return result;
    }

    public static boolean exists(String fileRelativePath_p) {
        IFile file = FileHelper.getPlatformFile(fileRelativePath_p);
        return file != null ? file.exists() : false;
    }

    public static void ensurePathAvailability(String fileFullPath_p) {
        IPath parentFolderPath = new Path(fileFullPath_p).removeFileExtension().removeLastSegments(1);
        if (!parentFolderPath.isEmpty()) {
            File parentFolder = parentFolderPath.toFile();
            parentFolder.mkdirs();
        }
    }

    public static boolean deleteResource(IFolder root_p, IResource resource_p, boolean deleteParent_p) {
        if (resource_p == null) {
            return false;
        }
        if (!FileHelper.deleteResource(resource_p)) {
            return false;
        }
        if (root_p != null && deleteParent_p) {
            IContainer container = resource_p.getParent();
            while (!container.equals((Object)root_p)) {
                try {
                    IResource[] members = container.members();
                    if (members != null && members.length != 0 || !FileHelper.deleteResource((IResource)container)) break;
                    container = container.getParent();
                }
                catch (CoreException coreException) {
                    break;
                }
            }
        }
        return true;
    }

    public static boolean deleteFile(String fileRelativePath_p) {
        if (fileRelativePath_p == null || fileRelativePath_p.trim().length() == 0) {
            return false;
        }
        return FileHelper.deleteResource((IResource)FileHelper.getPlatformFile(fileRelativePath_p));
    }

    public static boolean deleteFolder(String folderRelativePath_p) {
        if (folderRelativePath_p == null || folderRelativePath_p.trim().length() == 0) {
            return false;
        }
        return FileHelper.deleteResource((IResource)FileHelper.getPlatformFolder(folderRelativePath_p));
    }

    public static boolean deleteResource(IResource resource_p) {
        if (resource_p == null || !resource_p.exists()) {
            return false;
        }
        try {
            resource_p.delete(true, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (CoreException ce) {
            StringBuilder msg = new StringBuilder("FileHelper.deleteFile(..) _ ");
            msg.append("Unable to delete file:").append(resource_p.getFullPath());
            EGFCommonPlugin.getDefault().logError(msg.toString(), ce);
            return false;
        }
    }

    public static IResource getPlatformResource(IPath path_p) {
        if (path_p == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().findMember(path_p);
    }

    public static IFile getPlatformFile(String fileRelativePath_p) {
        if (fileRelativePath_p == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileRelativePath_p));
    }

    public static IFolder getPlatformFolder(String folderRelativePath_p) {
        if (folderRelativePath_p == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(folderRelativePath_p));
    }

    public static String getFileExtension(String filePath_p) {
        if (filePath_p == null) {
            return null;
        }
        return new Path(filePath_p).getFileExtension();
    }
}

