/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.adapter.LiveValidationContentAdapter;
import org.eclipse.egf.pattern.ui.editors.selector.ParameterValidationDelegateClientSelector;
import org.eclipse.egf.pattern.ui.editors.selector.PatternValidationDelegateClientSelector;
import org.eclipse.egf.pattern.ui.editors.selector.VariableValidationDelegateClientSelector;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IMessageManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternUIHelper {
    public static List<String> getPatternParentMethodsNameList(Pattern pattern) {
        Pattern parent;
        ArrayList<String> parentMethods = new ArrayList<String>();
        Pattern pattern2 = parent = pattern == null ? null : pattern.getSuperPattern();
        if (parent != null) {
            for (PatternMethod patternMethod : parent.getMethods()) {
                String name = patternMethod.getName();
                parentMethods.add(name);
            }
        }
        return parentMethods;
    }

    public static List<PatternMethod> getAllUseablePatternMethods(Pattern pattern) {
        ArrayList<PatternMethod> parentMethods = new ArrayList<PatternMethod>();
        if (pattern != null) {
            for (PatternMethod patternMethod : pattern.getAllMethods()) {
                String name = patternMethod.getName();
                if (Messages.ImplementationPage_header.equals(name) || Messages.ImplementationPage_init.equals(name) || Messages.ImplementationPage_footer.equals(name)) continue;
                parentMethods.add(patternMethod);
            }
        }
        return parentMethods;
    }

    public static List<String> getUseablePatternMethodsNameList(Pattern pattern) {
        ArrayList<String> parentMethods = new ArrayList<String>();
        if (pattern != null) {
            for (PatternMethod patternMethod : pattern.getMethods()) {
                String name = patternMethod.getName();
                if (Messages.ImplementationPage_header.equals(name) || Messages.ImplementationPage_init.equals(name) || Messages.ImplementationPage_footer.equals(name)) continue;
                parentMethods.add(name);
            }
        }
        return parentMethods;
    }

    public static void addAdapter(Object object, AdapterImpl refresher) {
        if (object instanceof EObject) {
            EList eAdapters = ((EObject)object).eAdapters();
            PatternUIHelper.addIntoAdapters((EList<Adapter>)eAdapters, refresher);
            PatternUIHelper.addChildAdapter(object, refresher);
        }
    }

    public static void removeAdapter(Object object, AdapterImpl refresher) {
        if (object instanceof EObject) {
            EList eAdapters = ((EObject)object).eAdapters();
            PatternUIHelper.removeFromeAdapters((EList<Adapter>)eAdapters, refresher);
            PatternUIHelper.removeChildAdapter(object, refresher);
        }
    }

    public static void addChildAdapter(Object object, AdapterImpl refresher) {
        if (object instanceof MethodCall) {
            EList eAdapters = ((MethodCall)object).getCalled().eAdapters();
            PatternUIHelper.addIntoAdapters((EList<Adapter>)eAdapters, refresher);
        } else if (object instanceof PatternInjectedCall) {
            EList eAdapters = ((PatternInjectedCall)object).getContext().eAdapters();
            PatternUIHelper.addIntoAdapters((EList<Adapter>)eAdapters, refresher);
        }
    }

    public static void removeChildAdapter(Object object, AdapterImpl refresher) {
        if (object instanceof MethodCall) {
            EList eAdapters = ((MethodCall)object).getCalled().eAdapters();
            PatternUIHelper.removeFromeAdapters((EList<Adapter>)eAdapters, refresher);
        } else if (object instanceof PatternInjectedCall) {
            EList eAdapters = ((PatternInjectedCall)object).getContext().eAdapters();
            PatternUIHelper.removeFromeAdapters((EList<Adapter>)eAdapters, refresher);
        }
    }

    public static void addIntoAdapters(EList<Adapter> eAdapters, AdapterImpl refresher) {
        if (!eAdapters.contains((Object)refresher)) {
            eAdapters.add((Object)refresher);
        }
    }

    public static void removeFromeAdapters(EList<Adapter> eAdapters, AdapterImpl refresher) {
        if (eAdapters.contains((Object)refresher)) {
            eAdapters.remove((Object)refresher);
        }
    }

    public static void addAdapterForPattern(Pattern pattern, AdapterImpl liveValidationContentAdapter) {
        if (pattern != null) {
            EList eAdapters = pattern.eAdapters();
            PatternUIHelper.addIntoAdapters((EList<Adapter>)eAdapters, liveValidationContentAdapter);
        }
    }

    public static void removeAdapterForPattern(Pattern pattern, AdapterImpl adapter) {
        if (pattern != null) {
            EList eAdapters = pattern.eAdapters();
            PatternUIHelper.removeFromeAdapters((EList<Adapter>)eAdapters, adapter);
        }
    }

    public static void validationContent(IMessageManager mmng, EObject object, String key, Control control) {
        if (Messages.PatternUIHelper_key_NonPatternEmptyName.equals(key)) {
            PatternValidationDelegateClientSelector.running = true;
        } else if (Messages.PatternUIHelper_key_NonPatternParameterEmptyName.equals(key)) {
            ParameterValidationDelegateClientSelector.running = true;
        } else if (Messages.PatternUIHelper_key_NonPatternVariableEmptyName.equals(key)) {
            VariableValidationDelegateClientSelector.running = true;
        }
        IBatchValidator validator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        validator.setIncludeLiveConstraints(true);
        IStatus status = validator.validate(object);
        if (control != null && !control.isDisposed()) {
            PatternUIHelper.setErrorMessage(status, mmng, key, control);
        }
        if (Messages.PatternUIHelper_key_NonPatternEmptyName.equals(key)) {
            PatternValidationDelegateClientSelector.running = false;
        } else if (Messages.PatternUIHelper_key_NonPatternParameterEmptyName.equals(key)) {
            ParameterValidationDelegateClientSelector.running = false;
        } else if (Messages.PatternUIHelper_key_NonPatternVariableEmptyName.equals(key)) {
            VariableValidationDelegateClientSelector.running = false;
        }
    }

    public static void setErrorMessage(IStatus status, IMessageManager mmng, String key, Control control) {
        if (!status.isOK()) {
            if (status.isMultiStatus()) {
                status = status.getChildren()[0];
            }
            if (status.getCode() == 1 && Messages.PatternUIHelper_key_NonPatternEmptyName.equals(key) || status.getCode() == 2 && Messages.PatternUIHelper_key_NonPatternParameterEmptyName.equals(key) || status.getCode() == 3 && Messages.PatternUIHelper_key_NonPatternVariableEmptyName.equals(key)) {
                mmng.addMessage((Object)key, status.getMessage(), null, 3, control);
            }
        } else {
            mmng.removeMessage((Object)key, control);
        }
    }

    public static LiveValidationContentAdapter addEMFValidation(IMessageManager mmng, Pattern pattern, String key, Control control, LiveValidationContentAdapter liveValidationContentAdapter) {
        PatternUIHelper.validationContent(mmng, (EObject)pattern, key, control);
        liveValidationContentAdapter = new LiveValidationContentAdapter(control, mmng, key, pattern);
        PatternUIHelper.addAdapterForPattern(pattern, (AdapterImpl)liveValidationContentAdapter);
        return liveValidationContentAdapter;
    }

    public static boolean isRenameDisable(PatternMethod element) {
        String name = element.getName();
        return Messages.ImplementationPage_header.equals(name) || Messages.ImplementationPage_init.equals(name) || Messages.ImplementationPage_footer.equals(name);
    }
}

