/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.utils.NsURIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelVisitor {
    private static final List<Object> EMPTY_LIST = new ArrayList<Object>();
    private final Map<String, List<Pattern>> type2patterns = new HashMap<String, List<Pattern>>(100);

    public ModelVisitor(Set<Pattern> result) throws PatternException {
        for (Pattern p : result) {
            EList parameters = p.getAllParameters();
            if (parameters.size() != 1) {
                throw new PatternException("The pattern needs exactly one parameter.");
            }
            this.registerPattern(p, (PatternParameter)parameters.get(0));
        }
    }

    private void registerPattern(Pattern p, PatternParameter patternParameter) {
        String type = patternParameter.getType();
        List<Pattern> patterns = this.type2patterns.get(type);
        if (patterns == null) {
            patterns = new ArrayList<Pattern>();
            this.type2patterns.put(type, patterns);
        }
        patterns.add(p);
    }

    public void visit(PatternContext context, List<?> model) throws ExtensionHelper.MissingExtensionException, PatternException {
        for (Object obj : model) {
            if (!this.process(context, obj)) continue;
            this.visit(context, obj);
        }
    }

    public void visit(PatternContext context, Object model) throws ExtensionHelper.MissingExtensionException, PatternException {
        this.visit(context, this.getChildren(model));
    }

    protected boolean process(PatternContext context, Object model) throws ExtensionHelper.MissingExtensionException, PatternException {
        List<Pattern> foundPattern = this.findPatterns(model);
        if (foundPattern == null || foundPattern.isEmpty()) {
            return true;
        }
        return this.executeWithInjection(foundPattern, context, model);
    }

    protected List<Pattern> findPatterns(Object model) {
        List<Pattern> result = null;
        if (!(model instanceof EObject)) {
            throw new UnsupportedOperationException();
        }
        String fullName = NsURIHelper.getFullName((EObject)model);
        result = this.type2patterns.get(fullName);
        return result;
    }

    protected boolean executeWithInjection(Collection<Pattern> patterns, PatternContext context, Object ... parameters) throws ExtensionHelper.MissingExtensionException, PatternException {
        for (Pattern pattern : patterns) {
            PatternExtension extension = ExtensionHelper.getExtension(pattern.getNature());
            String canExecute = extension.canExecute(pattern);
            if (canExecute != null) {
                throw new PatternException(canExecute);
            }
            extension.createEngine(pattern).executeWithInjection(context, parameters);
        }
        return true;
    }

    public List<?> getChildren(Object model) {
        if (model instanceof EObject) {
            return ((EObject)model).eContents();
        }
        return EMPTY_LIST;
    }
}

