/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.contributors;

import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.PatternEditor;
import org.eclipse.egf.pattern.ui.editors.PatternEditorInput;
import org.eclipse.egf.pattern.ui.editors.templateEditor.AbstractTemplateEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class EditHelper {
    public static final String PATTERN_EDITOR_ID = "PatternEditor";
    public static final String TEMPLATE_EDITOR_ID = "TemplateEditor";

    public static void openPatternEditor(IWorkbenchPage page, String patternId) {
        Pattern pattern = PatternHelper.TRANSACTIONNAL_COLLECTOR.getPattern(patternId);
        if (pattern == null) {
            MessageDialog.openInformation((Shell)page.getWorkbenchWindow().getShell(), (String)Messages.ViewpointContributor_missingPattern_title, (String)Messages.ViewpointContributor_missingPattern_message);
        } else if (!EditHelper.isDuplicateEditor(page, pattern, PATTERN_EDITOR_ID)) {
            PatternEditor.openEditor(page, pattern);
        }
    }

    public static void openTemplateEditor(IWorkbenchPage page, Pattern pattern, String editor) {
        PatternEditorInput input = new PatternEditorInput(pattern.eResource(), pattern.getID());
        if (!EditHelper.isDuplicateEditor(page, pattern, TEMPLATE_EDITOR_ID)) {
            try {
                IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)editor);
            }
            catch (PartInitException e) {
                Activator.getDefault().logError(e);
            }
        }
    }

    public static boolean isDuplicateEditor(IWorkbenchPage page, Pattern pattern, String editorId) {
        IEditorPart[] editors;
        IEditorPart[] iEditorPartArray = editors = page.getEditors();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            PatternEditorInput editorInput;
            Pattern currentPattern;
            IEditorPart editor = iEditorPartArray[n2];
            if ((editor instanceof PatternEditor && PATTERN_EDITOR_ID.equals(editorId) || editor instanceof AbstractTemplateEditor && TEMPLATE_EDITOR_ID.equals(editorId)) && pattern.equals(currentPattern = (editorInput = (PatternEditorInput)editor.getEditorInput()).getPattern())) {
                page.activate((IWorkbenchPart)editor);
                return true;
            }
            ++n2;
        }
        return false;
    }
}

