/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.wizards.pages;

import java.util.ArrayList;
import org.eclipse.egf.pattern.ecore.EPackageHelper;
import org.eclipse.egf.pattern.ui.ImageShop;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.dialogs.EcoreModelSelectionDialog;
import org.eclipse.egf.pattern.ui.editors.dialogs.JavaTypeSelectionDialog;
import org.eclipse.egf.pattern.ui.editors.providers.EcoreContentProvider;
import org.eclipse.egf.pattern.ui.editors.providers.EcoreLabelProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class ChooseTypePage
extends WizardPage {
    private String chooseType;
    private JavaTypeSelectionDialog dialog;
    private TabFolder tabFolder;
    private TransactionalEditingDomain editingDomain;
    private TreeViewer ecoreTypeTreeViewer;
    private String type;
    private static final String PARAMETER_TYPE_DEFAULT_VALUE = "http://www.eclipse.org/emf/2002/Ecore";

    public ChooseTypePage(ISelection selection, TransactionalEditingDomain editingDomain, String type) {
        super(Messages.ChooseTypePage_title);
        this.setTitle(Messages.ChooseTypePage_title);
        this.setDescription(Messages.ChooseTypePage_description);
        this.editingDomain = editingDomain;
        this.type = type;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.createTabFolder(container);
        this.setControl((Control)container);
        this.initContent();
    }

    private void initContent() {
        int index;
        String nsURI = !"".equals(this.type) && this.type != null ? ((index = this.type.indexOf("#//")) != -1 ? this.type.substring(0, index) : PARAMETER_TYPE_DEFAULT_VALUE) : PARAMETER_TYPE_DEFAULT_VALUE;
        EPackage ePackage = EPackageHelper.REGISTRY.getEPackage(nsURI);
        if (ePackage != null) {
            this.ecoreTypeTreeViewer.setInput((Object)ePackage.eResource().getContents());
            this.ecoreTypeTreeViewer.expandToLevel(2);
        }
    }

    private void createTabFolder(Composite container) {
        this.tabFolder = new TabFolder(container, 0);
        GridData gd = new GridData(1808);
        this.tabFolder.setLayoutData((Object)gd);
        TabItem coreTypeTabItem = new TabItem(this.tabFolder, 0);
        coreTypeTabItem.setText(Messages.ChooseTypePage_coreTypeTabItem_title);
        coreTypeTabItem.setImage(ImageShop.get("/icons/category_obj.gif"));
        Composite compositeCoreType = new Composite((Composite)this.tabFolder, 0);
        this.createEcoreType(compositeCoreType);
        coreTypeTabItem.setControl((Control)compositeCoreType);
        TabItem javaTypeTabItem = new TabItem(this.tabFolder, 0);
        javaTypeTabItem.setText(Messages.ChooseTypePage_javaTypeTabItem_title);
        javaTypeTabItem.setImage(ImageShop.get("/icons/class_obj.gif"));
        Composite compositeJavaType = new Composite((Composite)this.tabFolder, 0);
        this.dialog = new JavaTypeSelectionDialog(compositeJavaType.getShell(), this.getWizard());
        compositeJavaType.setLayout((Layout)new GridLayout());
        this.dialog.createPage(compositeJavaType);
        compositeJavaType.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ChooseTypePage.this.dialog.close();
            }
        });
        javaTypeTabItem.setControl((Control)compositeJavaType);
    }

    private void createEcoreType(final Composite compositeEcoreType) {
        GridLayout layout = new GridLayout();
        compositeEcoreType.setLayout((Layout)layout);
        Composite container = new Composite(compositeEcoreType, 0);
        layout = new GridLayout();
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Tree tree = new Tree(container, 2816);
        gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 11;
        tree.setLayoutData((Object)gd);
        TreeColumn treeColumn = new TreeColumn(tree, 0);
        treeColumn.setWidth(500);
        this.ecoreTypeTreeViewer = new TreeViewer(tree);
        this.ecoreTypeTreeViewer.setLabelProvider((IBaseLabelProvider)new EcoreLabelProvider());
        this.ecoreTypeTreeViewer.setComparator(new ViewerComparator());
        this.ecoreTypeTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof EClass || element instanceof EPackage;
            }
        });
        this.ecoreTypeTreeViewer.setContentProvider((IContentProvider)new EcoreContentProvider());
        this.ecoreTypeTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChooseTypePage.this.selectType();
            }
        });
        this.ecoreTypeTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IWizard wizard = ChooseTypePage.this.getWizard();
                wizard.performFinish();
                IWizardContainer wizardContainer = wizard.getContainer();
                if (wizardContainer instanceof WizardDialog) {
                    ((WizardDialog)wizardContainer).close();
                }
            }
        });
        Button button = new Button(compositeEcoreType, 8);
        button.setText(Messages.ChooseTypePage_choose_model_button_title);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ChooseTypePage.this.selectType();
                EcoreModelSelectionDialog chooseModelDialog = new EcoreModelSelectionDialog(compositeEcoreType.getShell(), (EditingDomain)ChooseTypePage.this.editingDomain);
                if (chooseModelDialog.open() == 0) {
                    String returnUri = chooseModelDialog.getURIText();
                    ChooseTypePage.this.searchTypeModel(returnUri);
                    ChooseTypePage.this.ecoreTypeTreeViewer.expandToLevel(2);
                }
            }
        });
    }

    private void selectType() {
        ISelection selection = this.ecoreTypeTreeViewer.getSelection();
        Object selectItem = ((IStructuredSelection)selection).getFirstElement();
        String nsURI = "";
        String typeName = "";
        if (selectItem instanceof EPackage) {
            nsURI = ((EPackage)selectItem).getNsURI();
            typeName = ((EPackage)selectItem).eClass().getName();
        } else if (selectItem instanceof EClassifier) {
            EClassifier selectItem2 = (EClassifier)selectItem;
            nsURI = this.getEPackageNsURI((EObject)selectItem2);
            typeName = selectItem2.getName();
        }
        if (!"".equals(nsURI) || !"".equals(typeName)) {
            this.chooseType = String.valueOf(nsURI) + "#//" + typeName;
        }
    }

    private String getEPackageNsURI(EObject eObject) {
        EObject eContainer = eObject.eContainer();
        if (eContainer instanceof EPackage) {
            String nsURI = ((EPackage)eContainer).getNsURI();
            return nsURI;
        }
        return this.getEPackageNsURI(eContainer);
    }

    protected void searchTypeModel(String returnUri) {
        String[] uris = returnUri.split("  ");
        ArrayList resources = new ArrayList();
        String[] stringArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource;
            String uri = stringArray[n2];
            int indexOf = uri.toLowerCase().indexOf(Messages.ChooseTypePage_ecore_file);
            if (indexOf != -1 && (resource = this.editingDomain.loadResource(uri)) != null) {
                resources.addAll(resource.getContents());
            }
            ++n2;
        }
        this.ecoreTypeTreeViewer.setInput(resources);
    }

    public static String getType(String type) {
        if (type == null || type.length() == 0) {
            return "";
        }
        int index = type.lastIndexOf(".");
        if (index != -1) {
            return type.substring(index + 1);
        }
        return type;
    }

    public String getType() {
        return this.chooseType;
    }

    public JavaTypeSelectionDialog getJavaTypePage() {
        return this.dialog;
    }

    public boolean isInCoreTab() {
        return this.tabFolder.getSelectionIndex() == 0;
    }
}

