/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.egf.model.fcore.util.FcoreResourceImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcoreDragAndDropCommand
extends DragAndDropCommand {
    public static Command create(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        return domain.createCommand(FcoreDragAndDropCommand.class, new CommandParameter(owner, (Object)new DragAndDropCommand.Detail(location, operations, operation), collection));
    }

    public FcoreDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        this(domain, owner, location, operations, operation, collection, domain == null ? false : domain.getOptimizeCopy());
    }

    public FcoreDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection, boolean optimize) {
        super(domain, owner, location, operations, operation, collection);
    }

    protected boolean prepareDropMoveInsert(Object parent, Collection<?> children, int index) {
        if (this.collection.contains(this.owner)) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else if (children.containsAll(this.collection)) {
            this.dragCommand = IdentityCommand.INSTANCE;
            CompoundCommand compoundCommand = new CompoundCommand();
            ArrayList before = new ArrayList();
            ArrayList after = new ArrayList();
            int j = 0;
            for (Object object : children) {
                if (this.collection.contains(object)) {
                    if (j < index) {
                        before.add(object);
                    } else if (j > index) {
                        after.add(object);
                    }
                }
                ++j;
            }
            for (Object object : before) {
                compoundCommand.append(MoveCommand.create((EditingDomain)this.domain, (Object)parent, null, object, (int)(index - 1)));
            }
            ListIterator objects = after.listIterator(after.size());
            while (objects.hasPrevious()) {
                Object object = objects.previous();
                compoundCommand.append(MoveCommand.create((EditingDomain)this.domain, (Object)parent, null, object, (int)index));
            }
            this.dropCommand = compoundCommand.getCommandList().size() == 0 ? IdentityCommand.INSTANCE : compoundCommand;
        } else if (this.isCrossDomain()) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else {
            this.dropCommand = parent instanceof FcoreResourceImpl ? AddCommand.create((EditingDomain)this.domain, (Object)parent, null, (Collection)this.collection, (int)index) : AddCommand.create((EditingDomain)this.domain, (Object)parent, null, (Collection)CopyCommand.create((EditingDomain)this.domain, (Collection)this.collection).getResult(), (int)index);
            if (this.analyzeForNonContainment(this.dropCommand)) {
                this.dropCommand.dispose();
                this.dropCommand = UnexecutableCommand.INSTANCE;
                this.dragCommand = IdentityCommand.INSTANCE;
            } else {
                this.dragCommand = parent instanceof FcoreResourceImpl ? RemoveCommand.create((EditingDomain)this.domain, (Collection)this.collection) : IdentityCommand.INSTANCE;
            }
        }
        boolean result = this.dragCommand.canExecute() && this.dropCommand.canExecute();
        return result;
    }

    protected boolean prepareDropMoveOn() {
        if (this.isCrossDomain()) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else {
            this.dropCommand = this.owner instanceof FcoreResourceImpl ? AddCommand.create((EditingDomain)this.domain, (Object)this.owner, null, (Collection)this.collection) : AddCommand.create((EditingDomain)this.domain, (Object)this.owner, null, (Collection)CopyCommand.create((EditingDomain)this.domain, (Collection)this.collection).getResult());
            if (this.analyzeForNonContainment(this.dropCommand)) {
                this.dropCommand.dispose();
                this.dropCommand = UnexecutableCommand.INSTANCE;
                this.dragCommand = IdentityCommand.INSTANCE;
            } else {
                this.dragCommand = this.owner instanceof FcoreResourceImpl ? RemoveCommand.create((EditingDomain)this.domain, (Collection)this.collection) : IdentityCommand.INSTANCE;
            }
        }
        boolean result = this.dragCommand.canExecute() && this.dropCommand.canExecute();
        return result;
    }
}

