/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.egf.model.pattern.Call;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternFactory;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.CallTypeEnum;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.ChooseCallPage;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.ChooseKindPage;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.ChooseMethodCallPage;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.ParameterMatchingPage;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestrationWizard
extends Wizard
implements INewWizard {
    private ChooseKindPage chooseKindPage;
    private ChooseCallPage chooseCallPage;
    private ChooseMethodCallPage chooseMethodCallPage;
    private ParameterMatchingPage parameterMatchingPage;
    private ISelection selection;
    private Pattern pattern;
    private Call selectCall;
    private List<MethodCall> chooseMethodCallList;
    private CallTypeEnum defaultKind;
    private Object eidtItem;
    private TransactionalEditingDomain transactionalEditingDomain;

    public OrchestrationWizard(Pattern pattern, CallTypeEnum defaultKind, Object eidtItem, TransactionalEditingDomain transactionalEditingDomain) {
        this.setNeedsProgressMonitor(true);
        this.pattern = pattern;
        this.defaultKind = defaultKind;
        this.eidtItem = eidtItem;
        this.transactionalEditingDomain = transactionalEditingDomain;
    }

    public boolean canFinish() {
        if (this.chooseKindPage != null && (this.chooseKindPage.getKind() == CallTypeEnum.BACK_CALL || this.chooseKindPage.getKind() == CallTypeEnum.SUPERPATTERN_CALL)) {
            return true;
        }
        if (this.chooseKindPage != null && this.chooseKindPage.getKind() == CallTypeEnum.METHOD_CALL && this.defaultKind == CallTypeEnum.Add) {
            return this.chooseMethodCallPage.canFinish();
        }
        return this.chooseCallPage.canFinish();
    }

    public void addPages() {
        this.setWindowTitle(Messages.OrchestrationWizard_title);
        if (this.defaultKind.equals((Object)CallTypeEnum.Add)) {
            this.chooseKindPage = new ChooseKindPage(this.selection);
            this.addPage((IWizardPage)this.chooseKindPage);
        }
        this.chooseCallPage = new ChooseCallPage(this.pattern, this.selection, this.eidtItem);
        this.addPage((IWizardPage)this.chooseCallPage);
        this.chooseMethodCallPage = new ChooseMethodCallPage(this.pattern, this.selection, this.eidtItem);
        this.addPage((IWizardPage)this.chooseMethodCallPage);
        if (this.defaultKind.equals((Object)CallTypeEnum.PATTERN_CALL) || this.defaultKind.equals((Object)CallTypeEnum.Add)) {
            this.parameterMatchingPage = new ParameterMatchingPage(this.selection, this.pattern, this.transactionalEditingDomain);
            Pattern patternCallee = null;
            if (this.eidtItem instanceof PatternCall) {
                patternCallee = ((PatternCall)this.eidtItem).getCalled();
            }
            this.parameterMatchingPage.setPatternCallee(patternCallee);
            this.addPage((IWizardPage)this.parameterMatchingPage);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        WizardPage nextPage;
        if (page instanceof ChooseKindPage) {
            CallTypeEnum kind = ((ChooseKindPage)page).getKind();
            if (kind == CallTypeEnum.METHOD_CALL && this.defaultKind.equals((Object)CallTypeEnum.Add)) {
                nextPage = this.chooseMethodCallPage;
            } else {
                if (this.chooseKindPage.getKind() == CallTypeEnum.BACK_CALL || this.chooseKindPage.getKind() == CallTypeEnum.SUPERPATTERN_CALL) {
                    return null;
                }
                nextPage = this.chooseCallPage;
            }
        } else {
            nextPage = this.parameterMatchingPage;
        }
        return nextPage;
    }

    public boolean performFinish() {
        if (this.chooseKindPage != null && this.chooseKindPage.getKind() == CallTypeEnum.BACK_CALL) {
            this.selectCall = PatternFactory.eINSTANCE.createBackCall();
        } else if (this.chooseKindPage != null && this.chooseKindPage.getKind() == CallTypeEnum.SUPERPATTERN_CALL) {
            this.selectCall = PatternFactory.eINSTANCE.createSuperCall();
        } else if (this.chooseKindPage != null && this.chooseKindPage.getKind() == CallTypeEnum.METHOD_CALL) {
            this.chooseMethodCallList = this.chooseMethodCallPage.getChooseMethodCallList();
            this.selectCall = this.chooseMethodCallPage.getChooseCall();
        } else {
            this.selectCall = this.chooseCallPage.getChooseCall();
        }
        return true;
    }

    public boolean performCancel() {
        List<RecordingCommand> parameterMatchingCommands;
        if (this.parameterMatchingPage != null && this.eidtItem != null && (parameterMatchingCommands = this.parameterMatchingPage.getParameterMatchingCommands()) != null) {
            Iterator<RecordingCommand> iterator = parameterMatchingCommands.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                if (!this.transactionalEditingDomain.getCommandStack().canUndo()) continue;
                this.transactionalEditingDomain.getCommandStack().undo();
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public Call getSelectCall() {
        return this.selectCall;
    }

    public List<MethodCall> getSelectMethodCallList() {
        return this.chooseMethodCallList;
    }

    public CallTypeEnum getDefaultKind() {
        return this.defaultKind;
    }
}

