/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.networksimplex;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.elk.alg.layered.networksimplex.NEdge;
import org.eclipse.elk.alg.layered.networksimplex.NNode;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class NGraph {
    public List<NNode> nodes = Lists.newArrayList();

    public void writeDebugGraph(String filePath) {
        ElkNode elkGraph = ElkGraphUtil.createGraph();
        elkGraph.setProperty(LayeredOptions.DIRECTION, (Object)Direction.DOWN);
        HashMap nodeMap = Maps.newHashMap();
        for (NNode nNode : this.nodes) {
            ElkNode elkNode = ElkGraphUtil.createNode((ElkNode)elkGraph);
            nodeMap.put(nNode, elkNode);
            ElkGraphUtil.createLabel((String)(String.valueOf(nNode.type) + " " + nNode.layer), (ElkGraphElement)elkNode);
        }
        for (NNode nNode : this.nodes) {
            for (NEdge nEdge : nNode.getOutgoingEdges()) {
                ElkEdge elkEdge = ElkGraphUtil.createSimpleEdge((ElkConnectableShape)((ElkConnectableShape)nodeMap.get(nEdge.source)), (ElkConnectableShape)((ElkConnectableShape)nodeMap.get(nEdge.target)));
                ElkGraphUtil.createLabel((String)(String.valueOf(nEdge.weight) + " " + nEdge.delta), (ElkGraphElement)elkEdge);
            }
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createFileURI((String)filePath));
        r.getContents().add((Object)elkGraph);
        try {
            r.save(Collections.emptyMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean isAcyclic() {
        id = 0;
        for (NNode n : this.nodes) {
            n.id = id++;
        }
        incident = new int[this.nodes.size()];
        layer = new int[this.nodes.size()];
        for (NNode node : this.nodes) {
            v0 = node.id;
            incident[v0] = incident[v0] + node.getIncomingEdges().size();
        }
        roots = Lists.newLinkedList();
        for (NNode node : this.nodes) {
            if (!node.getIncomingEdges().isEmpty()) continue;
            roots.add(node);
        }
        if (!roots.isEmpty() || this.nodes.isEmpty()) ** GOTO lbl29
        return false;
lbl-1000:
        // 1 sources

        {
            node = (NNode)roots.poll();
            for (NEdge edge : node.getOutgoingEdges()) {
                target = edge.getTarget();
                layer[target.id] = Math.max(layer[target.id], layer[node.id] + 1);
                v1 = target.id;
                incident[v1] = incident[v1] - 1;
                if (incident[target.id] != 0) continue;
                roots.add(target);
            }
lbl29:
            // 2 sources

            ** while (!roots.isEmpty())
        }
lbl30:
        // 2 sources

        for (NNode node : this.nodes) {
            for (NEdge edge : node.getOutgoingEdges()) {
                if (layer[edge.target.id] > layer[edge.source.id]) continue;
                return false;
            }
        }
        return true;
    }
}

