/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.elk.core.comments.CommentAttacher;
import org.eclipse.elk.core.comments.DistanceHeuristic;
import org.eclipse.elk.core.comments.IBoundsProvider;
import org.eclipse.elk.core.comments.IHeuristic;
import org.eclipse.elk.core.comments.ShapeLayoutBoundsProvider;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;

public class NodeReferenceHeuristic
implements IHeuristic {
    private Function<ElkNode, String> commentTextFunction = null;
    private Function<ElkNode, String> nodeNameFunction = null;
    private IBoundsProvider boundsProvider = new ShapeLayoutBoundsProvider();
    private double maxDistance = -1.0;
    private boolean fuzzy = false;
    private Map<ElkNode, ElkNode> foundAttachments = Maps.newHashMap();

    public NodeReferenceHeuristic withCommentTextProvider(Function<ElkNode, String> f) {
        if (f == null) {
            throw new IllegalArgumentException("Comment text function cannot be null.");
        }
        this.commentTextFunction = f;
        return this;
    }

    public NodeReferenceHeuristic withNodeNameProvider(Function<ElkNode, String> f) {
        if (f == null) {
            throw new IllegalArgumentException("Node name function cannot be null.");
        }
        this.nodeNameFunction = f;
        return this;
    }

    public NodeReferenceHeuristic withFuzzyMatching() {
        this.fuzzy = true;
        return this;
    }

    public NodeReferenceHeuristic withMaximumAttachmentDistance(double distance) {
        this.maxDistance = distance;
        return this;
    }

    public NodeReferenceHeuristic withBoundsProvider(IBoundsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Bounds provider must not be null.");
        }
        this.boundsProvider = provider;
        return this;
    }

    private void checkConfiguration() {
        if (this.commentTextFunction == null) {
            throw new IllegalStateException("A comment text function is required.");
        }
        if (this.nodeNameFunction == null) {
            throw new IllegalStateException("A node name function is required.");
        }
    }

    @Override
    public void preprocess(ElkNode graph, boolean includeHierarchy) {
        this.checkConfiguration();
        ArrayList commentTexts = Lists.newArrayList();
        ArrayList nodeNames = Lists.newArrayList();
        for (ElkNode node : graph.getChildren()) {
            if (CommentAttacher.isComment(node)) {
                String commentText = this.commentTextFunction.apply(node);
                if (Strings.isNullOrEmpty((String)commentText)) continue;
                commentTexts.add(Pair.of(node, commentText));
                continue;
            }
            String nodeName = this.nodeNameFunction.apply(node);
            if (!Strings.isNullOrEmpty((String)nodeName)) {
                nodeNames.add(Pair.of(node, nodeName));
            }
            if (!includeHierarchy || node.getChildren().isEmpty()) continue;
            this.preprocess(node, true);
        }
        this.goFindMatches(commentTexts, nodeNames);
        commentTexts = null;
    }

    @Override
    public void cleanup() {
        this.foundAttachments.clear();
    }

    @Override
    public double raw(ElkNode comment, ElkGraphElement element) {
        return this.foundAttachments.get(comment) == element ? 1 : 0;
    }

    @Override
    public double normalized(ElkNode comment, ElkGraphElement element) {
        return this.raw(comment, element);
    }

    private void goFindMatches(List<Pair<ElkNode, String>> commentTexts, List<Pair<ElkNode, String>> nodeNames) {
        ArrayList nodeRegexps = Lists.newArrayListWithCapacity((int)nodeNames.size());
        for (Pair<ElkNode, String> nodeNamePair : nodeNames) {
            Pattern regexp = this.fuzzy ? NodeReferenceHeuristic.fuzzyRegexpFor(nodeNamePair.getSecond()) : NodeReferenceHeuristic.strictRegexpFor(nodeNamePair.getSecond());
            nodeRegexps.add(Pair.of(nodeNamePair.getFirst(), regexp));
        }
        for (Pair<ElkNode, String> commentTextPair : commentTexts) {
            Rectangle2D.Double nodeBounds;
            ElkNode foundNode = null;
            for (Pair nodeRegexpPair : nodeRegexps) {
                Matcher matcher = ((Pattern)nodeRegexpPair.getSecond()).matcher(commentTextPair.getSecond());
                if (!matcher.find()) continue;
                if (foundNode == null) {
                    foundNode = (ElkNode)nodeRegexpPair.getFirst();
                    continue;
                }
                foundNode = null;
                break;
            }
            if (foundNode == null) continue;
            if (this.maxDistance < 0.0) {
                this.foundAttachments.put(commentTextPair.getFirst(), foundNode);
                continue;
            }
            Rectangle2D.Double commentBounds = this.boundsProvider.boundsFor(commentTextPair.getFirst());
            if (!(DistanceHeuristic.distance(commentBounds, nodeBounds = this.boundsProvider.boundsFor(foundNode)) <= this.maxDistance)) continue;
            this.foundAttachments.put(commentTextPair.getFirst(), foundNode);
        }
    }

    private static Pattern fuzzyRegexpFor(String nodeName) {
        String trimmedNodeName = nodeName.trim();
        StringBuffer regexp = new StringBuffer(nodeName.length() * 2);
        StringBuffer currentSegment = new StringBuffer(nodeName.length());
        int i = 0;
        while (i < trimmedNodeName.length()) {
            char currC = trimmedNodeName.charAt(i);
            if (Character.isUpperCase(currC)) {
                if (i > 0 && Character.isLowerCase(trimmedNodeName.charAt(i - 1))) {
                    regexp.append(Pattern.quote(currentSegment.toString()));
                    currentSegment = new StringBuffer(nodeName.length());
                    regexp.append("[\\h\\v]*");
                }
                currentSegment.append(currC);
            } else if (Character.isWhitespace(currC)) {
                if (i > 0 && !Character.isWhitespace(trimmedNodeName.charAt(i - 1))) {
                    regexp.append(Pattern.quote(currentSegment.toString()));
                    currentSegment = new StringBuffer(nodeName.length());
                    regexp.append("[\\h\\v]*");
                }
            } else {
                currentSegment.append(currC);
            }
            ++i;
        }
        regexp.append(Pattern.quote(currentSegment.toString()));
        return Pattern.compile("\\b" + regexp.toString() + "\\b", 34);
    }

    private static Pattern strictRegexpFor(String nodeName) {
        return Pattern.compile("\\b" + Pattern.quote(nodeName) + "\\b", 32);
    }

    public Map<ElkNode, ElkNode> getAttachments() {
        return this.foundAttachments;
    }
}

