/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.options;

import org.eclipse.elk.alg.rectpacking.RectPackingLayoutProvider;
import org.eclipse.elk.alg.rectpacking.options.RectPackingMetaDataProvider;
import org.eclipse.elk.alg.rectpacking.util.OptimizationGoal;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class RectPackingOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.rectpacking.rectPacking";
    private static final double ASPECT_RATIO_DEFAULT = 1.3;
    public static final IProperty<Double> ASPECT_RATIO = new Property(CoreOptions.ASPECT_RATIO, (Object)1.3);
    public static final IProperty<Boolean> EXPAND_NODES = CoreOptions.EXPAND_NODES;
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(15.0);
    public static final IProperty<ElkPadding> PADDING = new Property(CoreOptions.PADDING, (Object)PADDING_DEFAULT);
    private static final double SPACING_NODE_NODE_DEFAULT = 15.0;
    public static final IProperty<Double> SPACING_NODE_NODE = new Property(CoreOptions.SPACING_NODE_NODE, (Object)15.0);
    public static final IProperty<OptimizationGoal> OPTIMIZATION_GOAL = RectPackingMetaDataProvider.OPTIMIZATION_GOAL;
    public static final IProperty<Boolean> LAST_PLACE_SHIFT = RectPackingMetaDataProvider.LAST_PLACE_SHIFT;
    public static final IProperty<Boolean> ONLY_FIRST_ITERATION = RectPackingMetaDataProvider.ONLY_FIRST_ITERATION;
    public static final IProperty<Boolean> ROW_COMPACTION = RectPackingMetaDataProvider.ROW_COMPACTION;
    public static final IProperty<Boolean> EXPAND_TO_ASPECT_RATIO = RectPackingMetaDataProvider.EXPAND_TO_ASPECT_RATIO;
    public static final IProperty<Boolean> INTERACTIVE = CoreOptions.INTERACTIVE;
    public static final IProperty<Boolean> INTERACTIVE_LAYOUT = CoreOptions.INTERACTIVE_LAYOUT;
    public static final IProperty<Integer> DESIRED_POSITION = RectPackingMetaDataProvider.DESIRED_POSITION;
    public static final IProperty<Integer> CURRENT_POSITION = RectPackingMetaDataProvider.CURRENT_POSITION;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("Rectangle Packing").description("Algorithm for packing of unconnected boxes, i.e. graphs without edges. The given order of the boxes is always preserved and the main reading direction of the boxes is left to right. The algorithm is divided into two phases. One phase approximates the width in which the rectangles can be placed. The next phase places the rectangles in rows using the previously calculated width as bounding width and bundles rectangles with a similar height in blocks. A compaction step reduces the size of the drawing. Finally, the rectangles are expanded to fill their bounding box and eliminate empty unused spaces.").providerFactory((IFactory)new RectPackingFactory()).melkBundleName(null).definingBundleId("org.eclipse.elk.alg.rectpacking").create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.aspectRatio", (Object)1.3);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.expandNodes", EXPAND_NODES.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", (Object)PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", (Object)15.0);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.optimizationGoal", OPTIMIZATION_GOAL.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.lastPlaceShift", LAST_PLACE_SHIFT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.onlyFirstIteration", ONLY_FIRST_ITERATION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.rowCompaction", ROW_COMPACTION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.expandToAspectRatio", EXPAND_TO_ASPECT_RATIO.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.interactive", INTERACTIVE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.interactiveLayout", INTERACTIVE_LAYOUT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.desiredPosition", DESIRED_POSITION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.rectpacking.currentPosition", CURRENT_POSITION.getDefault());
    }

    public static class RectPackingFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            RectPackingLayoutProvider provider = new RectPackingLayoutProvider();
            provider.initialize("");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

