/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco.debug.views;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class DisCoGraphRenderingConfigurator {
    private final Color black;
    protected static final int NODE_FONT_SIZE = 9;
    protected static final int PORT_FONT_SIZE = 6;
    protected static final int EDGE_FONT_SIZE = 8;
    protected static final int MIN_FONT_HEIGHT = 3;
    protected Color nodeBorderColor;
    protected Color nodeFillColor;
    protected Font nodeLabelFont;
    protected Color portBorderColor;
    protected Color portFillColor;
    protected Font portLabelFont;
    protected Color edgeColor;
    protected Font edgeLabelFont;
    protected Color labelBorderColor;
    protected Color labelFillColor;
    protected Color labelTextColor;
    protected Color dcElementFillColor;
    protected Color dcElementExternalColor;
    protected Color dcElementExternalBorderTextColor;
    protected Color dcElementBorderTextColor;
    protected Color dcPolyominoFillColor;
    protected Color dcPolyominoCenterColor;
    protected Color dcPolyominoWeaklyBlockedFillColor;
    protected Color dcPolyominoWeaklyBlockedBorderTextColor;
    protected Color dcPolyominoBorderTextColor;
    private Display display;

    public DisCoGraphRenderingConfigurator(Display display) {
        this.display = display;
        this.black = new Color((Device)display, 0, 0, 0);
    }

    public final Display getDisplay() {
        return this.display;
    }

    public void initialize(double scale) {
        Color dcKGraphColor = new Color((Device)this.display, 0, 115, 127);
        int nodeFontSize = Math.max((int)Math.round(9.0 * scale), 2);
        this.nodeLabelFont = new Font((Device)this.display, "sans", nodeFontSize, 0);
        this.nodeBorderColor = dcKGraphColor;
        this.nodeFillColor = new Color((Device)this.display, 0, 204, 226);
        this.dcElementFillColor = new Color((Device)this.display, 178, 159, 18);
        this.dcElementExternalColor = new Color((Device)this.display, 179, 80, 18);
        this.dcElementBorderTextColor = new Color((Device)this.display, 127, 113, 13);
        this.dcElementExternalBorderTextColor = new Color((Device)this.display, 127, 57, 13);
        this.dcPolyominoFillColor = new Color((Device)this.display, 178, 9, 101);
        this.dcPolyominoCenterColor = this.black;
        this.dcPolyominoWeaklyBlockedFillColor = new Color((Device)this.display, 170, 9, 178);
        this.dcPolyominoBorderTextColor = new Color((Device)this.display, 127, 6, 72);
        this.dcPolyominoWeaklyBlockedBorderTextColor = new Color((Device)this.display, 121, 6, 128);
        int portFontSize = Math.max((int)Math.round(6.0 * scale), 2);
        this.portLabelFont = new Font((Device)this.display, "sans", portFontSize, 0);
        this.portBorderColor = dcKGraphColor;
        this.portFillColor = dcKGraphColor;
        int edgeFontSize = Math.max((int)Math.round(8.0 * scale), 2);
        this.edgeLabelFont = new Font((Device)this.display, "sans", edgeFontSize, 0);
        this.edgeColor = dcKGraphColor;
        this.labelBorderColor = dcKGraphColor;
        this.labelFillColor = null;
        this.labelTextColor = dcKGraphColor;
    }

    public final void dispose() {
        if (this.nodeBorderColor != null) {
            this.nodeBorderColor.dispose();
        }
        if (this.nodeFillColor != null) {
            this.nodeFillColor.dispose();
        }
        if (this.nodeLabelFont != null) {
            this.nodeLabelFont.dispose();
        }
        if (this.labelBorderColor != null) {
            this.labelBorderColor.dispose();
        }
        if (this.labelTextColor != null) {
            this.labelTextColor.dispose();
        }
        if (this.portBorderColor != null) {
            this.portBorderColor.dispose();
        }
        if (this.portFillColor != null) {
            this.portFillColor.dispose();
        }
        if (this.portLabelFont != null) {
            this.portLabelFont.dispose();
        }
        if (this.edgeColor != null) {
            this.edgeColor.dispose();
        }
        if (this.edgeLabelFont != null) {
            this.edgeLabelFont.dispose();
        }
        if (this.dcElementFillColor != null) {
            this.dcElementFillColor.dispose();
        }
        if (this.dcElementBorderTextColor != null) {
            this.dcElementBorderTextColor.dispose();
        }
        if (this.dcPolyominoFillColor != null) {
            this.dcPolyominoFillColor.dispose();
        }
        if (this.dcPolyominoBorderTextColor != null) {
            this.dcPolyominoBorderTextColor.dispose();
        }
    }

    public final Color getNodeBorderColor() {
        return this.nodeBorderColor;
    }

    public final Color getNodeFillColor() {
        return this.nodeFillColor;
    }

    public final Font getNodeLabelFont() {
        return this.nodeLabelFont;
    }

    public final Color getPortBorderColor() {
        return this.portBorderColor;
    }

    public final Color getPortFillColor() {
        return this.portFillColor;
    }

    public final Font getPortLabelFont() {
        return this.portLabelFont;
    }

    public final Color getEdgeColor() {
        return this.edgeColor;
    }

    public final Font getEdgeLabelFont() {
        return this.edgeLabelFont;
    }

    public final Color getLabelBorderColor() {
        return this.labelBorderColor;
    }

    public final Color getLabelFillColor() {
        return this.labelFillColor;
    }

    public final Color getLabelTextColor() {
        return this.labelTextColor;
    }

    public final Color getDCElementFillColor() {
        return this.dcElementFillColor;
    }

    public final Color getDCElementBorderTextColor() {
        return this.dcElementBorderTextColor;
    }

    public final Color getDCElementExternalFillColor() {
        return this.dcElementExternalColor;
    }

    public final Color getDCElementExternalBorderTextColor() {
        return this.dcElementExternalBorderTextColor;
    }

    public final Color getPolyominoFillColor() {
        return this.dcPolyominoFillColor;
    }

    public final Color getPolyominoCenterColor() {
        return this.dcPolyominoCenterColor;
    }

    public final Color getPolyominoBorderTextColor() {
        return this.dcPolyominoBorderTextColor;
    }

    public final Color getPolyominoWeaklyBlockedColor() {
        return this.dcPolyominoWeaklyBlockedFillColor;
    }

    public final Color getPolyominoWeaklyBlockedBorderTextColor() {
        return this.dcPolyominoWeaklyBlockedBorderTextColor;
    }

    public final Color getBlack() {
        return this.black;
    }
}

