/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.navigator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.dnd.ComposedDropAdapter;
import org.eclipse.emf.ecp.common.dnd.UCDragAdapter;
import org.eclipse.emf.ecp.common.model.ECPWorkspaceManager;
import org.eclipse.emf.ecp.common.model.NoWorkspaceException;
import org.eclipse.emf.ecp.common.model.workSpaceModel.ECPWorkspace;
import org.eclipse.emf.ecp.common.model.workSpaceModel.WorkSpaceModelPackage;
import org.eclipse.emf.ecp.navigator.Activator;
import org.eclipse.emf.ecp.navigator.TreeContentProvider;
import org.eclipse.emf.ecp.navigator.TreeLabelProvider;
import org.eclipse.emf.ecp.navigator.commands.AltKeyDoubleClickAction;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class TreeView
extends ViewPart
implements ISelectionListener {
    private static TreeViewer viewer;
    private MenuManager menuMgr;
    private boolean isLinkedWithEditor;
    private Action linkWithEditor;
    private PartListener partListener;
    private ECPWorkspace currentWorkspace;
    private AdapterImpl workspaceListenerAdapter;
    private boolean internalSelectionEvent;
    private TreeLabelProvider labelProvider;

    public TreeView() {
        try {
            this.currentWorkspace = ECPWorkspaceManager.getInstance().getWorkSpace();
        }
        catch (NoWorkspaceException e) {
            Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
            return;
        }
        this.workspaceListenerAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (!(msg.getFeatureID(ECPWorkspace.class) != 0 || msg.getEventType() == 3 && WorkSpaceModelPackage.eINSTANCE.getECPProject().isInstance(msg.getNewValue()) || msg.getEventType() != 4)) {
                    WorkSpaceModelPackage.eINSTANCE.getECPProject().isInstance(msg.getOldValue());
                }
            }
        };
        this.currentWorkspace.eAdapters().add((Object)this.workspaceListenerAdapter);
    }

    public void dispose() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removePartListener((IPartListener2)this.partListener);
        this.currentWorkspace.eAdapters().remove((Object)this.workspaceListenerAdapter);
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        viewer = new TreeViewer(parent, 2);
        try {
            ECPWorkspace workSpace = ECPWorkspaceManager.getInstance().getWorkSpace();
            IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
            this.labelProvider = new TreeLabelProvider();
            viewer.setLabelProvider(this.labelProvider.getLabelProvider());
            viewer.setContentProvider((IContentProvider)new TreeContentProvider());
            viewer.setUseHashlookup(true);
            viewer.setInput((Object)workSpace);
        }
        catch (NoWorkspaceException workSpace) {
            // empty catch block
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        this.partListener = new PartListener();
        this.menuMgr = new MenuManager();
        this.menuMgr.add((IContributionItem)new Separator("additions"));
        this.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)viewer);
        Control control = viewer.getControl();
        Menu menu = this.menuMgr.createContextMenu(control);
        control.setMenu(menu);
        this.createActions();
        new AltKeyDoubleClickAction((ColumnViewer)viewer, TreeView.class.getName());
        this.addDragNDropSupport();
        this.addSelectionListener();
        if (viewer.getTree().getItems().length > 0) {
            this.setActiveECPProject(viewer.getTree().getItem(0).getData());
            viewer.getTree().select(viewer.getTree().getItem(0));
        }
    }

    private void createActions() {
        this.isLinkedWithEditor = this.getDialogSettings().getBoolean("LinkWithEditor");
        if (this.isLinkedWithEditor) {
            this.getSite().getPage().addPartListener((IPartListener2)this.partListener);
        }
        this.linkWithEditor = new Action("Link with editor", 2){

            public void run() {
                if (TreeView.this.isLinkedWithEditor) {
                    TreeView.this.isLinkedWithEditor = false;
                    TreeView.this.getSite().getPage().removePartListener((IPartListener2)TreeView.this.partListener);
                } else {
                    TreeView.this.isLinkedWithEditor = true;
                    TreeView.this.getSite().getPage().addPartListener((IPartListener2)TreeView.this.partListener);
                    IEditorPart editor = TreeView.this.getSite().getPage().getActiveEditor();
                    if (editor != null) {
                        TreeView.this.editorActivated(editor);
                    }
                }
                TreeView.this.getDialogSettings().put("LinkWithEditor", this.isChecked());
            }
        };
        this.linkWithEditor.setImageDescriptor(Activator.getImageDescriptor("icons/link_with_editor.gif"));
        this.linkWithEditor.setToolTipText("Link with editor");
        this.linkWithEditor.setChecked(this.getDialogSettings().getBoolean("LinkWithEditor"));
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        Separator additionsSeperator = new Separator("additions");
        additionsSeperator.setVisible(true);
        toolBarManager.add((IContributionItem)additionsSeperator);
        toolBarManager.insertAfter("additions", (IAction)this.linkWithEditor);
    }

    private IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    public void editorActivated(IEditorPart editor) {
        Object adapter = editor.getEditorInput().getAdapter(EObject.class);
        if (adapter != null && adapter instanceof EObject) {
            EObject me = (EObject)adapter;
            this.revealME(me);
        }
    }

    private void revealME(EObject me) {
        if (me == null) {
            return;
        }
        if (TreeView.getTreeViewer().testFindItem((Object)me) == null) {
            TreeView.getTreeViewer().refresh();
        }
        TreeView.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)me), true);
    }

    private void addSelectionListener() {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object obj = selection.getFirstElement();
                    TreeView.this.setActiveECPProject(obj);
                    if (TreeView.this.isLinkedWithEditor && !TreeView.this.internalSelectionEvent) {
                        TreeView.this.linkWithEditor(obj);
                    }
                }
            }
        });
    }

    private void linkWithEditor(Object selectedME) {
        if (selectedME == null) {
            return;
        }
        if (!(selectedME instanceof EObject)) {
            return;
        }
        EObject me = (EObject)selectedME;
        if (!this.isEditorOpen(me)) {
            return;
        }
        this.activateEditor(me);
    }

    private void activateEditor(EObject selectedME) {
        IEditorReference[] iEditorReferenceArray = this.getSite().getPage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            Object editorInput = null;
            try {
                editorInput = editorRef.getEditorInput().getAdapter(EObject.class);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            if (selectedME.equals(editorInput)) {
                this.getSite().getPage().bringToTop(editorRef.getPart(true));
                return;
            }
            ++n2;
        }
    }

    private boolean isEditorOpen(EObject selectedME) {
        IEditorReference[] iEditorReferenceArray = this.getSite().getPage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            Object editorInput = null;
            try {
                editorInput = editorRef.getEditorInput().getAdapter(EObject.class);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            if (selectedME.equals(editorInput)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void setActiveECPProject(Object obj) {
        if (obj instanceof EObject) {
            try {
                ECPWorkspaceManager.getInstance().getWorkSpace().setActiveModelelement((EObject)obj);
            }
            catch (NoWorkspaceException e) {
                Activator.getDefault().logException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private void addDragNDropSupport() {
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new UCDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new ComposedDropAdapter((StructuredViewer)viewer));
    }

    public void setFocus() {
        viewer.getControl().setFocus();
        this.menuMgr.update();
    }

    public static TreeViewer getTreeViewer() {
        return viewer;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this) {
            return;
        }
        EObject element = this.extractObjectFromSelection(selection);
        if (element == null) {
            return;
        }
        this.revealME(element);
    }

    private EObject extractObjectFromSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.size() == 1) {
            Object node = structuredSelection.getFirstElement();
            if (node instanceof TreeNode) {
                Object element = ((TreeNode)node).getValue();
                if (element instanceof EObject) {
                    return (EObject)element;
                }
            } else if (node instanceof EObject) {
                return (EObject)node;
            }
        }
        return null;
    }

    private class PartListener
    implements IPartListener2 {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                TreeView.this.editorActivated(((IEditorReference)partRef).getEditor(true));
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                TreeView.this.editorActivated(((IEditorReference)partRef).getEditor(true));
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }
    }
}

