/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.emfstore.common.model.EMFStoreProperty;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.server.EmfStoreInterface;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.server.model.SessionId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.model.accesscontrol.OrgUnitProperty;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface EmfStore
extends EmfStoreInterface {
    public static final URI CHANGEPACKAGE_URI = URI.createURI((String)"emfstoreVirtualChangePackageUri");
    public static final URI PROJECT_URI = URI.createURI((String)"emfstoreVirtualProjectUri");

    public List<ProjectInfo> getProjectList(SessionId var1) throws EmfStoreException;

    public Project getProject(SessionId var1, ProjectId var2, VersionSpec var3) throws EmfStoreException;

    public PrimaryVersionSpec createVersion(SessionId var1, ProjectId var2, PrimaryVersionSpec var3, ChangePackage var4, LogMessage var5) throws EmfStoreException, InvalidVersionSpecException;

    public PrimaryVersionSpec resolveVersionSpec(SessionId var1, ProjectId var2, VersionSpec var3) throws EmfStoreException;

    public List<ChangePackage> getChanges(SessionId var1, ProjectId var2, VersionSpec var3, VersionSpec var4) throws EmfStoreException;

    public List<HistoryInfo> getHistoryInfo(SessionId var1, ProjectId var2, HistoryQuery var3) throws EmfStoreException;

    public void addTag(SessionId var1, ProjectId var2, PrimaryVersionSpec var3, TagVersionSpec var4) throws EmfStoreException;

    public void removeTag(SessionId var1, ProjectId var2, PrimaryVersionSpec var3, TagVersionSpec var4) throws EmfStoreException;

    public ProjectInfo createEmptyProject(SessionId var1, String var2, String var3, LogMessage var4) throws EmfStoreException;

    public ProjectInfo createProject(SessionId var1, String var2, String var3, LogMessage var4, Project var5) throws EmfStoreException;

    public void deleteProject(SessionId var1, ProjectId var2, boolean var3) throws EmfStoreException;

    public ACUser resolveUser(SessionId var1, ACOrgUnitId var2) throws EmfStoreException;

    public ProjectId importProjectHistoryToServer(SessionId var1, ProjectHistory var2) throws EmfStoreException;

    public ProjectHistory exportProjectHistoryFromServer(SessionId var1, ProjectId var2) throws EmfStoreException;

    public FileTransferInformation uploadFileChunk(SessionId var1, ProjectId var2, FileChunk var3) throws EmfStoreException;

    public FileChunk downloadFileChunk(SessionId var1, ProjectId var2, FileTransferInformation var3) throws EmfStoreException;

    public void transmitProperty(SessionId var1, OrgUnitProperty var2, ACUser var3, ProjectId var4) throws EmfStoreException;

    public List<EMFStoreProperty> setEMFProperties(SessionId var1, List<EMFStoreProperty> var2, ProjectId var3) throws EmfStoreException;

    public List<EMFStoreProperty> getEMFProperties(SessionId var1, ProjectId var2) throws EmfStoreException;
}

