/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.connection.xmlrpc;

import org.eclipse.emf.emfstore.server.EmfStore;
import org.eclipse.emf.emfstore.server.accesscontrol.AuthenticationControl;
import org.eclipse.emf.emfstore.server.connection.ConnectionHandler;
import org.eclipse.emf.emfstore.server.connection.xmlrpc.XmlRpcEmfStoreImpl;
import org.eclipse.emf.emfstore.server.connection.xmlrpc.XmlRpcWebserverManager;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcConnectionHandler
implements ConnectionHandler<EmfStore> {
    public static final String EMFSTORE = "EmfStore";
    private static final String NAME = "XML RPC Connection Handler";
    private static EmfStore emfStore;
    private static AuthenticationControl accessControl;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(EmfStore emfStore, AuthenticationControl accessControl) throws FatalEmfStoreException {
        XmlRpcConnectionHandler.emfStore = emfStore;
        XmlRpcConnectionHandler.accessControl = accessControl;
        XmlRpcWebserverManager webServer = XmlRpcWebserverManager.getInstance();
        webServer.initServer();
        webServer.addHandler(EMFSTORE, XmlRpcEmfStoreImpl.class);
    }

    public static EmfStore getEmfStore() {
        return emfStore;
    }

    public static AuthenticationControl getAccessControl() {
        return accessControl;
    }

    @Override
    public void stop(boolean force) {
        XmlRpcWebserverManager webserverManager = XmlRpcWebserverManager.getInstance();
        if (!webserverManager.removeHandler(EMFSTORE)) {
            webserverManager.stopServer();
        }
    }
}

