/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.filetransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.emf.emfstore.server.exceptions.FileTransferException;
import org.eclipse.emf.emfstore.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.server.filetransfer.FileTransferInformation;

public final class FilePartitionerUtil {
    private static final int CHUNK_SIZE = 100000;
    private static final String COULD_NOT_FIND_THE_FILE = "Could not find the file!";
    private static final String COULD_NOT_READ_THE_FILE = "Could not read the file!";

    private FilePartitionerUtil() {
    }

    public static synchronized void writeChunk(File file, FileChunk fileChunk) throws FileTransferException {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rws");
            randomAccessFile.skipBytes(fileChunk.getChunkNumber() * 100000);
            randomAccessFile.write(fileChunk.getData());
            randomAccessFile.close();
        }
        catch (FileNotFoundException e) {
            throw new FileTransferException(COULD_NOT_FIND_THE_FILE, e);
        }
        catch (IOException e) {
            throw new FileTransferException("Could not write to the file!", e);
        }
    }

    public static synchronized FileChunk readChunk(File file, FileTransferInformation fileInformation) throws FileTransferException {
        boolean end = false;
        try {
            byte[] data;
            FileInputStream fileInputStream = new FileInputStream(file);
            int absoluteSize = fileInputStream.available();
            fileInputStream.skip(fileInformation.getChunkNumber() * 100000);
            int remainingSize = fileInputStream.available();
            if (remainingSize <= 100000 && remainingSize >= 0) {
                end = true;
                data = new byte[remainingSize];
            } else {
                data = new byte[100000];
            }
            fileInputStream.read(data);
            fileInputStream.getChannel().close();
            fileInputStream.close();
            fileInformation.setFileSize(absoluteSize);
            return new FileChunk(fileInformation, end, data);
        }
        catch (IOException e) {
            throw new FileTransferException(COULD_NOT_READ_THE_FILE, e);
        }
    }

    public static int getNumberOfChunks(File file) throws FileTransferException {
        try {
            return (int)Math.ceil((float)new FileInputStream(file).available() / 100000.0f);
        }
        catch (FileNotFoundException e) {
            throw new FileTransferException(COULD_NOT_FIND_THE_FILE, e);
        }
        catch (IOException e) {
            throw new FileTransferException(COULD_NOT_READ_THE_FILE, e);
        }
    }

    public static int getFileSize(File file) throws FileTransferException {
        try {
            return new FileInputStream(file).available();
        }
        catch (FileNotFoundException e) {
            throw new FileTransferException(COULD_NOT_FIND_THE_FILE, e);
        }
        catch (IOException e) {
            throw new FileTransferException(COULD_NOT_READ_THE_FILE, e);
        }
    }

    public static int getChunkSize() {
        return 100000;
    }
}

