/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common.model.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.emf.emfstore.common.CommonUtil;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPoint;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPointException;
import org.eclipse.emf.emfstore.common.model.AssociationClassElement;
import org.eclipse.emf.emfstore.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.ModelFactory;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.SingletonIdResolver;
import org.eclipse.emf.emfstore.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.common.model.util.MalformedModelVersionException;
import org.eclipse.emf.emfstore.common.model.util.SerializationException;
import org.eclipse.emf.emfstore.common.model.util.SettingWithReferencedElement;
import org.osgi.framework.Bundle;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelUtil {
    private static final String ORG_ECLIPSE_EMF_EMFSTORE_COMMON_MODEL = "org.eclipse.emf.emfstore.common.model";
    public static final String BEGINTEXT_TOKEN = "%BEGINNTEXT%";
    public static final URI VIRTUAL_URI = URI.createURI((String)"virtualUri");
    private static Set<String> ignoredDataTypes;
    private static Set<SingletonIdResolver> singletonIdResolvers;
    private static HashMap<Object, Object> resourceLoadOptions;
    private static HashMap<Object, Object> resourceSaveOptions;

    private ModelUtil() {
    }

    public static ModelElementId createModelElementId(String id) {
        ModelElementId modelElementId = ModelFactory.eINSTANCE.createModelElementId();
        modelElementId.setId(id);
        return modelElementId;
    }

    public static boolean areEqual(EObject eobjectA, EObject eobjectB) {
        String stringB;
        String stringA;
        try {
            stringA = ModelUtil.eObjectToString(eobjectA);
            stringB = ModelUtil.eObjectToString(eobjectB);
        }
        catch (SerializationException e) {
            return false;
        }
        return stringA.equals(stringB);
    }

    public static String eObjectToString(EObject object) throws SerializationException {
        boolean containmentCheckEnabled = false;
        boolean hrefCheckEnabled = false;
        boolean proxyCheckEnabled = false;
        ExtensionElement element = new ExtensionPoint("org.eclipse.emf.emfstore.common.model.serializationoptions").getFirst();
        if (element != null) {
            hrefCheckEnabled = element.getBoolean("HrefCheck");
            proxyCheckEnabled = element.getBoolean("ProxyCheck");
            containmentCheckEnabled = element.getBoolean("SelfContainmentCheck");
        }
        return ModelUtil.eObjectToString(object, !containmentCheckEnabled, !hrefCheckEnabled, !proxyCheckEnabled);
    }

    public static String eObjectToString(EObject object, boolean overrideContainmentCheck, boolean overrideHrefCheck, boolean overrideProxyCheck) throws SerializationException {
        int step;
        EObject copy;
        if (object == null) {
            return null;
        }
        XMIResource res = (XMIResource)new ResourceSetImpl().createResource(VIRTUAL_URI);
        ((ResourceImpl)res).setIntrinsicIDToEObjectMap(new HashMap());
        if (object instanceof IdEObjectCollection) {
            copy = ModelUtil.copyIdEObjectCollection((IdEObjectCollection)object, res);
        } else {
            copy = ModelUtil.clone(object);
            res.getContents().add((Object)copy);
        }
        if (!(overrideContainmentCheck || copy instanceof EClass || CommonUtil.isSelfContained((EObject)copy) && CommonUtil.isContainedInResource((EObject)copy, (Resource)res))) {
            throw new SerializationException(copy);
        }
        int initialSize = step = 200;
        if (object instanceof Project) {
            Project project = (Project)object;
            initialSize = project.getAllModelElements().size() * step;
        }
        if (!overrideProxyCheck) {
            ModelUtil.proxyCheck((Resource)res);
        }
        StringWriter stringWriter = new StringWriter(initialSize);
        try {
            res.save((Writer)stringWriter, ModelUtil.getResourceSaveOptions());
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        String result = stringWriter.toString();
        if (!overrideHrefCheck) {
            ModelUtil.hrefCheck(result);
        }
        return result;
    }

    private static EObject copyIdEObjectCollection(IdEObjectCollection collection, XMIResource res) {
        IdEObjectCollection copiedCollection = ModelUtil.clone(collection);
        for (EObject modelElement : copiedCollection.getAllModelElements()) {
            if (ModelUtil.isIgnoredDatatype(modelElement)) continue;
            ModelElementId modelElementId = copiedCollection.getModelElementId(modelElement);
            res.setID(modelElement, modelElementId.getId());
        }
        res.getContents().add((Object)copiedCollection);
        return copiedCollection;
    }

    private static void proxyCheck(Resource resource) throws SerializationException {
        EcoreUtil.resolveAll((Resource)resource);
        TreeIterator contents = resource.getAllContents();
        while (contents.hasNext()) {
            EObject eObject = (EObject)contents.next();
            if (!eObject.eIsProxy()) continue;
            throw new SerializationException("Serialization failed due to unresolved proxy detection.");
        }
    }

    private static void hrefCheck(String result) throws SerializationException {
        char[] needle = "href".toCharArray();
        int pointer = 0;
        boolean insideQuotes = false;
        char[] cArray = result.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            if (character == '\"') {
                boolean bl = insideQuotes = !insideQuotes;
            }
            if (!insideQuotes && character == needle[pointer]) {
                if (++pointer == needle.length) {
                    throw new SerializationException("Serialization failed due to href detection.");
                }
            } else {
                pointer = 0;
            }
            ++n2;
        }
    }

    public static boolean isIgnoredDatatype(EObject eObject) {
        if (ignoredDataTypes == null) {
            ignoredDataTypes = new HashSet<String>();
            for (ExtensionElement element : new ExtensionPoint("org.eclipse.emf.emfstore.common.model.ignoredatatype", true).getExtensionElements()) {
                try {
                    ignoredDataTypes.add(element.getAttribute("type"));
                }
                catch (ExtensionPointException extensionPointException) {
                    // empty catch block
                }
            }
        }
        return ignoredDataTypes.contains(eObject.eClass().getInstanceClassName());
    }

    public static EObject stringToEObject(String object) throws SerializationException {
        if (object == null) {
            return null;
        }
        XMIResource res = (XMIResource)new ResourceSetImpl().createResource(VIRTUAL_URI);
        ((ResourceImpl)res).setIntrinsicIDToEObjectMap(new HashMap());
        try {
            res.load(new InputSource(new StringReader(object)), ModelUtil.getResourceLoadOptions());
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException(e);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        EObject result = (EObject)res.getContents().get(0);
        if (result instanceof IdEObjectCollection) {
            IdEObjectCollection collection = (IdEObjectCollection)result;
            HashMap<EObject, String> eObjectToIdMap = new HashMap<EObject, String>();
            HashMap<String, EObject> idToEObjectMap = new HashMap<String, EObject>();
            for (EObject modelElement : collection.getAllModelElements()) {
                String modelElementId = ModelUtil.isIgnoredDatatype(modelElement) ? ModelFactory.eINSTANCE.createModelElementId().getId() : res.getID(modelElement);
                if (modelElementId == null) {
                    throw new SerializationException("Failed to retrieve ID for EObject contained in project: " + modelElement);
                }
                eObjectToIdMap.put(modelElement, modelElementId);
                idToEObjectMap.put(modelElementId, modelElement);
            }
            collection.initCaches(eObjectToIdMap, idToEObjectMap);
        }
        EcoreUtil.resolveAll((EObject)result);
        res.getContents().remove((Object)result);
        return result;
    }

    public static Map<Object, Object> getResourceLoadOptions() {
        if (resourceLoadOptions == null) {
            resourceLoadOptions = new HashMap();
            resourceLoadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
            resourceLoadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
            resourceLoadOptions.put("USE_DEPRECATED_METHODS", Boolean.FALSE);
            resourceLoadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
            resourceLoadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
            resourceLoadOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        }
        return resourceLoadOptions;
    }

    public static Map<Object, Object> getResourceSaveOptions() {
        if (resourceSaveOptions == null) {
            resourceSaveOptions = new HashMap();
            resourceSaveOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
            resourceSaveOptions.put("USE_CACHED_LOOKUP_TABLE", new ArrayList());
        }
        return resourceSaveOptions;
    }

    private static boolean canHaveInstances(EClass eClass) {
        return !eClass.isAbstract() && !eClass.isInterface();
    }

    public static Set<EClass> getNonAbstractMETypes(EPackage ePackage) {
        HashSet<EClass> nonAbstractMETypes = new HashSet<EClass>();
        Set<EClass> allMETypes = ModelUtil.getAllMETypes(ePackage);
        for (EClass eClass : allMETypes) {
            if (!ModelUtil.canHaveInstances(eClass)) continue;
            nonAbstractMETypes.add(eClass);
        }
        return nonAbstractMETypes;
    }

    public static Set<EClass> getAllMETypes(EPackage ePackage) {
        HashSet<EClass> meTypes = new HashSet<EClass>();
        for (EObject eObject : ePackage.eContents()) {
            if (eObject instanceof EClass) {
                EClass eClass = (EClass)eObject;
                meTypes.add(eClass);
                continue;
            }
            if (!(eObject instanceof EPackage)) continue;
            EPackage eSubPackage = (EPackage)eObject;
            meTypes.addAll(ModelUtil.getAllMETypes(eSubPackage));
        }
        return meTypes;
    }

    public static void log(String message, Throwable exception, int statusInt) {
        Status status = new Status(statusInt, Platform.getBundle((String)ORG_ECLIPSE_EMF_EMFSTORE_COMMON_MODEL).getSymbolicName(), statusInt, message, exception);
        Platform.getLog((Bundle)Platform.getBundle((String)ORG_ECLIPSE_EMF_EMFSTORE_COMMON_MODEL)).log((IStatus)status);
    }

    public static void logException(String message, Throwable exception) {
        ModelUtil.log(message, exception, 4);
    }

    public static void logException(Throwable exception) {
        ModelUtil.logException(exception.getMessage(), exception);
    }

    public static void logWarning(String message, Throwable exception) {
        ModelUtil.log(message, exception, 2);
    }

    public static void logWarning(String message) {
        ModelUtil.log(message, null, 2);
    }

    public static void logInfo(String message) {
        ModelUtil.log(message, null, 1);
    }

    public static <T extends EObject> T clone(T eObject) {
        if (eObject instanceof ProjectImpl) {
            return ((ProjectImpl)eObject).copy();
        }
        EObject clone = EcoreUtil.copy(eObject);
        return (T)clone;
    }

    public static <T extends EObject> List<T> clone(List<T> list) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject eObject : list) {
            EObject clone = ModelUtil.clone(eObject);
            result.add(clone);
        }
        return result;
    }

    public static <T extends EObject> List<T> flatCloneList(List<T> originalList) {
        ArrayList<EObject> clonedList = new ArrayList<EObject>(originalList.size());
        for (EObject element : originalList) {
            clonedList.add(element);
        }
        return clonedList;
    }

    public static <T extends EObject> T loadEObjectFromResource(EClass eClass, URI resourceURI, boolean checkConstraints) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = checkConstraints ? resourceSet.getResource(resourceURI, false) : resourceSet.getResource(resourceURI, true);
        resource.load(ModelUtil.getResourceLoadOptions());
        EList contents = resource.getContents();
        if (checkConstraints && contents.size() > 1) {
            throw new IOException("Resource containes multiple objects!");
        }
        if (contents.size() < 1) {
            throw new IOException("Resource contains no objects");
        }
        EObject eObject = (EObject)contents.get(0);
        if (eObject instanceof Project && resource instanceof XMIResource) {
            XMIResource xmiResource = (XMIResource)resource;
            Project project = (Project)eObject;
            HashMap<EObject, String> eObjectToIdMap = new HashMap<EObject, String>();
            HashMap<String, EObject> idToEObjectMap = new HashMap<String, EObject>();
            TreeIterator it = project.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                String id = xmiResource.getID(obj);
                if (id == null) continue;
                eObjectToIdMap.put(obj, id);
                idToEObjectMap.put(id, obj);
            }
            project.initCaches(eObjectToIdMap, idToEObjectMap);
        }
        if (!eClass.isInstance((Object)eObject)) {
            throw new IOException("Resource contains no objects of given class");
        }
        return (T)eObject;
    }

    public static void saveEObjectToResource(List<? extends EObject> eObjects, URI resourceURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(resourceURI);
        EList contents = resource.getContents();
        for (EObject eObject : eObjects) {
            contents.add((Object)eObject);
            if (!(eObject instanceof Project) || !(resource instanceof XMIResource)) continue;
            ModelUtil.setXmiIdsOnResource((Project)eObject, (XMIResource)resource);
        }
        contents.addAll(eObjects);
        resource.save(null);
    }

    public static void setXmiIdsOnResource(Project project, XMIResource xmiResource) {
        for (EObject modelElement : project.getAllModelElements()) {
            ModelElementId modelElementId = project.getModelElementId(modelElement);
            xmiResource.setID(modelElement, modelElementId.getId());
        }
    }

    public static void saveEObjectToResource(EObject eObject, URI resourceURI) throws IOException {
        ArrayList<EObject> list = new ArrayList<EObject>();
        list.add(eObject);
        ModelUtil.saveEObjectToResource(list, resourceURI);
    }

    public static int getModelVersionNumber() throws MalformedModelVersionException {
        ExtensionPoint extensionPoint = new ExtensionPoint("org.eclipse.emf.emfstore.common.model.modelversion", true);
        if (extensionPoint.size() != 1) {
            String message = "There is " + extensionPoint.size() + " Model Version(s) registered for the given model. Migrator will assume model version 0.";
            ModelUtil.logInfo(message);
            return 0;
        }
        try {
            return extensionPoint.getFirst().getInteger("versionIdentifier");
        }
        catch (ExtensionPointException e) {
            throw new MalformedModelVersionException("Version identifier was malformed, it must be an integer.", e);
        }
    }

    public static Project getProject(EObject modelElement) {
        HashSet<EObject> seenModelElements = new HashSet<EObject>();
        seenModelElements.add(modelElement);
        return (Project)ModelUtil.getParent(Project.class, modelElement, seenModelElements);
    }

    public static EObject getParent(Class<? extends EObject> parent, EObject child) {
        HashSet<EObject> seenModelElements = new HashSet<EObject>();
        seenModelElements.add(child);
        return ModelUtil.getParent(parent, child, seenModelElements);
    }

    private static EObject getParent(Class<? extends EObject> parent, EObject child, Set<EObject> seenModelElements) {
        if (child == null) {
            return null;
        }
        if (seenModelElements.contains(child.eContainer())) {
            throw new IllegalStateException("ModelElement is in a containment cycle");
        }
        if (parent.isInstance(child)) {
            return child;
        }
        seenModelElements.add(child);
        return ModelUtil.getParent(parent, child.eContainer(), seenModelElements);
    }

    public static boolean isAssociationClassElement(EClass eClazz) {
        if (eClazz == null || eClazz.isAbstract() || eClazz.getInstanceClass() == null) {
            return false;
        }
        return AssociationClassElement.class.isAssignableFrom(eClazz.getInstanceClass());
    }

    public static Set<EObject> getAllContainedModelElements(EObject modelElement, boolean includeTransientContainments) {
        return ModelUtil.getAllContainedModelElements(modelElement, includeTransientContainments, false);
    }

    public static Set<EObject> getAllContainedModelElements(EObject modelElement, boolean includeTransientContainments, boolean ignoreSingletonDatatypes) {
        return ModelUtil.getAllContainedModelElements(Collections.singletonList(modelElement), includeTransientContainments, ignoreSingletonDatatypes);
    }

    public static Set<EObject> getAllContainedModelElements(Resource resource, boolean includeTransientContainments, boolean ignoreSingletonDatatypes) {
        return ModelUtil.getAllContainedModelElements((Collection<EObject>)resource.getContents(), includeTransientContainments, ignoreSingletonDatatypes);
    }

    public static Set<EObject> getAllContainedModelElements(Collection<EObject> modelElements, boolean includeTransientContainments, boolean ignoreSingletonDatatypes) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (EObject modelElement : modelElements) {
            for (EObject containee : modelElement.eContents()) {
                if (!ignoreSingletonDatatypes && ModelUtil.isSingleton(containee) || containee.eContainingFeature().isTransient() && !includeTransientContainments) continue;
                Set<EObject> elements = ModelUtil.getAllContainedModelElements(containee, includeTransientContainments, ignoreSingletonDatatypes);
                result.add(containee);
                result.addAll(elements);
            }
        }
        return result;
    }

    public static EObject getContainerModelElement(EObject modelElement) {
        EObject container = modelElement.eContainer();
        if (container == null) {
            return null;
        }
        if (EcoreFactory.eINSTANCE.getEcorePackage().getEObject().isInstance((Object)container)) {
            return container;
        }
        return null;
    }

    public static List<EObject> getAllContainedModelElementsAsList(EObject modelElement, boolean includeTransientContainments) {
        TreeIterator it = modelElement.eAllContents();
        ArrayList<EObject> result = new ArrayList<EObject>();
        while (it.hasNext()) {
            EObject containee = (EObject)it.next();
            if ((containee.eContainingFeature() == null || containee.eContainingFeature().isTransient()) && !includeTransientContainments) continue;
            result.add(containee);
        }
        return result;
    }

    public static void deleteIncomingCrossReferencesFromParent(Collection<EStructuralFeature.Setting> inverseReferences, EObject modelElement) {
        for (EStructuralFeature.Setting setting : inverseReferences) {
            EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
            EReference reference = (EReference)eStructuralFeature;
            if (reference.isContainer() || reference.isContainment() || !reference.isChangeable()) continue;
            EObject opposite = setting.getEObject();
            if (eStructuralFeature.isMany()) {
                ((EList)opposite.eGet(eStructuralFeature)).remove((Object)modelElement);
                continue;
            }
            opposite.eUnset(eStructuralFeature);
        }
    }

    public static void deleteOutgoingCrossReferences(IdEObjectCollection collection, EObject modelElement) {
        HashSet<EObject> allModelElements = new HashSet<EObject>();
        allModelElements.add(modelElement);
        allModelElements.addAll(ModelUtil.getAllContainedModelElements(modelElement, false));
        List<SettingWithReferencedElement> crossReferences = ModelUtil.collectOutgoingCrossReferences(collection, allModelElements);
        for (SettingWithReferencedElement settingWithReferencedElement : crossReferences) {
            EStructuralFeature.Setting setting = settingWithReferencedElement.getSetting();
            if (!settingWithReferencedElement.getSetting().getEStructuralFeature().isMany()) {
                setting.getEObject().eUnset(setting.getEStructuralFeature());
                continue;
            }
            List references = (List)setting.getEObject().eGet(setting.getEStructuralFeature());
            references.remove(settingWithReferencedElement.getReferencedElement());
        }
    }

    public static List<SettingWithReferencedElement> collectOutgoingCrossReferences(IdEObjectCollection collection, Set<EObject> modelElements) {
        ArrayList<SettingWithReferencedElement> settings = new ArrayList<SettingWithReferencedElement>();
        for (EObject currentElement : modelElements) {
            for (EReference reference : currentElement.eClass().getEAllReferences()) {
                EClassifier eType = reference.getEType();
                if (reference.isContainer() || reference.isContainment() || !reference.isChangeable() || !(eType instanceof EClass)) continue;
                EStructuralFeature.Setting setting = ((InternalEObject)currentElement).eSetting((EStructuralFeature)reference);
                if (reference.isMany()) {
                    List referencedElements = (List)currentElement.eGet((EStructuralFeature)reference);
                    for (EObject referencedElement : referencedElements) {
                        if (!ModelUtil.shouldBeCollected(collection, modelElements, referencedElement)) continue;
                        settings.add(new SettingWithReferencedElement(setting, referencedElement));
                    }
                    continue;
                }
                EObject referencedElement = (EObject)currentElement.eGet((EStructuralFeature)reference);
                if (!ModelUtil.shouldBeCollected(collection, modelElements, referencedElement)) continue;
                settings.add(new SettingWithReferencedElement(setting, referencedElement));
            }
        }
        return settings;
    }

    public static boolean shouldBeCollected(IdEObjectCollection collection, Set<EObject> allModelElements, EObject referencedElement) {
        if (referencedElement == null || !collection.containsInstance(referencedElement)) {
            return false;
        }
        return !ModelUtil.isSingleton(referencedElement) && !ModelUtil.isIgnoredDatatype(referencedElement) && !allModelElements.contains(referencedElement);
    }

    public static EObject getSingleton(ModelElementId singletonId) {
        ModelUtil.initSingletonIdResolvers();
        for (SingletonIdResolver resolver : singletonIdResolvers) {
            EObject singleton = resolver.getSingleton(singletonId);
            if (singleton == null) continue;
            return singleton;
        }
        return null;
    }

    public static ModelElementId getSingletonModelElementId(EObject singleton) {
        ModelUtil.initSingletonIdResolvers();
        for (SingletonIdResolver resolver : singletonIdResolvers) {
            ModelElementId id = resolver.getSingletonModelElementId(singleton);
            if (id == null) continue;
            return ModelUtil.clone(id);
        }
        return null;
    }

    public static boolean isSingleton(EObject eObject) {
        ModelUtil.initSingletonIdResolvers();
        for (SingletonIdResolver resolver : singletonIdResolvers) {
            if (!resolver.isSingleton(eObject)) continue;
            return true;
        }
        return false;
    }

    private static void initSingletonIdResolvers() {
        if (singletonIdResolvers == null) {
            singletonIdResolvers = new HashSet<SingletonIdResolver>();
            for (ExtensionElement element : new ExtensionPoint("org.eclipse.emf.emfstore.common.model.singletonidresolver").getExtensionElements()) {
                try {
                    singletonIdResolvers.add((SingletonIdResolver)element.getClass("class", SingletonIdResolver.class));
                }
                catch (ExtensionPointException e) {
                    ModelUtil.logWarning("Couldn't instantiate Singleton ID resolver:" + e.getMessage());
                }
            }
        }
    }

    public static Map<EObject, ModelElementId> copyModelElement(EObject originalObject, EObject copiedObject) {
        HashMap<EObject, ModelElementId> idMap = new HashMap<EObject, ModelElementId>();
        Project project = ModelUtil.getProject(originalObject);
        if (project == null) {
            throw new IllegalArgumentException("EObject is not contained in a project.");
        }
        List<EObject> allContainedModelElements = ModelUtil.getAllContainedModelElementsAsList(originalObject, false);
        allContainedModelElements.add(originalObject);
        List<EObject> copiedAllContainedModelElements = ModelUtil.getAllContainedModelElementsAsList(copiedObject, false);
        copiedAllContainedModelElements.add(copiedObject);
        int i = 0;
        while (i < allContainedModelElements.size()) {
            EObject child = allContainedModelElements.get(i);
            EObject copiedChild = copiedAllContainedModelElements.get(i);
            ModelElementId childId = ModelUtil.clone(project.getModelElementId(child));
            if (!ModelUtil.isIgnoredDatatype(child)) {
                idMap.put(copiedChild, childId);
            }
            ++i;
        }
        return idMap;
    }
}

