/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.emfstore.client.model.exceptions.ChangeConflictException;
import org.eclipse.emf.emfstore.client.model.observers.ConflictResolver;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.DecisionManager;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.MergeWizard;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.CaseStudySwitch;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeProjectHandler
implements ConflictResolver {
    private List<AbstractOperation> acceptedMine = new ArrayList<AbstractOperation>();
    private List<AbstractOperation> rejectedTheirs = new ArrayList<AbstractOperation>();

    public MergeProjectHandler(ChangeConflictException conflictException) {
    }

    public List<AbstractOperation> getAcceptedMine() {
        return this.acceptedMine;
    }

    public List<AbstractOperation> getRejectedTheirs() {
        return this.rejectedTheirs;
    }

    public boolean resolveConflicts(Project project, List<ChangePackage> theirChangePackages, ChangePackage myChangePackage, PrimaryVersionSpec base, PrimaryVersionSpec target) {
        DecisionManager decisionManager;
        boolean caseStudy = false;
        if (caseStudy) {
            CaseStudySwitch studySwitch = new CaseStudySwitch();
            studySwitch.flattenChangePackages(myChangePackage, theirChangePackages);
        }
        if ((decisionManager = new DecisionManager(project, myChangePackage, theirChangePackages, base, target)).getConflicts().size() == 0) {
            return true;
        }
        MergeWizard wizard = new MergeWizard(decisionManager);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.setPageSize(1000, 500);
        dialog.setBlockOnOpen(true);
        dialog.create();
        int open = dialog.open();
        this.acceptedMine = decisionManager.getAcceptedMine();
        this.rejectedTheirs = decisionManager.getRejectedTheirs();
        return open == 0;
    }
}

