/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol;

import org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol.AttributeControl;
import org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol.MultiAttributeControl;
import org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol.MultiAttributeController;
import org.eclipse.emf.ecp.editor.mecontrols.multiattributecontrol.StringMultiAttributeControl;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StringAttributeControl
extends AttributeControl {
    private MultiAttributeController<String> dataManipulator;
    private Text widget;
    private String value;

    StringAttributeControl(MultiAttributeControl parentItem, MultiAttributeController<String> dataManipulator, String value) {
        this.setParentItem(parentItem);
        this.dataManipulator = dataManipulator;
        this.value = value;
        this.setIndex(parentItem.getControlList().size());
        parentItem.getControlList().add(this);
        this.createCompositeLayout();
        this.setWidget(parentItem.getToolkit().createText(this.getFieldComposite(), value, parentItem.getStyle() | 4));
        this.getWidget().addModifyListener((ModifyListener)this);
        this.createDeleteButton();
        this.createUpDownButtons();
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.getWidget());
    }

    StringAttributeControl(MultiAttributeControl parentItem, MultiAttributeController<String> dataManipulator) {
        this.setParentItem(parentItem);
        this.dataManipulator = dataManipulator;
        this.value = StringMultiAttributeControl.getEmptyValue();
        this.createCompositeLayout();
        this.setWidget(parentItem.getToolkit().createText(this.getFieldComposite(), this.value, parentItem.getStyle() | 4));
        this.getWidget().addModifyListener((ModifyListener)this);
        this.getWidget().setMessage("Add new element...");
        this.createAddButton();
        this.createInvisibleUpDownButtons();
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)this.getWidget());
    }

    private StringAttributeControl() {
    }

    @Override
    protected boolean swapThisControlWith(int index) {
        if (index >= this.getParentItem().getControlList().size() || index < 0) {
            return false;
        }
        String random = "";
        while (this.dataManipulator.contains(random)) {
            random = Double.valueOf(Math.random()).toString();
        }
        String thisValue = this.value;
        String otherValue = ((StringAttributeControl)this.getParentItem().getControlList().get((int)index)).value;
        this.getWidget().setText(random);
        ((StringAttributeControl)this.getParentItem().getControlList().get(index)).getWidget().setText(thisValue);
        this.getWidget().setText(otherValue);
        return true;
    }

    @Override
    public void modifyText(ModifyEvent e) {
        if (e.getSource().equals(this.getWidget())) {
            if (this.getIndex() == -1) {
                this.getButton().dispose();
                this.getWidget().setMessage("");
                this.createDeleteButton();
                this.createUpDownButtons();
            }
            String newValue = this.getWidget().getText();
            if (!this.getParentItem().isAllowDuplicates() && this.dataManipulator.contains(newValue)) {
                this.getWidget().setText("_" + newValue);
                return;
            }
            if (this.getIndex() != -1) {
                this.dataManipulator.replaceElementAt(this.getIndex(), newValue);
                this.value = newValue;
            } else {
                this.setIndex(this.getParentItem().getControlList().size());
                this.getParentItem().getControlList().add(this);
                this.dataManipulator.add(newValue);
                this.value = newValue;
                this.getButton().setVisible(true);
                if (!this.getParentItem().isFull()) {
                    this.getParentItem().createSingleField();
                }
                this.getFieldComposite().layout();
            }
            this.getParentItem().refreshWidget();
        }
    }

    @Override
    protected void addButtonFunctionality() {
        if (!this.getParentItem().isAllowDuplicates()) {
            while (this.dataManipulator.contains(this.value)) {
                this.value = "_" + this.value;
            }
        }
        this.getWidget().setText(this.value);
        this.getButton().dispose();
        this.getWidget().setMessage("");
        this.createDeleteButton();
        this.createUpDownButtons();
    }

    @Override
    protected boolean removeElementAt(int i) {
        return this.dataManipulator.removeElementAt(i);
    }

    public void setWidget(Text widget) {
        this.widget = widget;
    }

    public Text getWidget() {
        return this.widget;
    }
}

