/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.observers.CommitObserver;
import org.eclipse.emf.emfstore.client.model.observers.OperationObserver;
import org.eclipse.emf.emfstore.client.model.observers.ShareObserver;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.ModelFactory;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;

public class ModifiedModelElementsCache
implements OperationObserver,
CommitObserver,
ShareObserver {
    private Map<String, List<AbstractOperation>> modifiedModelElements;
    private Map<String, Integer> modifiedModelElementParents;
    private HashMap<String, String> childParentMapping;
    private ProjectSpace projectSpace;

    public ModifiedModelElementsCache(ProjectSpace projectSpace) {
        this.projectSpace = projectSpace;
        this.modifiedModelElements = new HashMap<String, List<AbstractOperation>>();
        this.modifiedModelElementParents = new HashMap<String, Integer>();
        this.childParentMapping = new HashMap();
    }

    public void initializeCache() {
        if (this.projectSpace != null && this.projectSpace.getOperations() != null) {
            for (AbstractOperation abstractOperation : this.projectSpace.getOperations()) {
                this.operationExecuted(abstractOperation);
            }
        }
    }

    public boolean isModelElementDirty(ModelElementId modelElementId) {
        return this.modifiedModelElementParents.containsKey(modelElementId.getId()) || this.modifiedModelElements.containsKey(modelElementId.getId());
    }

    public void operationExecuted(AbstractOperation abstractOperation) {
        for (ModelElementId modelElementId : abstractOperation.getAllInvolvedModelElements()) {
            if (this.modifiedModelElements.containsKey(modelElementId.getId())) {
                this.modifiedModelElements.get(modelElementId.getId()).add(abstractOperation);
                continue;
            }
            ArrayList<AbstractOperation> abstractOperations = new ArrayList<AbstractOperation>();
            abstractOperations.add(abstractOperation);
            this.modifiedModelElements.put(modelElementId.getId(), abstractOperations);
            ModelElementId nextParentModelElementId = this.getNextParentModelElementId(modelElementId.getId());
            if (nextParentModelElementId == null) continue;
            this.childParentMapping.put(modelElementId.getId(), nextParentModelElementId.getId());
            this.addOneToParent(nextParentModelElementId);
        }
    }

    private void removeOneFromParent(String parentModelElementId) {
        Integer number = this.modifiedModelElementParents.get(parentModelElementId);
        if (number == null || number - 1 == 0) {
            ModelElementId nextParentModelElementId;
            this.modifiedModelElementParents.remove(parentModelElementId);
            if (!this.modifiedModelElements.containsKey(parentModelElementId) && (nextParentModelElementId = this.getNextParentModelElementId(parentModelElementId)) != null) {
                this.removeOneFromParent(nextParentModelElementId.getId());
            }
        } else {
            this.modifiedModelElementParents.put(parentModelElementId, number - 1);
        }
    }

    private void addOneToParent(ModelElementId parentModelElementId) {
        Integer number = this.modifiedModelElementParents.get(parentModelElementId);
        if (number == null || number < 1) {
            EObject nextParentModelElement;
            number = 1;
            if (!this.modifiedModelElements.containsKey(parentModelElementId.getId()) && (nextParentModelElement = this.getModelElementForId(parentModelElementId.getId()).eContainer()) != null && nextParentModelElement != this.projectSpace.getProject()) {
                this.addOneToParent(this.projectSpace.getProject().getModelElementId(nextParentModelElement));
            }
        } else {
            number = number + 1;
        }
        this.modifiedModelElementParents.put(parentModelElementId.getId(), number);
    }

    private ModelElementId getNextParentModelElementId(String childModelElementId) {
        EObject childModelElement = this.getModelElementForId(childModelElementId);
        if (childModelElement == null) {
            return null;
        }
        EObject nextParentModelElement = childModelElement.eContainer();
        if (nextParentModelElement == null || nextParentModelElement == this.projectSpace.getProject()) {
            return null;
        }
        return this.projectSpace.getProject().getModelElementId(nextParentModelElement);
    }

    private EObject getModelElementForId(String modelElementIdString) {
        ModelElementId modelElementId = ModelFactory.eINSTANCE.createModelElementId();
        modelElementId.setId(modelElementIdString);
        return this.projectSpace.getProject().getModelElement(modelElementId);
    }

    public void operationUnDone(AbstractOperation operation) {
        Set involvedMEs = operation.getAllInvolvedModelElements();
        for (ModelElementId childModelElementId : involvedMEs) {
            if (!this.modifiedModelElements.containsKey(childModelElementId.getId())) continue;
            this.modifiedModelElements.get(childModelElementId.getId()).remove(operation);
            if (this.modifiedModelElements.get(childModelElementId.getId()).size() != 0) continue;
            this.modifiedModelElements.remove(childModelElementId.getId());
            if (this.childParentMapping.get(childModelElementId.getId()) == null) continue;
            this.removeOneFromParent(this.childParentMapping.get(childModelElementId.getId()));
        }
    }

    public void commitCompleted(ProjectSpace projectSpace, PrimaryVersionSpec newRevision) {
        this.shareDone(projectSpace);
    }

    public boolean inspectChanges(ProjectSpace projectSpace, ChangePackage changePackage) {
        return true;
    }

    public void shareDone(ProjectSpace projectSpace) {
        this.modifiedModelElementParents.clear();
        this.modifiedModelElements.clear();
    }
}

