/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.controller;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.client.model.controller.callbacks.UpdateCallback;
import org.eclipse.emf.emfstore.client.model.exceptions.ChangeConflictException;
import org.eclipse.emf.emfstore.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.client.model.observers.UpdateObserver;
import org.eclipse.emf.emfstore.server.conflictDetection.ConflictDetector;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateController
extends ServerCall<PrimaryVersionSpec> {
    private VersionSpec version;
    private UpdateCallback callback;

    public UpdateController(ProjectSpaceBase projectSpace, VersionSpec version, UpdateCallback callback, IProgressMonitor progress) {
        super(projectSpace);
        if (version == null) {
            version = VersionSpec.HEAD_VERSION;
        }
        if (callback == null) {
            callback = UpdateCallback.NOCALLBACK;
        }
        this.version = version;
        this.callback = callback;
        this.setProgressMonitor(progress);
    }

    @Override
    protected PrimaryVersionSpec run() throws EmfStoreException {
        return this.doUpdate(this.version);
    }

    private PrimaryVersionSpec doUpdate(VersionSpec version) throws EmfStoreException {
        this.getProgressMonitor().beginTask("Updating Project", 100);
        this.getProgressMonitor().worked(1);
        this.getProgressMonitor().subTask("Resolving new version");
        PrimaryVersionSpec resolvedVersion = this.getProjectSpace().resolveVersionSpec(version);
        if (resolvedVersion.compareTo((Object)this.getProjectSpace().getBaseVersion()) == 0) {
            return resolvedVersion;
        }
        this.getProgressMonitor().worked(5);
        if (this.getProgressMonitor().isCanceled()) {
            return this.getProjectSpace().getBaseVersion();
        }
        this.getProgressMonitor().subTask("Fetching changes from server");
        List<ChangePackage> changes = new ArrayList();
        changes = this.getConnectionManager().getChanges(this.getSessionId(), this.getProjectSpace().getProjectId(), (VersionSpec)this.getProjectSpace().getBaseVersion(), (VersionSpec)resolvedVersion);
        ChangePackage localchanges = this.getProjectSpace().getLocalChangePackage(false);
        this.getProgressMonitor().worked(65);
        if (this.getProgressMonitor().isCanceled()) {
            return this.getProjectSpace().getBaseVersion();
        }
        this.getProgressMonitor().subTask("Checking for conflicts");
        ConflictDetector conflictDetector = new ConflictDetector();
        for (ChangePackage change : changes) {
            if (!conflictDetector.doConflict(change, localchanges)) continue;
            if (this.callback.conflictOccurred(new ChangeConflictException(changes, this.getProjectSpace(), conflictDetector))) {
                return this.getProjectSpace().getBaseVersion();
            }
            throw new ChangeConflictException(changes, this.getProjectSpace(), conflictDetector);
        }
        this.getProgressMonitor().worked(15);
        if (this.getProgressMonitor().isCanceled() || !this.callback.inspectChanges(this.getProjectSpace(), changes)) {
            return resolvedVersion;
        }
        ((UpdateObserver)WorkspaceManager.getObserverBus().notify(UpdateObserver.class)).inspectChanges(this.getProjectSpace(), changes);
        this.getProgressMonitor().subTask("Applying changes");
        List<ChangePackage> cps = changes;
        this.getProjectSpace().revert();
        for (ChangePackage change : cps) {
            this.getProjectSpace().applyOperations(change.getCopyOfOperations(), false);
        }
        this.getProjectSpace().applyOperations(localchanges.getCopyOfOperations(), true);
        this.getProjectSpace().setBaseVersion(resolvedVersion);
        this.getProjectSpace().saveProjectSpaceOnly();
        ((UpdateObserver)WorkspaceManager.getObserverBus().notify(UpdateObserver.class)).updateCompleted(this.getProjectSpace());
        return this.getProjectSpace().getBaseVersion();
    }
}

