/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.impl;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.emfstore.client.model.AdminBroker;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.server.exceptions.ConnectionException;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.server.model.SessionId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.model.accesscontrol.roles.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminBrokerImpl
implements AdminBroker {
    private SessionId sessionId;

    public AdminBrokerImpl(ServerInfo serverInfo, SessionId sessionId) throws ConnectionException {
        this.sessionId = sessionId;
        WorkspaceManager.getInstance().getAdminConnectionManager().initConnection(serverInfo, sessionId);
    }

    @Override
    public void addParticipant(ProjectId projectId, ACOrgUnitId participant) throws EmfStoreException {
        WorkspaceManager.getInstance().getAdminConnectionManager().addParticipant(this.getSessionId(), projectId, participant);
    }

    @Override
    public void changeRole(ProjectId projectId, ACOrgUnitId orgUnit, EClass role) throws EmfStoreException {
        WorkspaceManager.getInstance().getAdminConnectionManager().changeRole(this.getSessionId(), projectId, orgUnit, role);
    }

    @Override
    public List<ACGroup> getGroups() throws EmfStoreException {
        return WorkspaceManager.getInstance().getAdminConnectionManager().getGroups(this.getSessionId());
    }

    @Override
    public List<ACGroup> getGroups(ACOrgUnitId user) throws EmfStoreException {
        return WorkspaceManager.getInstance().getAdminConnectionManager().getGroups(this.getSessionId(), user);
    }

    @Override
    public List<ACOrgUnit> getOrgUnits() throws EmfStoreException {
        return WorkspaceManager.getInstance().getAdminConnectionManager().getOrgUnits(this.getSessionId());
    }

    @Override
    public List<ACOrgUnit> getParticipants(ProjectId projectId) throws EmfStoreException {
        return WorkspaceManager.getInstance().getAdminConnectionManager().getParticipants(this.getSessionId(), projectId);
    }

    @Override
    public List<ACOrgUnit> getMembers(ACOrgUnitId groupId) throws EmfStoreException {
        return WorkspaceManager.getInstance().getAdminConnectionManager().getMembers(this.getSessionId(), groupId);
    }

    @Override
    public List<ProjectInfo> getProjectInfos() throws EmfStoreException {
        return WorkspaceManager.getInstance().getAdminConnectionManager().getProjectInfos(this.getSessionId());
    }

    @Override
    public Role getRole(ProjectId projectId, ACOrgUnitId orgUnit) throws EmfStoreException {
        return WorkspaceManager.getInstance().getAdminConnectionManager().getRole(this.getSessionId(), projectId, orgUnit);
    }

    @Override
    public List<ACUser> getUsers() throws EmfStoreException {
        return WorkspaceManager.getInstance().getAdminConnectionManager().getUsers(this.getSessionId());
    }

    @Override
    public void removeGroup(ACOrgUnitId user, ACOrgUnitId group) throws EmfStoreException {
        WorkspaceManager.getInstance().getAdminConnectionManager().removeGroup(this.getSessionId(), user, group);
    }

    @Override
    public void removeParticipant(ProjectId projectId, ACOrgUnitId participant) throws EmfStoreException {
        WorkspaceManager.getInstance().getAdminConnectionManager().removeParticipant(this.getSessionId(), projectId, participant);
    }

    private SessionId getSessionId() {
        return this.sessionId;
    }

    @Override
    public ACOrgUnitId createGroup(String name) throws EmfStoreException {
        return WorkspaceManager.getInstance().getAdminConnectionManager().createGroup(this.getSessionId(), name);
    }

    @Override
    public ACOrgUnitId createUser(String name) throws EmfStoreException {
        return WorkspaceManager.getInstance().getAdminConnectionManager().createUser(this.getSessionId(), name);
    }

    @Override
    public void deleteGroup(ACOrgUnitId group) throws EmfStoreException {
        WorkspaceManager.getInstance().getAdminConnectionManager().deleteGroup(this.getSessionId(), group);
    }

    @Override
    public void deleteUser(ACOrgUnitId user) throws EmfStoreException {
        WorkspaceManager.getInstance().getAdminConnectionManager().deleteUser(this.getSessionId(), user);
    }

    @Override
    public void addMember(ACOrgUnitId group, ACOrgUnitId member) throws EmfStoreException {
        WorkspaceManager.getInstance().getAdminConnectionManager().addMember(this.getSessionId(), group, member);
    }

    @Override
    public void removeMember(ACOrgUnitId group, ACOrgUnitId member) throws EmfStoreException {
        WorkspaceManager.getInstance().getAdminConnectionManager().removeMember(this.getSessionId(), group, member);
    }

    @Override
    public void changeOrgUnit(ACOrgUnitId orgUnitId, String name, String description) throws EmfStoreException {
        WorkspaceManager.getInstance().getAdminConnectionManager().changeOrgUnit(this.getSessionId(), orgUnitId, name, description);
    }

    @Override
    public ACOrgUnit getOrgUnit(ACOrgUnitId orgUnitId) throws EmfStoreException {
        return WorkspaceManager.getInstance().getAdminConnectionManager().getOrgUnit(this.sessionId, orgUnitId);
    }
}

