/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.client.model.Configuration;
import org.eclipse.emf.emfstore.client.model.changeTracking.commands.CommandObserver;
import org.eclipse.emf.emfstore.client.model.changeTracking.commands.EMFStoreCommandStack;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.NotificationInfo;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.filter.EmptyRemovalsFilter;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.filter.FilterStack;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.filter.NotificationFilter;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.filter.TouchFilter;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.filter.TransientFilter;
import org.eclipse.emf.emfstore.client.model.impl.DirtyResourceSet;
import org.eclipse.emf.emfstore.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.common.model.impl.IdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.common.model.util.EObjectChangeNotifier;
import org.eclipse.emf.emfstore.common.model.util.IdEObjectCollectionChangeObserver;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;

public class StatePersister
implements CommandObserver,
IdEObjectCollectionChangeObserver {
    private DirtyResourceSet dirtyResourceSet;
    private boolean commandIsRunning;
    private boolean splitResource;
    private EMFStoreCommandStack commandStack;
    private FilterStack filterStack;
    private static Resource currentResource;

    public StatePersister(EObjectChangeNotifier changeNotifier, EMFStoreCommandStack commandStack, IdEObjectCollectionImpl collection) {
        this.commandStack = commandStack;
        this.commandStack.addCommandStackObserver(this);
        this.dirtyResourceSet = new DirtyResourceSet(collection);
        this.filterStack = new FilterStack(new NotificationFilter[]{new TouchFilter(), new TransientFilter(), new EmptyRemovalsFilter()});
    }

    public void commandStarted(Command command) {
        this.commandIsRunning = true;
    }

    public void commandCompleted(Command command) {
        this.commandIsRunning = false;
        this.saveDirtyResources(false);
    }

    public void commandFailed(Command command, Exception exception) {
        this.commandIsRunning = false;
    }

    private void cleanResources(EObject deletedElement) {
        Resource resource = deletedElement.eResource();
        if (resource != null) {
            resource.getContents().remove((Object)deletedElement);
            this.dirtyResourceSet.addDirtyResource(resource);
        }
        for (EObject child : ModelUtil.getAllContainedModelElements((EObject)deletedElement, (boolean)false)) {
            Resource childResource = child.eResource();
            if (childResource == null) continue;
            childResource.getContents().remove((Object)child);
            this.dirtyResourceSet.addDirtyResource(childResource);
        }
    }

    private void addToDirtyResources(EObject modelElement) {
        Resource resource = modelElement.eResource();
        if (resource != null) {
            this.dirtyResourceSet.addDirtyResource(resource);
        }
    }

    public void saveDirtyResources(boolean force) {
        if (force || Configuration.isAutoSaveEnabled()) {
            this.dirtyResourceSet.save();
        }
    }

    public void notify(Notification notification, IdEObjectCollection rootEObject, EObject modelElement) {
        if (this.filterStack.check(new NotificationInfo(notification))) {
            return;
        }
        this.addToDirtyResources(modelElement);
        if (!this.commandIsRunning) {
            this.saveDirtyResources(false);
        }
    }

    public void modelElementAdded(IdEObjectCollection rootEObject, EObject modelElement) {
        XMIResource oldResource = (XMIResource)modelElement.eResource();
        if (oldResource != null && Configuration.isResourceSplittingEnabled() && !(modelElement instanceof BasicEMap.Entry)) {
            this.addToNewResourceIfRequired(modelElement, oldResource);
        }
        this.addToDirtyResources(modelElement);
    }

    public void modelElementRemoved(IdEObjectCollection rootEObject, EObject modelElement) {
        this.cleanResources(modelElement);
    }

    public void collectionDeleted(IdEObjectCollection collection) {
        if (this.commandStack != null) {
            this.commandStack.removeCommandStackObserver(this);
        }
    }

    private void addToNewResourceIfRequired(EObject modelElement, XMIResource oldResource) {
        if (currentResource == null || currentResource.getURI() == null) {
            currentResource = oldResource;
        }
        URI oldUri = currentResource.getURI();
        String oldFileName = oldUri.toFileString();
        if (!oldUri.isFile()) {
            throw new IllegalStateException("Project contains ModelElements that are not part of a file resource.");
        }
        File oldFile = new File(oldFileName);
        if (oldFile.length() > (long)Configuration.getMaxResourceFileSizeOnExpand()) {
            String newFileName;
            try {
                newFileName = File.createTempFile("frag", Configuration.getProjectFragmentFileExtension(), new File(oldFile.getParent())).getAbsolutePath();
            }
            catch (IOException e) {
                throw new IllegalStateException("File fragment \"\" already exists - ProjectSpace corrupted.\nCause: " + e.getMessage());
            }
            URI fileURI = URI.createFileURI((String)newFileName);
            XMIResource newResource = (XMIResource)currentResource.getResourceSet().createResource(fileURI);
            newResource.getContents().add((Object)modelElement);
            currentResource = newResource;
        }
    }

    public void setSplitResource(boolean splitResource) {
        this.splitResource = splitResource;
    }

    public boolean isSplitResource() {
        return this.splitResource;
    }
}

