/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.util;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.Workspace;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceHelper {
    private ResourceHelper() {
    }

    public static <T extends EObject> T getElementFromResource(String absoluteFileName, Class<T> type, Map<?, ?> options, int index) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)absoluteFileName));
        if (options != null) {
            resource.load(options);
        } else {
            resource.load(ModelUtil.getResourceLoadOptions());
        }
        EList directContents = resource.getContents();
        if (directContents.size() != 1 && !type.isInstance(directContents.get(0))) {
            throw new IOException("File is corrupt, does not contain a " + type.getName() + " .");
        }
        EObject object = (EObject)directContents.get(index);
        resource.getContents().remove((Object)object);
        return (T)object;
    }

    public static <T extends EObject> T getElementFromResource(String absoluteFileName, Class<T> type, int index) throws IOException {
        return ResourceHelper.getElementFromResource(absoluteFileName, type, null, index);
    }

    public static <T extends EObject> void putElementIntoNewResource(String absoluteFileName, T element) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)absoluteFileName));
        resource.getContents().add(element);
        resource.save(null);
    }

    public static <T extends EObject> void putElementIntoNewResourceWithProject(String absoluteFileName, T element, Project project) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)absoluteFileName));
        resource.getContents().add(element);
        if (resource instanceof XMIResource) {
            XMIResource xmiResource = (XMIResource)resource;
            for (EObject modelElement : project.getAllModelElements()) {
                String modelElementId = project.getModelElementId(modelElement).getId();
                xmiResource.setID(modelElement, modelElementId);
            }
        }
        resource.save(null);
    }

    public static <T extends EObject> void putWorkspaceIntoNewResource(String absoluteFileName, Workspace workSpace) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createFileURI((String)absoluteFileName));
        resource.getContents().add((Object)workSpace);
        if (resource instanceof XMIResource) {
            XMIResource xmiResource = (XMIResource)resource;
            for (ProjectSpace projectSpace : workSpace.getProjectSpaces()) {
                Project project = projectSpace.getProject();
                TreeIterator it = project.eAllContents();
                while (it.hasNext()) {
                    EObject modelElement = (EObject)it.next();
                    String modelElementId = project.getModelElementId(modelElement).getId();
                    xmiResource.setID(modelElement, modelElementId);
                }
            }
        }
        resource.save(null);
    }
}

