/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UiUtil {
    private static AdapterFactoryLabelProvider labelProvider;
    public static final String MEEDITOR_ID = "org.eclipse.emf.ecp.editor";
    public static final String MEEDITOR_OPENMODELELEMENT_COMMAND_ID = "org.eclipse.emf.ecp.editor.openModelElement";
    public static final String MECONTEXT_EVALUATIONCONTEXT_VARIABLE = "meContext";
    public static final String ME_TO_OPEN_EVALUATIONCONTEXT_VARIABLE = "meToOpen";

    private UiUtil() {
    }

    public static EObject getModelElement(ExecutionEvent event) {
        EObject me = null;
        String partId = HandlerUtil.getActivePartId((ExecutionEvent)event);
        if (partId != null && partId.equals(MEEDITOR_ID)) {
            IEditorInput editorInput = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
            Object obj = editorInput.getAdapter(EObject.class);
            me = (EObject)obj;
        } else {
            EObject eObject = UiUtil.getSelection(event);
            if (eObject == null) {
                return null;
            }
            me = eObject;
        }
        return me;
    }

    public static Object[] showMESelectionDialog(Shell shell, Collection<?> initialContent, String title, boolean multiSelection) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        ElementListSelectionDialog dlg = new ElementListSelectionDialog(shell.getShell(), (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        dlg.setElements(initialContent.toArray(new Object[initialContent.size()]));
        dlg.setTitle(title);
        dlg.setBlockOnOpen(true);
        dlg.setMultipleSelection(multiSelection);
        Object[] result = new Object[]{};
        if (dlg.open() == 0) {
            result = dlg.getResult();
        }
        adapterFactory.dispose();
        return result;
    }

    public static String getNameForModelElement(EObject modelElement) {
        ComposedAdapterFactory adapterFactory = null;
        if (labelProvider == null) {
            adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        }
        String text = labelProvider.getText((Object)modelElement);
        if (adapterFactory != null) {
            adapterFactory.dispose();
        }
        return text;
    }

    public static EObject getSelection(ExecutionEvent event) {
        EObject result = null;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ssel = (IStructuredSelection)sel;
        if (ssel.isEmpty()) {
            return null;
        }
        Object obj = ssel.getFirstElement();
        if (obj instanceof EObject) {
            result = (EObject)obj;
        }
        return result;
    }

    public static Object getSelection() {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection sel = selectionService.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ssel = (IStructuredSelection)sel;
        if (ssel.isEmpty()) {
            return null;
        }
        Object o = ssel.getFirstElement();
        return o;
    }

    public static EObject getSelectedEObject() {
        Object obj = UiUtil.getSelection();
        if (obj instanceof EObject) {
            return (EObject)obj;
        }
        return null;
    }

    public static Set<EObject> getSelectedEObjects(ExecutionEvent event) {
        Set<EObject> result = Collections.emptySet();
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(sel instanceof IStructuredSelection)) {
            return result;
        }
        IStructuredSelection ssel = (IStructuredSelection)sel;
        if (ssel.isEmpty()) {
            return result;
        }
        result = new HashSet<EObject>();
        Object[] objectArray = ssel.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof EObject) {
                result.add((EObject)object);
            }
            ++n2;
        }
        return result;
    }

    public static EObject getSelectedModelelement() {
        Object obj = UiUtil.getSelection();
        if (obj instanceof EObject) {
            return (EObject)obj;
        }
        if (obj instanceof DelegatingWrapperItemProvider) {
            if (((DelegatingWrapperItemProvider)obj).getValue() instanceof EObject) {
                return (EObject)((DelegatingWrapperItemProvider)obj).getValue();
            }
            return null;
        }
        return null;
    }

    public static <T> T getEventElementByClass(ExecutionEvent event, Class<T> clazz) {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel == null) {
            sel = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        }
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)sel;
        if (structuredSelection.isEmpty()) {
            return null;
        }
        Object selectedElement = structuredSelection.getFirstElement();
        if (!clazz.isInstance(selectedElement)) {
            return null;
        }
        return (T)selectedElement;
    }
}

