/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.AdminEmfStore;
import org.eclipse.emf.emfstore.internal.server.accesscontrol.AuthorizationControl;
import org.eclipse.emf.emfstore.internal.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidInputException;
import org.eclipse.emf.emfstore.internal.server.exceptions.StorageException;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.ServerSpace;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.AccesscontrolFactory;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.ReaderRole;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.RolesFactory;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.RolesPackage;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminEmfStoreImpl
extends AbstractEmfstoreInterface
implements AdminEmfStore {
    public AdminEmfStoreImpl(ServerSpace serverSpace, AuthorizationControl authorizationControl) throws FatalESException {
        super(serverSpace, authorizationControl);
    }

    @Override
    public List<ACGroup> getGroups(SessionId sessionId) throws ESException {
        if (sessionId == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        ArrayList<ACGroup> result = new ArrayList<ACGroup>();
        for (ACGroup group : this.getServerSpace().getGroups()) {
            ACGroup copy = (ACGroup)ModelUtil.clone((EObject)group);
            this.clearMembersFromGroup((ACOrgUnit)copy);
            result.add(copy);
        }
        return result;
    }

    @Override
    public List<ACGroup> getGroups(SessionId sessionId, ACOrgUnitId orgUnitId) throws ESException {
        if (sessionId == null || orgUnitId == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        ArrayList<ACGroup> result = new ArrayList<ACGroup>();
        ACOrgUnit orgUnit = this.getOrgUnit(orgUnitId);
        for (ACGroup group : this.getServerSpace().getGroups()) {
            if (!group.getMembers().contains((Object)orgUnit)) continue;
            ACGroup copy = (ACGroup)ModelUtil.clone((EObject)group);
            this.clearMembersFromGroup((ACOrgUnit)copy);
            result.add(copy);
        }
        return result;
    }

    @Override
    public ACOrgUnitId createGroup(SessionId sessionId, String name) throws ESException {
        if (sessionId == null || name == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        if (this.groupExists(name)) {
            throw new InvalidInputException("group already exists.");
        }
        ACGroup acGroup = AccesscontrolFactory.eINSTANCE.createACGroup();
        acGroup.setName(name);
        acGroup.setDescription("");
        this.getServerSpace().getGroups().add((Object)acGroup);
        this.save();
        return (ACOrgUnitId)ModelUtil.clone((EObject)acGroup.getId());
    }

    private boolean groupExists(String name) {
        for (ACGroup group : this.getServerSpace().getGroups()) {
            if (!group.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeGroup(SessionId sessionId, ACOrgUnitId user, ACOrgUnitId group) throws ESException {
        if (sessionId == null || user == null || group == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        this.getGroup(group).getMembers().remove((Object)this.getOrgUnit(user));
        this.save();
    }

    @Override
    public void deleteGroup(SessionId sessionId, ACOrgUnitId group) throws ESException {
        if (sessionId == null || group == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        for (ACGroup next : this.getServerSpace().getGroups()) {
            if (!next.getId().equals(group)) continue;
            EcoreUtil.delete((EObject)next);
            this.save();
            return;
        }
    }

    @Override
    public List<ACOrgUnit> getMembers(SessionId sessionId, ACOrgUnitId groupId) throws ESException {
        if (sessionId == null || groupId == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        ArrayList<ACOrgUnit> result = new ArrayList<ACOrgUnit>();
        for (ACOrgUnit orgUnit : this.getGroup(groupId).getMembers()) {
            result.add((ACOrgUnit)ModelUtil.clone((EObject)orgUnit));
        }
        this.clearMembersFromGroups(result);
        return result;
    }

    @Override
    public void addMember(SessionId sessionId, ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        if (sessionId == null || group == null || member == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        ACGroup acGroup = this.getGroup(group);
        ACOrgUnit acMember = this.getOrgUnit(member);
        acGroup.getMembers().add((Object)acMember);
        this.save();
    }

    @Override
    public void removeMember(SessionId sessionId, ACOrgUnitId group, ACOrgUnitId member) throws ESException {
        if (sessionId == null || group == null || member == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        ACGroup acGroup = this.getGroup(group);
        ACOrgUnit acMember = this.getOrgUnit(member);
        if (acGroup.getMembers().contains((Object)acMember)) {
            acGroup.getMembers().remove((Object)acMember);
            this.save();
        }
    }

    @Override
    public List<ACOrgUnit> getParticipants(SessionId sessionId, ProjectId projectId) throws ESException {
        if (sessionId == null || projectId == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkProjectAdminAccess(sessionId, projectId);
        ArrayList<ACOrgUnit> result = new ArrayList<ACOrgUnit>();
        for (ACOrgUnit orgUnit : this.getServerSpace().getUsers()) {
            for (Role role : orgUnit.getRoles()) {
                if (!this.isServerAdmin(role) && !role.getProjects().contains((Object)projectId)) continue;
                result.add((ACOrgUnit)ModelUtil.clone((EObject)orgUnit));
            }
        }
        for (ACOrgUnit orgUnit : this.getServerSpace().getGroups()) {
            for (Role role : orgUnit.getRoles()) {
                if (!this.isServerAdmin(role) && !role.getProjects().contains((Object)projectId)) continue;
                result.add((ACOrgUnit)ModelUtil.clone((EObject)orgUnit));
            }
        }
        this.clearMembersFromGroups(result);
        return result;
    }

    @Override
    public void addParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participant) throws ESException {
        if (sessionId == null || projectId == null || participant == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        projectId = this.getProjectId(projectId);
        ACOrgUnit orgUnit = this.getOrgUnit(participant);
        for (Role role : orgUnit.getRoles()) {
            if (!role.getProjects().contains((Object)projectId)) continue;
            return;
        }
        for (Role role : orgUnit.getRoles()) {
            if (!this.isReader(role)) continue;
            role.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)projectId)));
            this.save();
            return;
        }
        ReaderRole reader = RolesFactory.eINSTANCE.createReaderRole();
        reader.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)projectId)));
        orgUnit.getRoles().add((Object)reader);
        this.save();
    }

    private ProjectId getProjectId(ProjectId projectId) throws ESException {
        for (ProjectHistory projectHistory : this.getServerSpace().getProjects()) {
            if (!projectHistory.getProjectId().equals(projectId)) continue;
            return projectHistory.getProjectId();
        }
        throw new ESException("Unknown ProjectId.");
    }

    @Override
    public void removeParticipant(SessionId sessionId, ProjectId projectId, ACOrgUnitId participant) throws ESException {
        if (sessionId == null || projectId == null || participant == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        projectId = this.getProjectId(projectId);
        ACOrgUnit orgUnit = this.getOrgUnit(participant);
        for (Role role : orgUnit.getRoles()) {
            if (!role.getProjects().contains((Object)projectId)) continue;
            role.getProjects().remove((Object)projectId);
            this.save();
            return;
        }
    }

    @Override
    public Role getRole(SessionId sessionId, ProjectId projectId, ACOrgUnitId orgUnitId) throws ESException {
        if (sessionId == null || projectId == null || orgUnitId == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        projectId = this.getProjectId(projectId);
        ACOrgUnit oUnit = this.getOrgUnit(orgUnitId);
        for (Role role : oUnit.getRoles()) {
            if (!this.isServerAdmin(role) && !role.getProjects().contains((Object)projectId)) continue;
            return role;
        }
        throw new ESException("Couldn't find given OrgUnit.");
    }

    @Override
    public void changeRole(SessionId sessionId, ProjectId projectId, ACOrgUnitId orgUnitId, EClass roleClass) throws ESException {
        if (sessionId == null || projectId == null || orgUnitId == null || roleClass == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        projectId = this.getProjectId(projectId);
        ACOrgUnit orgUnit = this.getOrgUnit(orgUnitId);
        Role role = this.getRole(projectId, orgUnit);
        if (role != null) {
            role.getProjects().remove((Object)projectId);
            if (role.getProjects().size() == 0) {
                orgUnit.getRoles().remove((Object)role);
            }
        }
        if (roleClass.getName().equals(RolesPackage.Literals.SERVER_ADMIN.getName())) {
            orgUnit.getRoles().add((Object)RolesFactory.eINSTANCE.createServerAdmin());
            this.save();
            return;
        }
        for (Role role1 : orgUnit.getRoles()) {
            if (!role1.eClass().getName().equals(roleClass.getName())) continue;
            role1.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)projectId)));
            this.save();
            return;
        }
        Role newRole = (Role)RolesPackage.eINSTANCE.getEFactoryInstance().create((EClass)RolesPackage.eINSTANCE.getEClassifier(roleClass.getName()));
        newRole.getProjects().add((Object)((ProjectId)ModelUtil.clone((EObject)projectId)));
        orgUnit.getRoles().add((Object)newRole);
        this.save();
    }

    @Override
    public List<ACUser> getUsers(SessionId sessionId) throws ESException {
        if (sessionId == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        ArrayList<ACUser> result = new ArrayList<ACUser>();
        for (ACUser user : this.getServerSpace().getUsers()) {
            result.add(user);
        }
        return result;
    }

    @Override
    public List<ACOrgUnit> getOrgUnits(SessionId sessionId) throws ESException {
        if (sessionId == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        ArrayList<ACOrgUnit> result = new ArrayList<ACOrgUnit>();
        for (ACOrgUnit user : this.getServerSpace().getUsers()) {
            result.add((ACOrgUnit)ModelUtil.clone((EObject)user));
        }
        for (ACOrgUnit group : this.getServerSpace().getGroups()) {
            result.add((ACOrgUnit)ModelUtil.clone((EObject)group));
        }
        this.clearMembersFromGroups(result);
        return result;
    }

    @Override
    public List<ProjectInfo> getProjectInfos(SessionId sessionId) throws ESException {
        if (sessionId == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        ArrayList<ProjectInfo> result = new ArrayList<ProjectInfo>();
        for (ProjectHistory ph : this.getServerSpace().getProjects()) {
            result.add(this.getProjectInfo(ph));
        }
        return result;
    }

    @Override
    public ACOrgUnitId createUser(SessionId sessionId, String name) throws ESException {
        if (sessionId == null || name == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        if (this.userExists(name)) {
            throw new InvalidInputException("username '" + name + "' already exists.");
        }
        ACUser acUser = AccesscontrolFactory.eINSTANCE.createACUser();
        acUser.setName(name);
        acUser.setDescription(" ");
        this.getServerSpace().getUsers().add((Object)acUser);
        this.save();
        return (ACOrgUnitId)ModelUtil.clone((EObject)acUser.getId());
    }

    private boolean userExists(String name) {
        for (ACUser user : this.getServerSpace().getUsers()) {
            if (!user.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteUser(SessionId sessionId, ACOrgUnitId user) throws ESException {
        if (sessionId == null || user == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        for (ACUser next : this.getServerSpace().getUsers()) {
            if (!next.getId().equals(user)) continue;
            EcoreUtil.delete((EObject)next);
            this.save();
            return;
        }
    }

    @Override
    public void changeOrgUnit(SessionId sessionId, ACOrgUnitId orgUnitId, String name, String description) throws ESException {
        if (sessionId == null || orgUnitId == null || name == null || description == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        ACOrgUnit ou = this.getOrgUnit(orgUnitId);
        ou.setName(name);
        ou.setDescription(description);
        this.save();
    }

    @Override
    public ACOrgUnit getOrgUnit(SessionId sessionId, ACOrgUnitId orgUnitId) throws ESException {
        if (sessionId == null || orgUnitId == null) {
            throw new InvalidInputException();
        }
        this.getAuthorizationControl().checkServerAdminAccess(sessionId);
        ACOrgUnit orgUnit = (ACOrgUnit)ModelUtil.clone((EObject)this.getOrgUnit(orgUnitId));
        this.clearMembersFromGroup(orgUnit);
        return orgUnit;
    }

    private void clearMembersFromGroups(Collection<ACOrgUnit> orgUnits) {
        for (ACOrgUnit orgUnit : orgUnits) {
            this.clearMembersFromGroup(orgUnit);
        }
    }

    private void clearMembersFromGroup(ACOrgUnit orgUnit) {
        if (orgUnit instanceof ACGroup) {
            ((ACGroup)orgUnit).getMembers().clear();
        }
    }

    private boolean isServerAdmin(Role role) {
        return role.eClass().getName().equals(RolesPackage.Literals.SERVER_ADMIN.getName());
    }

    private boolean isReader(Role role) {
        return role.eClass().getName().equals(RolesPackage.Literals.READER_ROLE.getName());
    }

    private ProjectInfo getProjectInfo(ProjectHistory project) {
        ProjectInfo info = ModelFactory.eINSTANCE.createProjectInfo();
        info.setName(project.getProjectName());
        info.setDescription(project.getProjectDescription());
        info.setProjectId((ProjectId)ModelUtil.clone((EObject)project.getProjectId()));
        info.setVersion(project.getLastVersion().getPrimarySpec());
        return info;
    }

    private ACGroup getGroup(ACOrgUnitId orgUnitId) throws ESException {
        for (ACGroup group : this.getServerSpace().getGroups()) {
            if (!group.getId().equals(orgUnitId)) continue;
            return group;
        }
        throw new ESException("Given group doesn't exist.");
    }

    private ACOrgUnit getOrgUnit(ACOrgUnitId orgUnitId) throws ESException {
        for (ACOrgUnit unit : this.getServerSpace().getUsers()) {
            if (!unit.getId().equals(orgUnitId)) continue;
            return unit;
        }
        for (ACOrgUnit unit : this.getServerSpace().getGroups()) {
            if (!unit.getId().equals(orgUnitId)) continue;
            return unit;
        }
        throw new ESException("Given OrgUnit doesn't exist.");
    }

    private Role getRole(ProjectId projectId, ACOrgUnit orgUnit) {
        for (Role role : orgUnit.getRoles()) {
            if (!this.isServerAdmin(role) && !role.getProjects().contains((Object)projectId)) continue;
            return role;
        }
        return null;
    }

    private void save() throws ESException {
        try {
            this.getServerSpace().save();
        }
        catch (IOException e) {
            throw new StorageException("Couldn't save data in database.", e);
        }
        catch (NullPointerException e) {
            throw new StorageException("Couldn't save data in database.", e);
        }
    }

    @Override
    protected void initSubInterfaces() throws FatalESException {
    }
}

