/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.controller;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.callbacks.ESUpdateCallback;
import org.eclipse.emf.emfstore.client.exceptions.ESProjectNotSharedException;
import org.eclipse.emf.emfstore.client.observer.ESUpdateObserver;
import org.eclipse.emf.emfstore.common.model.ESModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.client.common.UnknownEMFStoreWorkloadCommand;
import org.eclipse.emf.emfstore.internal.client.model.Configuration;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.controller.Messages;
import org.eclipse.emf.emfstore.internal.client.model.exceptions.ChangeConflictException;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ChangeConflictSet;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ConflictDetector;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ModelElementIdToEObjectMappingImpl;
import org.eclipse.emf.emfstore.internal.server.impl.api.ESConflictSetImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.ChangePackageContainer;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.ChangePackageUtil;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;
import org.eclipse.emf.emfstore.server.ESConflictSet;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateController
extends ServerCall<PrimaryVersionSpec> {
    private final VersionSpec version;
    private final ESUpdateCallback callback;

    public UpdateController(ProjectSpaceBase projectSpace, VersionSpec version, ESUpdateCallback callback, IProgressMonitor progress) {
        super(projectSpace);
        if (!projectSpace.isShared()) {
            throw new ESProjectNotSharedException();
        }
        if (version == null) {
            version = Versions.createHEAD((VersionSpec)projectSpace.getBaseVersion());
        }
        if (callback == null) {
            callback = ESUpdateCallback.NOCALLBACK;
        }
        this.version = version;
        this.callback = callback;
        this.setProgressMonitor(progress);
    }

    @Override
    protected PrimaryVersionSpec run() throws ESException {
        return this.doUpdate(this.version);
    }

    private PrimaryVersionSpec doUpdate(VersionSpec version) throws ChangeConflictException, ESException {
        ChangeConflictSet changeConflictSet;
        this.getProgressMonitor().beginTask(Messages.UpdateController_UpdatingProject, 100);
        this.getProgressMonitor().worked(1);
        this.getProgressMonitor().subTask(Messages.UpdateController_ResolvingNewVersion);
        PrimaryVersionSpec resolvedVersion = this.getProjectSpace().resolveVersionSpec(version, this.getProgressMonitor());
        if (this.equalsBaseVersion(resolvedVersion)) {
            return resolvedVersion;
        }
        this.getProgressMonitor().worked(5);
        if (this.getProgressMonitor().isCanceled()) {
            return this.getProjectSpace().getBaseVersion();
        }
        this.getProgressMonitor().subTask(Messages.UpdateController_FetchingChanges);
        List<AbstractChangePackage> incomingChanges = this.getIncomingChanges(resolvedVersion);
        this.checkAndRemoveDuplicateOperations(incomingChanges);
        AbstractChangePackage copiedLocalChangedPackage = ChangePackageUtil.createChangePackage((boolean)Configuration.getClientBehavior().useInMemoryChangePackage());
        ESCloseableIterable operations = this.getProjectSpace().getLocalChangePackage().operations();
        try {
            for (AbstractOperation operation : operations.iterable()) {
                copiedLocalChangedPackage.add((AbstractOperation)ModelUtil.clone((EObject)operation));
            }
        }
        finally {
            operations.close();
        }
        ModelElementIdToEObjectMappingImpl idToEObjectMapping = new ModelElementIdToEObjectMappingImpl((ModelElementIdToEObjectMapping)this.getProjectSpace().getProject(), incomingChanges);
        idToEObjectMapping.put(copiedLocalChangedPackage);
        this.getProgressMonitor().worked(65);
        if (this.getProgressMonitor().isCanceled()) {
            return this.getProjectSpace().getBaseVersion();
        }
        this.getProgressMonitor().subTask(Messages.UpdateController_CheckingForConflicts);
        ArrayList<ESChangePackage> incomingAPIChangePackages = new ArrayList<ESChangePackage>();
        for (AbstractChangePackage incomingChange : incomingChanges) {
            incomingAPIChangePackages.add(incomingChange.toAPI());
        }
        if (this.getProgressMonitor().isCanceled() || !this.callback.inspectChanges(this.getProjectSpace().toAPI(), incomingAPIChangePackages, (ESModelElementIdToEObjectMapping)idToEObjectMapping.toAPI())) {
            return this.getProjectSpace().getBaseVersion();
        }
        ((ESUpdateObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESUpdateObserver.class, true)).inspectChanges(this.getProjectSpace().toAPI(), incomingAPIChangePackages, this.getProgressMonitor());
        if (!this.getProjectSpace().getLocalChangePackage().isEmpty() && (changeConflictSet = this.calcConflicts(copiedLocalChangedPackage, incomingChanges, idToEObjectMapping)).getConflictBuckets().size() > 0) {
            this.getProgressMonitor().subTask(Messages.UpdateController_ConflictsDetected);
            if (this.callback.conflictOccurred((ESConflictSet)new ESConflictSetImpl(changeConflictSet), this.getProgressMonitor())) {
                ArrayList myChanges = Lists.newArrayList();
                myChanges.add(copiedLocalChangedPackage);
                copiedLocalChangedPackage = this.getProjectSpace().mergeResolvedConflicts(changeConflictSet, myChanges, incomingChanges);
            } else {
                throw new ChangeConflictException(changeConflictSet);
            }
        }
        this.getProgressMonitor().worked(15);
        this.getProgressMonitor().subTask(Messages.UpdateController_ApplyingChanges);
        this.getProjectSpace().applyChanges(resolvedVersion, incomingChanges, copiedLocalChangedPackage, this.getProgressMonitor(), true);
        ((ESUpdateObserver)ESWorkspaceProviderImpl.getObserverBus().notify(ESUpdateObserver.class, true)).updateCompleted(this.getProjectSpace().toAPI(), this.getProgressMonitor());
        return this.getProjectSpace().getBaseVersion();
    }

    private boolean equalsBaseVersion(PrimaryVersionSpec resolvedVersion) {
        return resolvedVersion.compareTo((Object)this.getProjectSpace().getBaseVersion()) == 0;
    }

    private List<AbstractChangePackage> getIncomingChanges(final PrimaryVersionSpec resolvedVersion) throws ESException {
        List changePackages = (List)new UnknownEMFStoreWorkloadCommand<List<AbstractChangePackage>>(this.getProgressMonitor()){

            @Override
            public List<AbstractChangePackage> run(IProgressMonitor monitor) throws ESException {
                return UpdateController.this.getConnectionManager().getChanges(UpdateController.this.getSessionId(), UpdateController.this.getProjectSpace().getProjectId(), (VersionSpec)UpdateController.this.getProjectSpace().getBaseVersion(), (VersionSpec)resolvedVersion);
            }
        }.execute();
        return changePackages;
    }

    private ChangeConflictSet calcConflicts(AbstractChangePackage localChanges, List<AbstractChangePackage> changes, ModelElementIdToEObjectMappingImpl idToEObjectMapping) {
        ConflictDetector conflictDetector = new ConflictDetector();
        return conflictDetector.calculateConflicts(Collections.singletonList(localChanges), changes, (ModelElementIdToEObjectMapping)idToEObjectMapping);
    }

    private void checkAndRemoveDuplicateOperations(List<AbstractChangePackage> incomingChanges) {
        int baseVersionDelta = this.removeFromChangePackages(incomingChanges);
        if (baseVersionDelta == 0) {
            return;
        }
        PrimaryVersionSpec baseVersion = this.getProjectSpace().getBaseVersion();
        baseVersion.setIdentifier(baseVersion.getIdentifier() + baseVersionDelta);
        ModelUtil.logError((String)MessageFormat.format(String.valueOf(Messages.UpdateController_ChangePackagesRemoved) + Messages.UpdateController_PullingUpBaseVersion, baseVersionDelta, baseVersion.getIdentifier(), baseVersion.getIdentifier() + baseVersionDelta));
        this.getProjectSpace().save();
    }

    public int removeFromChangePackages(List<AbstractChangePackage> incomingChanges) {
        Iterator<AbstractChangePackage> incomingChangesIterator = incomingChanges.iterator();
        int baseVersionDelta = 0;
        while (incomingChangesIterator.hasNext()) {
            AbstractChangePackage incomingChangePackage = incomingChangesIterator.next();
            boolean hasBeenConsumed = this.removeDuplicateOperations(incomingChangePackage, this.getProjectSpace().getLocalChangePackage());
            if (!hasBeenConsumed) break;
            ++baseVersionDelta;
            incomingChangesIterator.remove();
        }
        return baseVersionDelta;
    }

    public boolean removeDuplicateOperations(AbstractChangePackage incomingChanges, AbstractChangePackage localChanges) {
        if (localChanges.size() == 0) {
            return false;
        }
        final AbstractChangePackage tempChangePackage = ChangePackageUtil.createChangePackage((boolean)Configuration.getClientBehavior().useInMemoryChangePackage());
        ESCloseableIterable localOperations = localChanges.operations();
        ESCloseableIterable incomingOps = incomingChanges.operations();
        int incomingOpsSize = incomingChanges.size();
        int incomingIdx = 0;
        boolean operationMatchingStarted = false;
        try {
            Iterator localOperationsIterator = localOperations.iterable().iterator();
            Iterator incomingOpsIterator = incomingOps.iterable().iterator();
            while (localOperationsIterator.hasNext()) {
                final AbstractOperation localOp = (AbstractOperation)localOperationsIterator.next();
                if (incomingIdx == incomingOpsSize) {
                    new EMFStoreCommand(){

                        protected void doRun() {
                            tempChangePackage.add((AbstractOperation)ModelUtil.clone((EObject)localOp));
                        }
                    }.run(false);
                    while (localOperationsIterator.hasNext()) {
                        AbstractOperation next = (AbstractOperation)localOperationsIterator.next();
                        tempChangePackage.add((AbstractOperation)ModelUtil.clone((EObject)next));
                    }
                    return true;
                }
                AbstractOperation incomingOp = (AbstractOperation)incomingOpsIterator.next();
                ++incomingIdx;
                if (incomingOp.getIdentifier().equals(localOp.getIdentifier())) {
                    operationMatchingStarted = true;
                    continue;
                }
                tempChangePackage.add((AbstractOperation)ModelUtil.clone((EObject)localOp));
                while (localOperationsIterator.hasNext()) {
                    tempChangePackage.add((AbstractOperation)ModelUtil.clone((EObject)((AbstractOperation)localOperationsIterator.next())));
                }
                if (operationMatchingStarted) {
                    ModelUtil.logError((String)Messages.UpdateController_IncomingOperationsOnlyPartlyMatch);
                    throw new IllegalStateException(Messages.UpdateController_IncomingOpsPartlyMatched);
                }
                return false;
            }
            if (incomingIdx == incomingOpsSize) {
                return true;
            }
            ModelUtil.logError((String)Messages.UpdateController_IncomingOperationsNotFullyConsumed);
            throw new IllegalStateException(Messages.UpdateController_IncomingOpsNotConsumed);
        }
        finally {
            localOperations.close();
            incomingOps.close();
            if (incomingIdx == incomingOpsSize) {
                tempChangePackage.attachToProjectSpace((ChangePackageContainer)this.getProjectSpace());
            }
        }
    }
}

