/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.wireadmin;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import org.eclipse.equinox.internal.util.ref.Log;
import org.eclipse.equinox.internal.wireadmin.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.TopicPermission;
import org.osgi.service.wireadmin.Wire;
import org.osgi.service.wireadmin.WireAdminEvent;
import org.osgi.service.wireadmin.WireAdminListener;
import org.osgi.util.tracker.ServiceTracker;

public class WireReDispatcher
implements WireAdminListener {
    static final String BUNDLE = "bundle";
    static final String BUNDLE_ID = "bundle.id";
    static final String BUNDLE_SYMBOLICNAME = "bundle.symbolicName";
    static final String EVENT = "event";
    static final String EXCEPTION = "exception";
    static final String EXCEPTION_CLASS = "exception.class";
    static final String EXCEPTION_MESSAGE = "exception.message";
    static final String SERVICE = "service";
    static final String SERVICE_ID = "service.id";
    static final String SERVICE_OBJECTCLASS = "service.objectClass";
    static final String SERVICE_PID = "service.pid";
    static final char TOPIC_SEPARATOR = '/';
    static final String WIRE_HEADER = "org/osgi/service/wireadmin/WireAdminEvent";
    static final String WIRE_CREATED = "WIRE_CREATED";
    static final String WIRE_CONNECTED = "WIRE_CONNECTED";
    static final String WIRE_UPDATED = "WIRE_UPDATED";
    static final String WIRE_TRACE = "WIRE_TRACE";
    static final String WIRE_DISCONNECTED = "WIRE_DISCONNECTED";
    static final String WIRE_DELETED = "WIRE_DELETED";
    static final String PRODUCER_EXCEPTION = "PRODUCER_EXCEPTION";
    static final String CONSUMER_EXCEPTION = "CONSUMER_EXCEPTION";
    static final String WIRE_ENTRY = "wire.entry";
    static final String WA_WIRE = "wire";
    static final String WA_WIRE_FLAVORS = "wire.flavors";
    static final String WA_WIRE_SCOPE = "wire.scope";
    static final String WA_WIRE_CONNECTED = "wire.connected";
    static final String WA_WIRE_VALID = "wire.valid";
    BundleContext bc;
    ServiceRegistration waReg;
    Log log;
    ServiceTracker eventAdminTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void start(BundleContext bc) throws Exception {
        this.bc = bc;
        this.log = new Log(bc, false);
        this.log.setDebug(Activator.getBoolean("equinox.wireadmin.redispatcher.debug"));
        this.log.setPrintOnConsole(Activator.getBoolean("equinox.wireadmin.redispatcher.console"));
        Hashtable<String, Integer> props = new Hashtable<String, Integer>(3);
        props.put("wireadmin.events", new Integer(Integer.MAX_VALUE));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.wireadmin.WireAdminListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.waReg = bc.registerService(clazz.getName(), (Object)this, props);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.event.EventAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventAdminTracker = new ServiceTracker(bc, clazz2.getName(), null);
        this.eventAdminTracker.open();
    }

    public void stop() throws Exception {
        if (this.eventAdminTracker != null) {
            this.eventAdminTracker.close();
            this.eventAdminTracker = null;
        }
        if (this.waReg != null) {
            this.waReg.unregister();
            this.waReg = null;
        }
        this.log.close();
        this.bc = null;
    }

    void addExceptionProps(Hashtable props, Throwable t) {
        props.put(EXCEPTION, t);
        props.put(EXCEPTION_CLASS, t.getClass().getName());
        String message = t.getMessage();
        if (message != null) {
            props.put(EXCEPTION_MESSAGE, t.getMessage());
        }
    }

    void addServiceProps(Hashtable props, ServiceReference ref) {
        props.put(SERVICE, ref);
        props.put(SERVICE_ID, ref.getProperty(SERVICE_ID));
        Object tmp = ref.getProperty(SERVICE_PID);
        if (tmp != null && tmp instanceof String) {
            props.put(SERVICE_PID, tmp);
        }
        if ((tmp = ref.getProperty("objectClass")) != null && tmp instanceof String[]) {
            props.put(SERVICE_OBJECTCLASS, tmp);
        }
    }

    public void wireAdminEvent(WireAdminEvent event) {
        EventAdmin eventAdmin;
        ServiceTracker st = this.eventAdminTracker;
        EventAdmin eventAdmin2 = eventAdmin = st == null ? null : (EventAdmin)st.getService();
        if (eventAdmin != null) {
            Throwable throwable;
            ServiceReference ref = event.getServiceReference();
            if (ref == null) {
                throw new RuntimeException("Wire Admin ServiceReference is null");
            }
            String topicSuffix = null;
            switch (event.getType()) {
                case 4: {
                    topicSuffix = WIRE_CREATED;
                    break;
                }
                case 32: {
                    topicSuffix = WIRE_CONNECTED;
                    break;
                }
                case 8: {
                    topicSuffix = WIRE_UPDATED;
                    break;
                }
                case 128: {
                    topicSuffix = WIRE_TRACE;
                    break;
                }
                case 64: {
                    topicSuffix = WIRE_DISCONNECTED;
                    break;
                }
                case 16: {
                    topicSuffix = WIRE_DELETED;
                    break;
                }
                case 1: {
                    topicSuffix = PRODUCER_EXCEPTION;
                    break;
                }
                case 2: {
                    topicSuffix = CONSUMER_EXCEPTION;
                    break;
                }
                default: {
                    return;
                }
            }
            String topic = "org/osgi/service/wireadmin/WireAdminEvent/" + topicSuffix;
            if (!this.hasServiceReferences(topic)) {
                if (Activator.LOG_DEBUG) {
                    this.log.debug(0, 10017, event.toString(), null, false);
                }
                return;
            }
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            this.addServiceProps(props, ref);
            Wire wire = event.getWire();
            if (wire != null) {
                props.put(WA_WIRE, wire);
                props.put(WA_WIRE_CONNECTED, new Boolean(wire.isConnected()));
                if (wire.getFlavors() != null) {
                    props.put(WA_WIRE_FLAVORS, wire.getFlavors());
                }
                if (wire.getScope() != null) {
                    props.put(WA_WIRE_SCOPE, wire.getScope());
                }
                props.put(WA_WIRE_VALID, new Boolean(wire.isValid()));
            }
            if ((throwable = event.getThrowable()) != null) {
                this.addExceptionProps(props, throwable);
            }
            props.put(EVENT, event);
            final Event eaEvent = new Event(topic, props);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    eventAdmin.postEvent(eaEvent);
                    return null;
                }
            });
            if (Activator.LOG_DEBUG) {
                this.log.debug(0, 10018, event.toString(), null, false);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasServiceReferences(String topic) {
        BundleContext l_bc = this.bc;
        if (l_bc == null) {
            return false;
        }
        ServiceReference[] sr = null;
        try {
            Class<?> clazz = class$2;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.osgi.service.event.EventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$2 = clazz2;
            }
            sr = l_bc.getServiceReferences(clazz.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
        if (sr != null && sr.length > 0) {
            TopicPermission perm = new TopicPermission(topic, "subscribe");
            int i = 0;
            while (i < sr.length) {
                try {
                    Object reftopic;
                    ServiceReference sRef = sr[i];
                    Bundle bundle = sRef.getBundle();
                    if (bundle != null && bundle.getState() != 1 && bundle.hasPermission((Object)perm) && (reftopic = sRef.getProperty("event.topics")) != null && reftopic instanceof String[]) {
                        String[] topics = (String[])reftopic;
                        int j = 0;
                        while (j < topics.length) {
                            if (WireReDispatcher.matchTopic(topics[j], topic)) {
                                return true;
                            }
                            ++j;
                        }
                    }
                }
                catch (Throwable t) {
                    this.log.error("Error while checking bundle permissions", t);
                }
                ++i;
            }
        }
        return false;
    }

    protected static boolean matchTopic(String pattern, String topic) {
        if (pattern.length() > topic.length()) {
            return false;
        }
        if ("*".equals(pattern) || pattern.equals(topic)) {
            return true;
        }
        int index = pattern.indexOf(47);
        if (index == -1 || index == 0 || index == pattern.length() - 1) {
            return false;
        }
        index = 0;
        while (index < pattern.length()) {
            if (pattern.charAt(index) == '*') {
                if (pattern.charAt(index - 1) != '/') {
                    return false;
                }
                return index == pattern.length() - 1;
            }
            if (pattern.charAt(index) != topic.charAt(index)) {
                return false;
            }
            ++index;
        }
        if (index != topic.length()) {
            return false;
        }
        return pattern.charAt(index - 1) != '/';
    }
}

