/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import java.util.HashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIActivator;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleContext;

public class ProfileFactory {
    private static String FLAVOR_DEFAULT = "tooling";
    private static String EMPTY = "";
    private static EnvironmentInfo info;
    static /* synthetic */ Class class$0;

    public static IProfile makeProfile(String profileId) {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", ProfileFactory.getDefaultLocation());
        profileProperties.put("org.eclipse.equinox.p2.environments", ProfileFactory.getDefaultEnvironments());
        profileProperties.put("org.eclipse.equinox.p2.nl", ProfileFactory.getDefaultNL());
        try {
            return ProvAdminUIActivator.getDefault().getProfileRegistry().addProfile(profileId, profileProperties);
        }
        catch (ProvisionException provisionException) {
            return null;
        }
    }

    public static String getDefaultLocation() {
        return Platform.getUserLocation().getURL().getPath();
    }

    public static String getDefaultFlavor() {
        return FLAVOR_DEFAULT;
    }

    private static EnvironmentInfo getEnvironmentInfo() {
        if (info == null) {
            BundleContext bundleContext = ProvUIActivator.getContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        }
        return info;
    }

    public static String getDefaultNL() {
        if (ProfileFactory.getEnvironmentInfo() != null) {
            return info.getNL();
        }
        return EMPTY;
    }

    public static String getDefaultEnvironments() {
        if (ProfileFactory.getEnvironmentInfo() != null) {
            return "osgi.os=" + info.getOS() + ",osgi.ws=" + info.getWS() + ",osgi.arch=" + info.getOSArch();
        }
        return EMPTY;
    }
}

