/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.jmx.internal.client.ui.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.jmx.internal.client.ui.viewsupport.ImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class ByteImageRegistry
extends ImageRegistry {
    Map cache;

    public Image getImage(byte[] imageData) throws IOException {
        Image result = (Image)this.getCache().get(imageData);
        if (result == null) {
            result = super.get(ByteImageRegistry.createImageDescriptorFromByteArray(imageData));
            this.getCache().put(imageData, result);
        }
        return result;
    }

    public Map getCache() {
        if (this.cache == null) {
            this.cache = new HashMap(10);
        }
        return this.cache;
    }

    public void dispose() {
        this.getCache().clear();
        super.dispose();
    }

    public static ImageDescriptor createImageDescriptorFromByteArray(byte[] imageData) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(imageData);
        ImageDescriptor desc = ImageDescriptor.createFromImageData((ImageData)new ImageData((InputStream)is));
        is.close();
        return desc;
    }
}

