/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.names.NameScope;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DefaultNameGenerator
implements NameGenerator {
    static final char DEFAULT_CHAR = 'x';
    private final PlcTarget target;
    private final NameScope globalScope = new NameScope();
    private final NameScope unionLocalScopes = new NameScope();
    private final boolean warnOnRename;
    private final WarnOutput warnOutput;

    public DefaultNameGenerator(PlcTarget target, PlcGenSettings settings) {
        this.target = target;
        this.warnOnRename = settings.warnOnRename;
        this.warnOutput = settings.warnOutput;
    }

    @Override
    public void addDisallowedNames(Collection<String> names) {
        for (String name : names) {
            this.globalScope.addName(name);
        }
    }

    @Override
    public String generateGlobalName(PositionObject posObject) {
        return this.generateGlobalNames(Set.of(""), posObject);
    }

    @Override
    public String generateGlobalNames(Set<String> prefixes, PositionObject posObject) {
        String absName;
        String string = absName = posObject instanceof Specification ? "specification" : CifTextUtils.getAbsName((PositionObject)posObject, (boolean)false);
        if (absName.endsWith(".")) {
            absName = Strings.slice((String)absName, null, (Integer)-1);
        }
        return this.generateGlobalNames(prefixes, absName, !(posObject instanceof Specification));
    }

    @Override
    public String generateGlobalName(String initialName, boolean isCifName) {
        return this.generateGlobalNames(Set.of(""), initialName, isCifName);
    }

    @Override
    public String generateGlobalNames(Set<String> prefixes, String initialName, boolean isCifName) {
        return this.generateNames(prefixes, initialName, isCifName, this.globalScope, this.unionLocalScopes, null);
    }

    @Override
    public String generateLocalName(String initialName, NameScope localScope) {
        return this.generateLocalNames(Set.of(""), initialName, localScope);
    }

    @Override
    public String generateLocalNames(Set<String> prefixes, String initialName, NameScope localScope) {
        return this.generateNames(prefixes, initialName, false, localScope, this.globalScope, this.unionLocalScopes);
    }

    private String generateNames(Set<String> prefixes, String initialName, boolean isCifName, NameScope usageScope, NameScope testScope, NameScope updateScope) {
        String goodName;
        String candidateLowerCleaned;
        String cleanedName = this.cleanName(initialName);
        String lowerCleanedName = cleanedName.toString().toLowerCase(Locale.US);
        List<String> lowerPrefixes = prefixes.stream().map(s -> s.toLowerCase(Locale.US)).toList();
        int number = 0;
        while (true) {
            candidateLowerCleaned = number == 0 ? lowerCleanedName : lowerCleanedName + "_" + number;
            boolean isBad = lowerPrefixes.stream().map(prefix -> prefix + candidateLowerCleaned).anyMatch(testName -> usageScope.isNameUsed((String)testName) || testScope.isNameUsed((String)testName) || !this.target.isAllowedName((String)testName));
            if (!isBad) break;
            ++number;
        }
        for (String prefix2 : lowerPrefixes) {
            String addedLowerCleanedName = prefix2 + candidateLowerCleaned;
            usageScope.addName(addedLowerCleanedName);
            if (updateScope == null) continue;
            updateScope.addName(addedLowerCleanedName);
        }
        String string = goodName = number == 0 ? cleanedName : cleanedName + "_" + number;
        if (isCifName && this.warnOnRename && number > 0) {
            this.warnOutput.line("Renaming \"%s\" to \"%s\".", new Object[]{initialName, goodName});
        }
        return goodName;
    }

    private String cleanName(String text) {
        StringBuilder sb = new StringBuilder(text.length() + 4 + 1 + 3);
        char[] data = text.toCharArray();
        int inputIndex = 0;
        while (inputIndex < data.length) {
            int length = this.matchGoodChars(data, inputIndex);
            if (length > 0 && Character.isDigit(data[inputIndex])) {
                sb.append('x');
            }
            sb.append(data, inputIndex, length);
            if ((inputIndex += length) == data.length) break;
            length = this.matchBadChars(data, inputIndex);
            if (sb.isEmpty() || (inputIndex += length) >= data.length) continue;
            sb.append('_');
        }
        if (sb.isEmpty()) {
            sb.append('x');
        }
        return sb.toString();
    }

    private int matchGoodChars(char[] data, int index) {
        int endIndex = index;
        while (endIndex < data.length) {
            char c = data[endIndex];
            if (!Character.isLetter(c) && !Character.isDigit(c)) break;
            ++endIndex;
        }
        return endIndex - index;
    }

    private int matchBadChars(char[] data, int index) {
        int endIndex = index;
        while (endIndex < data.length) {
            char c = data[endIndex];
            if (Character.isLetter(c) || Character.isDigit(c)) break;
            ++endIndex;
        }
        return endIndex - index;
    }
}

