/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetLocationFactory;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IULocationFactory
implements ITargetLocationFactory {
    @Override
    public ITargetLocation getTargetLocation(String type, String serializedXML) throws CoreException {
        Element location;
        try {
            Document document = XmlProcessorFactory.parseWithErrorOnDOCTYPE((InputStream)new ByteArrayInputStream(serializedXML.getBytes(StandardCharsets.UTF_8)));
            location = document.getDocumentElement();
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
        }
        if ("InstallableUnit".equals(type) && location != null) {
            String locationType = location.getAttribute("type");
            if (!type.equals(locationType)) {
                return null;
            }
            String includeMode = location.getAttribute("includeMode");
            String includeAllPlatforms = location.getAttribute("includeAllPlatforms");
            String includeSource = location.getAttribute("includeSource");
            String includeConfigurePhase = location.getAttribute("includeConfigurePhase");
            String followRepositoryReferences = location.getAttribute("followRepositoryReferences");
            NodeList list = location.getChildNodes();
            ArrayList<String> ids = new ArrayList<String>();
            ArrayList<String> versions = new ArrayList<String>();
            ArrayList<URI> repos = new ArrayList<URI>();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node.getNodeType() == 1) {
                    String loc;
                    Element element = (Element)node;
                    if (element.getNodeName().equalsIgnoreCase("unit")) {
                        String id = element.getAttribute("id");
                        if (id.length() > 0) {
                            ids.add(id);
                            versions.add(element.getAttribute("version"));
                        }
                    } else if (element.getNodeName().equalsIgnoreCase("repository") && (loc = element.getAttribute("location")).length() > 0) {
                        try {
                            repos.add(new URI(loc));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
            int flags = 1;
            if (includeMode != null && includeMode.trim().length() > 0 && includeMode.equals("slicer")) {
                flags = 0;
            }
            flags |= Boolean.parseBoolean(includeAllPlatforms) ? 2 : 0;
            flags |= Boolean.parseBoolean(includeSource) ? 4 : 0;
            flags |= Boolean.parseBoolean(includeConfigurePhase) ? 8 : 0;
            flags = followRepositoryReferences.isEmpty() ? (flags |= 0x10) : (flags |= Boolean.parseBoolean(followRepositoryReferences) ? 16 : 0);
            return TargetPlatformService.getDefault().newIULocation((String[])ids.toArray(String[]::new), (String[])versions.toArray(String[]::new), (URI[])repos.toArray(URI[]::new), flags);
        }
        return null;
    }
}

