/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import java.util.List;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.tooldef.metamodel.tooldef.Declaration;
import org.eclipse.escet.tooldef.metamodel.tooldef.Import;
import org.eclipse.escet.tooldef.metamodel.tooldef.Script;
import org.eclipse.escet.tooldef.metamodel.tooldef.Tool;
import org.eclipse.escet.tooldef.metamodel.tooldef.ToolDefTool;
import org.eclipse.escet.tooldef.metamodel.tooldef.TypeDecl;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.AssignmentStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.BreakStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ContinueStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ElifStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ExitStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ForStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.IfStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ReturnStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.ToolInvokeStatement;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.Variable;
import org.eclipse.escet.tooldef.metamodel.tooldef.statements.WhileStatement;
import org.eclipse.escet.tooldef.typechecker.CheckerContext;
import org.eclipse.escet.tooldef.typechecker.Message;

public class ReachabilityChecker {
    private ReachabilityChecker() {
    }

    public static boolean warnNonReachable(List<Declaration> stats, boolean reachable, CheckerContext ctxt) {
        for (Declaration stat : stats) {
            reachable = ReachabilityChecker.warnNonReachable(stat, reachable, ctxt);
        }
        return reachable;
    }

    public static boolean warnNonReachable(Declaration stat, boolean reachable, CheckerContext ctxt) {
        if (!reachable) {
            ctxt.addProblem(Message.STAT_UNREACHABLE, stat.getPosition(), new String[0]);
        }
        if (stat instanceof AssignmentStatement) {
            return reachable;
        }
        if (stat instanceof Import) {
            return reachable;
        }
        if (stat instanceof Script) {
            return reachable;
        }
        if (stat instanceof ToolInvokeStatement) {
            return reachable;
        }
        if (stat instanceof TypeDecl) {
            return reachable;
        }
        if (stat instanceof Variable) {
            return reachable;
        }
        if (stat instanceof BreakStatement) {
            return false;
        }
        if (stat instanceof ContinueStatement) {
            return false;
        }
        if (stat instanceof ExitStatement) {
            return false;
        }
        if (stat instanceof ReturnStatement) {
            return false;
        }
        if (stat instanceof ForStatement) {
            List body = Lists.cast((List)((ForStatement)stat).getStatements());
            ReachabilityChecker.warnNonReachable(body, reachable, ctxt);
            return reachable;
        }
        if (stat instanceof IfStatement) {
            List thens = Lists.cast((List)((IfStatement)stat).getThens());
            boolean reachThens = ReachabilityChecker.warnNonReachable(thens, reachable, ctxt);
            boolean reachElifs = false;
            for (ElifStatement elif : ((IfStatement)stat).getElifs()) {
                List elifThens = Lists.cast((List)elif.getThens());
                boolean reachElif = ReachabilityChecker.warnNonReachable(elifThens, reachable, ctxt);
                reachElifs |= reachElif;
            }
            List elses = Lists.cast((List)((IfStatement)stat).getElses());
            boolean reachElses = ReachabilityChecker.warnNonReachable(elses, reachable, ctxt);
            return reachThens || reachElifs || reachElses;
        }
        if (stat instanceof Tool) {
            Assert.check((boolean)(stat instanceof ToolDefTool));
            List body = Lists.cast((List)((ToolDefTool)stat).getStatements());
            ReachabilityChecker.warnNonReachable(body, true, ctxt);
            return reachable;
        }
        if (stat instanceof WhileStatement) {
            List body = Lists.cast((List)((WhileStatement)stat).getStatements());
            ReachabilityChecker.warnNonReachable(body, reachable, ctxt);
            return reachable;
        }
        throw new RuntimeException("Unknown statement: " + String.valueOf(stat));
    }
}

